/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.sink;

import org.apache.flink.runtime.io.network.api.writer.SubtaskStateMapper;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.table.sink.SinkRecordConverter;

public class BucketStreamPartitioner
extends StreamPartitioner<RowData> {
    private final int numBucket;
    private final TableSchema tableSchema;
    private transient SinkRecordConverter recordConverter;

    public BucketStreamPartitioner(int numBucket, TableSchema tableSchema) {
        this.numBucket = numBucket;
        this.tableSchema = tableSchema;
    }

    public void setup(int numberOfChannels) {
        super.setup(numberOfChannels);
        this.recordConverter = new SinkRecordConverter(this.numBucket, this.tableSchema);
    }

    public int selectChannel(SerializationDelegate<StreamRecord<RowData>> record) {
        RowData row = (RowData)((StreamRecord)record.getInstance()).getValue();
        return this.recordConverter.bucket(row) % this.numberOfChannels;
    }

    public StreamPartitioner<RowData> copy() {
        return this;
    }

    public SubtaskStateMapper getDownstreamSubtaskStateMapper() {
        return SubtaskStateMapper.FULL;
    }

    public boolean isPointwise() {
        return false;
    }

    public String toString() {
        return "bucket-assigner";
    }
}

