/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.sink;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.store.file.data.DataFileMetaSerializer;
import org.apache.flink.table.store.file.mergetree.Increment;
import org.apache.flink.table.store.file.utils.SerializationUtils;
import org.apache.flink.table.store.table.sink.FileCommittable;

public class FileCommittableSerializer
implements SimpleVersionedSerializer<FileCommittable> {
    private final DataFileMetaSerializer dataFileSerializer = new DataFileMetaSerializer();

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(FileCommittable obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper((OutputStream)out);
        SerializationUtils.serializeBinaryRow(obj.partition(), (DataOutputView)view);
        view.writeInt(obj.bucket());
        this.dataFileSerializer.serializeList(obj.increment().newFiles(), (DataOutputView)view);
        this.dataFileSerializer.serializeList(obj.increment().compactBefore(), (DataOutputView)view);
        this.dataFileSerializer.serializeList(obj.increment().compactAfter(), (DataOutputView)view);
        return out.toByteArray();
    }

    public FileCommittable deserialize(int version, byte[] serialized) throws IOException {
        DataInputDeserializer view = new DataInputDeserializer(serialized);
        return new FileCommittable(SerializationUtils.deserializeBinaryRow((DataInputView)view), view.readInt(), new Increment(this.dataFileSerializer.deserializeList((DataInputView)view), this.dataFileSerializer.deserializeList((DataInputView)view), this.dataFileSerializer.deserializeList((DataInputView)view)));
    }
}

