/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.utils.ByteUtils;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class UpdateFeaturesResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    UpdatableFeatureResultCollection results;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The top-level error code, or `0` if there was no top-level error."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The top-level error message, or `null` if there was no top-level error."), new Field("results", new CompactArrayOf(UpdatableFeatureResult.SCHEMA_0), "Results for each feature update."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public UpdateFeaturesResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public UpdateFeaturesResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.results = new UpdatableFeatureResultCollection(0);
    }

    @Override
    public short apiKey() {
        return 57;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _readable.readString(length);
        }
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field results was serialized as null");
        }
        UpdatableFeatureResultCollection newCollection = new UpdatableFeatureResultCollection(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new UpdatableFeatureResult(_readable, _version));
        }
        this.results = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeUnsignedVarint(this.results.size() + 1);
        _stringBytes = this.results.iterator();
        while (_stringBytes.hasNext()) {
            UpdatableFeatureResult resultsElement = (UpdatableFeatureResult)_stringBytes.next();
            resultsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.results.size() + 1));
        for (UpdatableFeatureResult resultsElement : this.results) {
            resultsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UpdateFeaturesResponseData)) {
            return false;
        }
        UpdateFeaturesResponseData other = (UpdateFeaturesResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.results == null ? other.results != null : !this.results.equals(other.results)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.results == null ? 0 : this.results.hashCode());
        return hashCode;
    }

    @Override
    public UpdateFeaturesResponseData duplicate() {
        UpdateFeaturesResponseData _duplicate = new UpdateFeaturesResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        UpdatableFeatureResultCollection newResults = new UpdatableFeatureResultCollection(this.results.size());
        for (UpdatableFeatureResult _element : this.results) {
            newResults.add(_element.duplicate());
        }
        _duplicate.results = newResults;
        return _duplicate;
    }

    public String toString() {
        return "UpdateFeaturesResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", results=" + MessageUtil.deepToString(this.results.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public UpdatableFeatureResultCollection results() {
        return this.results;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public UpdateFeaturesResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public UpdateFeaturesResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public UpdateFeaturesResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public UpdateFeaturesResponseData setResults(UpdatableFeatureResultCollection v) {
        this.results = v;
        return this;
    }

    public static class UpdatableFeatureResultCollection
    extends ImplicitLinkedHashMultiCollection<UpdatableFeatureResult> {
        public UpdatableFeatureResultCollection() {
        }

        public UpdatableFeatureResultCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public UpdatableFeatureResultCollection(Iterator<UpdatableFeatureResult> iterator) {
            super(iterator);
        }

        @Override
        public UpdatableFeatureResult find(String feature) {
            UpdatableFeatureResult _key = new UpdatableFeatureResult();
            _key.setFeature(feature);
            return this.find(_key);
        }

        @Override
        public List<UpdatableFeatureResult> findAll(String feature) {
            UpdatableFeatureResult _key = new UpdatableFeatureResult();
            _key.setFeature(feature);
            return this.findAll(_key);
        }

        public UpdatableFeatureResultCollection duplicate() {
            UpdatableFeatureResultCollection _duplicate = new UpdatableFeatureResultCollection(this.size());
            for (UpdatableFeatureResult _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class UpdatableFeatureResult
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String feature;
        short errorCode;
        String errorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("feature", Type.COMPACT_STRING, "The name of the finalized feature."), new Field("error_code", Type.INT16, "The feature update error code or `0` if the feature update succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The feature update error, or `null` if the feature update succeeded."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public UpdatableFeatureResult(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public UpdatableFeatureResult() {
            this.feature = "";
            this.errorCode = 0;
            this.errorMessage = "";
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of UpdatableFeatureResult");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field feature was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field feature had invalid length " + length);
            }
            this.feature = _readable.readString(length);
            this.errorCode = _readable.readShort();
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _readable.readString(length);
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.feature);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of UpdatableFeatureResult");
            }
            byte[] _stringBytes = this.feature.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'feature' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.feature, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof UpdatableFeatureResult)) {
                return false;
            }
            UpdatableFeatureResult other = (UpdatableFeatureResult)obj;
            return !(this.feature == null ? other.feature != null : !this.feature.equals(other.feature));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UpdatableFeatureResult)) {
                return false;
            }
            UpdatableFeatureResult other = (UpdatableFeatureResult)obj;
            if (this.feature == null ? other.feature != null : !this.feature.equals(other.feature)) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.feature == null ? 0 : this.feature.hashCode());
            return hashCode;
        }

        @Override
        public UpdatableFeatureResult duplicate() {
            UpdatableFeatureResult _duplicate = new UpdatableFeatureResult();
            _duplicate.feature = this.feature;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            return _duplicate;
        }

        public String toString() {
            return "UpdatableFeatureResult(feature=" + (this.feature == null ? "null" : "'" + this.feature.toString() + "'") + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ")";
        }

        public String feature() {
            return this.feature;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public UpdatableFeatureResult setFeature(String v) {
            this.feature = v;
            return this;
        }

        public UpdatableFeatureResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public UpdatableFeatureResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }
    }
}

