/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.lookup;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.store.connector.lookup.LookupTable;
import org.apache.flink.table.store.connector.lookup.RocksDBStateFactory;
import org.apache.flink.table.store.connector.lookup.RocksDBValueState;
import org.apache.flink.table.store.utils.KeyProjectedRowData;
import org.apache.flink.table.store.utils.TypeUtils;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;

public class PrimaryKeyLookupTable
implements LookupTable {
    protected final RocksDBValueState tableState;
    protected final Predicate<RowData> recordFilter;
    protected int[] primaryKeyMapping;
    protected final KeyProjectedRowData primaryKey;

    public PrimaryKeyLookupTable(RocksDBStateFactory stateFactory, RowType rowType, List<String> primaryKey, Predicate<RowData> recordFilter, long lruCacheSize) throws IOException {
        List fieldNames = rowType.getFieldNames();
        this.primaryKeyMapping = primaryKey.stream().mapToInt(fieldNames::indexOf).toArray();
        this.primaryKey = new KeyProjectedRowData(this.primaryKeyMapping);
        this.tableState = stateFactory.valueState("table", (TypeSerializer<RowData>)InternalSerializers.create((RowType)TypeUtils.project(rowType, this.primaryKeyMapping)), (TypeSerializer<RowData>)InternalSerializers.create((RowType)rowType), lruCacheSize);
        this.recordFilter = recordFilter;
    }

    @Override
    public List<RowData> get(RowData key) throws IOException {
        RowData value = this.tableState.get(key);
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }

    @Override
    public void refresh(Iterator<RowData> incremental) throws IOException {
        while (incremental.hasNext()) {
            RowData row = incremental.next();
            this.primaryKey.replaceRow(row);
            if (row.getRowKind() == RowKind.INSERT || row.getRowKind() == RowKind.UPDATE_AFTER) {
                if (this.recordFilter.test(row)) {
                    this.tableState.put(this.primaryKey, row);
                    continue;
                }
                this.tableState.delete(this.primaryKey);
                continue;
            }
            this.tableState.delete(this.primaryKey);
        }
    }
}

