/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.kafka.clients.producer;

import org.apache.flink.table.store.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.table.store.shaded.org.apache.kafka.common.record.DefaultRecord;

public final class RecordMetadata {
    public static final int UNKNOWN_PARTITION = -1;
    private final long offset;
    private final long timestamp;
    private final int serializedKeySize;
    private final int serializedValueSize;
    private final TopicPartition topicPartition;
    private volatile Long checksum;

    public RecordMetadata(TopicPartition topicPartition, long baseOffset, long relativeOffset, long timestamp, Long checksum, int serializedKeySize, int serializedValueSize) {
        this.offset = baseOffset == -1L ? baseOffset : baseOffset + relativeOffset;
        this.timestamp = timestamp;
        this.checksum = checksum;
        this.serializedKeySize = serializedKeySize;
        this.serializedValueSize = serializedValueSize;
        this.topicPartition = topicPartition;
    }

    public boolean hasOffset() {
        return this.offset != -1L;
    }

    public long offset() {
        return this.offset;
    }

    public boolean hasTimestamp() {
        return this.timestamp != -1L;
    }

    public long timestamp() {
        return this.timestamp;
    }

    @Deprecated
    public long checksum() {
        if (this.checksum == null) {
            this.checksum = DefaultRecord.computePartialChecksum(this.timestamp, this.serializedKeySize, this.serializedValueSize);
        }
        return this.checksum;
    }

    public int serializedKeySize() {
        return this.serializedKeySize;
    }

    public int serializedValueSize() {
        return this.serializedValueSize;
    }

    public String topic() {
        return this.topicPartition.topic();
    }

    public int partition() {
        return this.topicPartition.partition();
    }

    public String toString() {
        return this.topicPartition.toString() + "@" + this.offset;
    }
}

