/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.IOException;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointMetadataOutputStream;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.filesystem.FsCheckpointMetadataOutputStream;
import org.apache.flink.runtime.state.memory.MemCheckpointStreamFactory;
import org.apache.flink.util.Preconditions;

public class PersistentMetadataCheckpointStorageLocation
extends MemCheckpointStreamFactory
implements CheckpointStorageLocation {
    private final FileSystem fileSystem;
    private final Path checkpointDirectory;
    private final Path metadataFilePath;

    public PersistentMetadataCheckpointStorageLocation(FileSystem fileSystem, Path checkpointDir, int maxStateSize) {
        super(maxStateSize);
        this.fileSystem = Preconditions.checkNotNull(fileSystem);
        this.checkpointDirectory = Preconditions.checkNotNull(checkpointDir);
        this.metadataFilePath = new Path(checkpointDir, "_metadata");
    }

    @Override
    public CheckpointMetadataOutputStream createMetadataOutputStream() throws IOException {
        return new FsCheckpointMetadataOutputStream(this.fileSystem, this.metadataFilePath, this.checkpointDirectory);
    }

    @Override
    public void disposeOnFailure() throws IOException {
        this.fileSystem.delete(this.checkpointDirectory, true);
    }

    @Override
    public CheckpointStorageLocationReference getLocationReference() {
        return CheckpointStorageLocationReference.getDefault();
    }
}

