/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.util.Preconditions;

public class SubtaskStateStats
implements Serializable {
    private static final long serialVersionUID = 8928594531621862214L;
    private final int subtaskIndex;
    private final long ackTimestamp;
    private final long stateSize;
    private final long checkpointedSize;
    private final long syncCheckpointDuration;
    private final long asyncCheckpointDuration;
    private final long processedData;
    private final long persistedData;
    private final long alignmentDuration;
    private final long checkpointStartDelay;
    private final boolean unalignedCheckpoint;
    private final boolean completed;

    SubtaskStateStats(int subtaskIndex, long ackTimestamp) {
        this(subtaskIndex, ackTimestamp, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, false, true);
    }

    SubtaskStateStats(int subtaskIndex, long ackTimestamp, long checkpointedSize, long stateSize, long syncCheckpointDuration, long asyncCheckpointDuration, long processedData, long persistedData, long alignmentDuration, long checkpointStartDelay, boolean unalignedCheckpoint, boolean completed) {
        Preconditions.checkArgument(subtaskIndex >= 0, "Negative subtask index");
        this.subtaskIndex = subtaskIndex;
        Preconditions.checkArgument(checkpointedSize >= 0L, "Negative incremental state size");
        this.checkpointedSize = checkpointedSize;
        Preconditions.checkArgument(stateSize >= 0L, "Negative state size");
        this.stateSize = stateSize;
        this.ackTimestamp = ackTimestamp;
        this.syncCheckpointDuration = syncCheckpointDuration;
        this.asyncCheckpointDuration = asyncCheckpointDuration;
        this.processedData = processedData;
        this.persistedData = persistedData;
        this.alignmentDuration = alignmentDuration;
        this.checkpointStartDelay = checkpointStartDelay;
        this.unalignedCheckpoint = unalignedCheckpoint;
        this.completed = completed;
    }

    public int getSubtaskIndex() {
        return this.subtaskIndex;
    }

    public long getStateSize() {
        return this.stateSize;
    }

    public long getCheckpointedSize() {
        return this.checkpointedSize;
    }

    public long getAckTimestamp() {
        return this.ackTimestamp;
    }

    public long getEndToEndDuration(long triggerTimestamp) {
        return Math.max(0L, this.ackTimestamp - triggerTimestamp);
    }

    public long getSyncCheckpointDuration() {
        return this.syncCheckpointDuration;
    }

    public long getAsyncCheckpointDuration() {
        return this.asyncCheckpointDuration;
    }

    public long getProcessedData() {
        return this.processedData;
    }

    public long getPersistedData() {
        return this.persistedData;
    }

    public long getAlignmentDuration() {
        return this.alignmentDuration;
    }

    public long getCheckpointStartDelay() {
        return this.checkpointStartDelay;
    }

    public boolean getUnalignedCheckpoint() {
        return this.unalignedCheckpoint;
    }

    public boolean isCompleted() {
        return this.completed;
    }
}

