/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.util.Preconditions;

public class JobPlanInfo
implements ResponseBody {
    private static final String FIELD_NAME_PLAN = "plan";
    @JsonProperty(value="plan")
    private final RawJson jsonPlan;

    public JobPlanInfo(String jsonPlan) {
        this(new RawJson(Preconditions.checkNotNull(jsonPlan)));
    }

    @JsonCreator
    public JobPlanInfo(@JsonProperty(value="plan") RawJson jsonPlan) {
        this.jsonPlan = jsonPlan;
    }

    @JsonIgnore
    public String getJsonPlan() {
        return this.jsonPlan.json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobPlanInfo that = (JobPlanInfo)o;
        return Objects.equals(this.jsonPlan, that.jsonPlan);
    }

    public int hashCode() {
        return Objects.hash(this.jsonPlan);
    }

    public String toString() {
        return "JobPlanInfo{jsonPlan=" + this.jsonPlan + '}';
    }

    @JsonSerialize(using=Serializer.class)
    @JsonDeserialize(using=Deserializer.class)
    public static final class RawJson {
        private final String json;

        private RawJson(String json) {
            this.json = json;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RawJson rawJson = (RawJson)o;
            return Objects.equals(this.json, rawJson.json);
        }

        public int hashCode() {
            return Objects.hash(this.json);
        }

        public String toString() {
            return "RawJson{json='" + this.json + '\'' + '}';
        }

        public static final class Deserializer
        extends StdDeserializer<RawJson> {
            private static final long serialVersionUID = -3580088509877177213L;

            public Deserializer() {
                super(RawJson.class);
            }

            @Override
            public RawJson deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                JsonNode rootNode = (JsonNode)jsonParser.readValueAsTree();
                return new RawJson(rootNode.toString());
            }
        }

        public static final class Serializer
        extends StdSerializer<RawJson> {
            private static final long serialVersionUID = -1551666039618928811L;

            public Serializer() {
                super(RawJson.class);
            }

            @Override
            public void serialize(RawJson jobPlanInfo, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeRawValue(jobPlanInfo.json);
            }
        }
    }
}

