/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.scheduler.AvailableInputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.DefaultPreferredLocationsRetriever;
import org.apache.flink.runtime.scheduler.InputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.PreferredLocationsRetriever;
import org.apache.flink.runtime.scheduler.StateLocationRetriever;
import org.apache.flink.runtime.scheduler.SyncPreferredLocationsRetriever;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

class DefaultSyncPreferredLocationsRetriever
implements SyncPreferredLocationsRetriever {
    private final PreferredLocationsRetriever asyncPreferredLocationsRetriever;

    DefaultSyncPreferredLocationsRetriever(StateLocationRetriever stateLocationRetriever, InputsLocationsRetriever inputsLocationsRetriever) {
        this.asyncPreferredLocationsRetriever = new DefaultPreferredLocationsRetriever(stateLocationRetriever, new AvailableInputsLocationsRetriever(inputsLocationsRetriever));
    }

    @Override
    public Collection<TaskManagerLocation> getPreferredLocations(ExecutionVertexID executionVertexId, Set<ExecutionVertexID> producersToIgnore) {
        CompletableFuture<Collection<TaskManagerLocation>> preferredLocationsFuture = this.asyncPreferredLocationsRetriever.getPreferredLocations(executionVertexId, producersToIgnore);
        Preconditions.checkState(preferredLocationsFuture.isDone());
        return preferredLocationsFuture.join();
    }
}

