/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.PhysicalStateHandleID;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

public class FileStateHandle
implements StreamStateHandle {
    private static final long serialVersionUID = 350284443258002355L;
    private final Path filePath;
    private final long stateSize;

    public FileStateHandle(Path filePath, long stateSize) {
        Preconditions.checkArgument(stateSize >= -1L);
        this.filePath = Preconditions.checkNotNull(filePath);
        this.stateSize = stateSize;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    @Override
    public FSDataInputStream openInputStream() throws IOException {
        return this.getFileSystem().open(this.filePath);
    }

    @Override
    public Optional<byte[]> asBytesIfInMemory() {
        return Optional.empty();
    }

    @Override
    public PhysicalStateHandleID getStreamStateHandleID() {
        return new PhysicalStateHandleID(this.filePath.toUri().toString());
    }

    @Override
    public void discardState() throws Exception {
        FileSystem fs = this.getFileSystem();
        IOException actualException = null;
        boolean success = true;
        try {
            success = fs.delete(this.filePath, false);
        }
        catch (IOException e) {
            actualException = e;
        }
        if ((!success || actualException != null) && fs.exists(this.filePath)) {
            throw Optional.ofNullable(actualException).orElse(new IOException("Unknown error caused the file '" + this.filePath + "' to not be deleted."));
        }
    }

    @Override
    public long getStateSize() {
        return this.stateSize;
    }

    private FileSystem getFileSystem() throws IOException {
        return FileSystem.get(this.filePath.toUri());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileStateHandle)) {
            return false;
        }
        FileStateHandle that = (FileStateHandle)o;
        return this.filePath.equals(that.filePath);
    }

    public int hashCode() {
        return this.filePath.hashCode();
    }

    public String toString() {
        return String.format("File State: %s [%d bytes]", this.filePath, this.stateSize);
    }
}

