/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree.compact;

import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunction;
import org.apache.flink.table.store.file.mergetree.compact.MergeFunctionWrapper;

public class ReducerMergeFunctionWrapper
implements MergeFunctionWrapper<KeyValue> {
    private final MergeFunction<KeyValue> mergeFunction;
    private transient KeyValue initialKv;
    private transient boolean isInitialized;

    public ReducerMergeFunctionWrapper(MergeFunction<KeyValue> mergeFunction) {
        this.mergeFunction = mergeFunction;
    }

    @Override
    public void reset() {
        this.initialKv = null;
        this.mergeFunction.reset();
        this.isInitialized = false;
    }

    @Override
    public void add(KeyValue kv) {
        if (this.initialKv == null) {
            this.initialKv = kv;
        } else {
            if (!this.isInitialized) {
                this.merge(this.initialKv);
                this.isInitialized = true;
            }
            this.merge(kv);
        }
    }

    private void merge(KeyValue kv) {
        this.mergeFunction.add(kv);
    }

    @Override
    public KeyValue getResult() {
        return this.isInitialized ? this.mergeFunction.getResult() : this.initialKv;
    }
}

