/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.spark;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.store.utils.DateTimeUtils;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.spark.sql.Row;

public class SparkRowData
implements RowData {
    private final RowType type;
    private final Row row;

    public SparkRowData(RowType type, Row row) {
        this.type = type;
        this.row = row;
    }

    @Override
    public int getArity() {
        return this.row.size();
    }

    @Override
    public RowKind getRowKind() {
        return RowKind.INSERT;
    }

    @Override
    public void setRowKind(RowKind rowKind) {
        if (rowKind == RowKind.INSERT) {
            return;
        }
        throw new UnsupportedOperationException("Can not set row kind for this row except INSERT.");
    }

    @Override
    public boolean isNullAt(int i) {
        return this.row.isNullAt(i);
    }

    @Override
    public boolean getBoolean(int i) {
        return this.row.getBoolean(i);
    }

    @Override
    public byte getByte(int i) {
        return this.row.getByte(i);
    }

    @Override
    public short getShort(int i) {
        return this.row.getShort(i);
    }

    @Override
    public int getInt(int i) {
        if (this.type.getTypeAt(i) instanceof DateType) {
            return SparkRowData.toFlinkDate(this.row.get(i));
        }
        return this.row.getInt(i);
    }

    @Override
    public long getLong(int i) {
        return this.row.getLong(i);
    }

    @Override
    public float getFloat(int i) {
        return this.row.getFloat(i);
    }

    @Override
    public double getDouble(int i) {
        return this.row.getDouble(i);
    }

    @Override
    public StringData getString(int i) {
        return StringData.fromString(this.row.getString(i));
    }

    @Override
    public DecimalData getDecimal(int i, int precision, int scale) {
        return DecimalData.fromBigDecimal(this.row.getDecimal(i), precision, scale);
    }

    @Override
    public TimestampData getTimestamp(int i, int precision) {
        return SparkRowData.toFlinkTimestamp(this.row.get(i));
    }

    @Override
    public <T> RawValueData<T> getRawValue(int i) {
        throw new UnsupportedOperationException("Raw value is not supported in Spark, please use SQL types.");
    }

    @Override
    public byte[] getBinary(int i) {
        return (byte[])this.row.getAs(i);
    }

    @Override
    public ArrayData getArray(int i) {
        return new FlinkArrayData(((ArrayType)this.type.getTypeAt(i)).getElementType(), this.row.getList(i));
    }

    @Override
    public MapData getMap(int i) {
        return SparkRowData.toFlinkMap((MapType)this.type.getTypeAt(i), this.row.getJavaMap(i));
    }

    @Override
    public RowData getRow(int i, int i1) {
        return new SparkRowData((RowType)this.type.getTypeAt(i), this.row.getStruct(i));
    }

    private static int toFlinkDate(Object object) {
        if (object instanceof Date) {
            return DateTimeUtils.toInternal((Date)object);
        }
        return DateTimeUtils.toInternal((LocalDate)object);
    }

    private static TimestampData toFlinkTimestamp(Object object) {
        if (object instanceof Timestamp) {
            return TimestampData.fromTimestamp((Timestamp)object);
        }
        return TimestampData.fromLocalDateTime((LocalDateTime)object);
    }

    private static MapData toFlinkMap(MapType mapType, final Map<Object, Object> map) {
        ArrayList keys = new ArrayList();
        ArrayList values = new ArrayList();
        map.forEach((k, v) -> {
            keys.add(k);
            values.add(v);
        });
        final FlinkArrayData key = new FlinkArrayData(mapType.getKeyType(), keys);
        final FlinkArrayData value = new FlinkArrayData(mapType.getValueType(), values);
        return new MapData(){

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public ArrayData keyArray() {
                return key;
            }

            @Override
            public ArrayData valueArray() {
                return value;
            }
        };
    }

    private static class FlinkArrayData
    implements ArrayData {
        private final LogicalType elementType;
        private final List<Object> list;

        private FlinkArrayData(LogicalType elementType, List<Object> list) {
            this.list = list;
            this.elementType = elementType;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean isNullAt(int i) {
            return this.list.get(i) == null;
        }

        private <T> T getAs(int i) {
            return (T)this.list.get(i);
        }

        @Override
        public boolean getBoolean(int i) {
            return (Boolean)this.getAs(i);
        }

        @Override
        public byte getByte(int i) {
            return (Byte)this.getAs(i);
        }

        @Override
        public short getShort(int i) {
            return (Short)this.getAs(i);
        }

        @Override
        public int getInt(int i) {
            if (this.elementType instanceof DateType) {
                return SparkRowData.toFlinkDate(this.getAs(i));
            }
            return (Integer)this.getAs(i);
        }

        @Override
        public long getLong(int i) {
            return (Long)this.getAs(i);
        }

        @Override
        public float getFloat(int i) {
            return ((Float)this.getAs(i)).floatValue();
        }

        @Override
        public double getDouble(int i) {
            return (Double)this.getAs(i);
        }

        @Override
        public StringData getString(int i) {
            return StringData.fromString((String)this.getAs(i));
        }

        @Override
        public DecimalData getDecimal(int i, int precision, int scale) {
            return DecimalData.fromBigDecimal((BigDecimal)this.getAs(i), precision, scale);
        }

        @Override
        public TimestampData getTimestamp(int i, int precision) {
            return SparkRowData.toFlinkTimestamp(this.getAs(i));
        }

        @Override
        public <T> RawValueData<T> getRawValue(int i) {
            throw new UnsupportedOperationException("Raw value is not supported in Spark, please use SQL types.");
        }

        @Override
        public byte[] getBinary(int i) {
            return (byte[])this.getAs(i);
        }

        @Override
        public ArrayData getArray(int i) {
            return new FlinkArrayData(((ArrayType)this.elementType).getElementType(), (List)this.getAs(i));
        }

        @Override
        public MapData getMap(int i) {
            return SparkRowData.toFlinkMap((MapType)this.elementType, (Map)this.getAs(i));
        }

        @Override
        public RowData getRow(int i, int i1) {
            return new SparkRowData((RowType)this.elementType, (Row)this.getAs(i));
        }

        @Override
        public boolean[] toBooleanArray() {
            boolean[] res = new boolean[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                res[i] = this.getBoolean(i);
            }
            return res;
        }

        @Override
        public byte[] toByteArray() {
            byte[] res = new byte[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                res[i] = this.getByte(i);
            }
            return res;
        }

        @Override
        public short[] toShortArray() {
            short[] res = new short[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                res[i] = this.getShort(i);
            }
            return res;
        }

        @Override
        public int[] toIntArray() {
            int[] res = new int[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                res[i] = this.getInt(i);
            }
            return res;
        }

        @Override
        public long[] toLongArray() {
            long[] res = new long[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                res[i] = this.getLong(i);
            }
            return res;
        }

        @Override
        public float[] toFloatArray() {
            float[] res = new float[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                res[i] = this.getFloat(i);
            }
            return res;
        }

        @Override
        public double[] toDoubleArray() {
            double[] res = new double[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                res[i] = this.getDouble(i);
            }
            return res;
        }
    }
}

