/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.source.snapshot;

import org.apache.flink.table.store.file.operation.ScanKind;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.table.source.DataTableScan;
import org.apache.flink.table.store.table.source.snapshot.StartingScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullStartingScanner
implements StartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(FullStartingScanner.class);

    @Override
    public DataTableScan.DataFilePlan getPlan(SnapshotManager snapshotManager, DataTableScan scan) {
        Long startingSnapshotId = snapshotManager.latestSnapshotId();
        if (startingSnapshotId == null) {
            LOG.debug("There is currently no snapshot. Waiting for snapshot generation.");
            return null;
        }
        return scan.withKind(ScanKind.ALL).withSnapshot(startingSnapshotId).plan();
    }
}

