/*
 * Decompiled with CFR 0.152.
 */
package shaded.parquet.org.apache.thrift.transport;

import java.nio.charset.Charset;
import shaded.parquet.org.apache.thrift.TByteArrayOutputStream;
import shaded.parquet.org.apache.thrift.transport.TTransport;

public class TMemoryBuffer
extends TTransport {
    private TByteArrayOutputStream arr_;
    private int pos_;

    public TMemoryBuffer(int size) {
        this.arr_ = new TByteArrayOutputStream(size);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public int read(byte[] buf, int off, int len) {
        int amtToRead;
        byte[] src = this.arr_.get();
        int n = amtToRead = len > this.arr_.len() - this.pos_ ? this.arr_.len() - this.pos_ : len;
        if (amtToRead > 0) {
            System.arraycopy(src, this.pos_, buf, off, amtToRead);
            this.pos_ += amtToRead;
        }
        return amtToRead;
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.arr_.write(buf, off, len);
    }

    public String toString(Charset charset) {
        return this.arr_.toString(charset);
    }

    public String inspect() {
        StringBuilder buf = new StringBuilder();
        byte[] bytes = this.arr_.toByteArray();
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(this.pos_ == i ? "==>" : "").append(Integer.toHexString(bytes[i] & 0xFF)).append(" ");
        }
        return buf.toString();
    }

    public int length() {
        return this.arr_.size();
    }

    public byte[] getArray() {
        return this.arr_.get();
    }
}

