/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.kafka.sink;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.kafka.GeodeContext;
import org.apache.geode.kafka.Version;
import org.apache.geode.kafka.sink.BatchRecords;
import org.apache.geode.kafka.sink.GeodeSinkConnectorConfig;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeodeKafkaSinkTask
extends SinkTask {
    private static final Logger logger = LoggerFactory.getLogger(GeodeKafkaSinkTask.class);
    private GeodeContext geodeContext;
    private Map<String, List<String>> topicToRegions;
    private Map<String, Region<Object, Object>> regionNameToRegion;
    private boolean nullValuesMeansRemove = true;

    public String version() {
        return Version.getVersion();
    }

    public void start(Map<String, String> props) {
        logger.info("Starting Apache Geode sink task");
        try {
            GeodeSinkConnectorConfig geodeConnectorConfig = new GeodeSinkConnectorConfig(props);
            this.configure(geodeConnectorConfig);
            this.geodeContext = new GeodeContext();
            ClientCache clientCache = this.geodeContext.connectClient(geodeConnectorConfig.getLocatorHostPorts(), geodeConnectorConfig.getSecurityClientAuthInit(), geodeConnectorConfig.getSecurityUserName(), geodeConnectorConfig.getSecurityPassword(), geodeConnectorConfig.usesSecurity());
            if (clientCache == null) {
                throw new ConnectException("Unable start client cache in the sink task");
            }
            this.regionNameToRegion = this.createProxyRegions(this.topicToRegions.values());
        }
        catch (Exception e) {
            if (e instanceof ConnectException) {
                throw e;
            }
            throw new ConnectException("Unable to start sink task", (Throwable)e);
        }
    }

    void configure(GeodeSinkConnectorConfig geodeConnectorConfig) {
        logger.debug("GeodeKafkaSourceTask id:" + geodeConnectorConfig.getTaskId() + " starting");
        this.topicToRegions = geodeConnectorConfig.getTopicToRegions();
        this.nullValuesMeansRemove = geodeConnectorConfig.getNullValueBehavior();
    }

    void setRegionNameToRegion(Map<String, Region<Object, Object>> regionNameToRegion) {
        this.regionNameToRegion = regionNameToRegion;
    }

    public void put(Collection<SinkRecord> records) {
        logger.debug("Received " + records.size() + " records.");
        this.put(records, new HashMap<String, BatchRecords>());
    }

    void put(Collection<SinkRecord> records, Map<String, BatchRecords> batchRecordsMap) {
        for (SinkRecord record : records) {
            logger.debug("kafka coordinates:(Topic:" + record.topic() + " Partition:" + record.kafkaPartition() + " Offset:" + record.kafkaOffset() + ")");
            this.updateBatchForRegionByTopic(record, batchRecordsMap);
        }
        batchRecordsMap.forEach((region, batchRecords) -> batchRecords.executeOperations(this.regionNameToRegion.get(region)));
    }

    private void updateBatchForRegionByTopic(SinkRecord sinkRecord, Map<String, BatchRecords> batchRecordsMap) {
        Collection regionsToUpdate = this.topicToRegions.get(sinkRecord.topic());
        for (String region : regionsToUpdate) {
            this.updateBatchRecordsForRecord(sinkRecord, batchRecordsMap, region);
        }
    }

    private void updateBatchRecordsForRecord(SinkRecord record, Map<String, BatchRecords> batchRecordsMap, String region) {
        BatchRecords batchRecords = batchRecordsMap.get(region);
        if (batchRecords == null) {
            batchRecords = new BatchRecords();
            batchRecordsMap.put(region, batchRecords);
        }
        if (record.key() != null) {
            if (record.value() == null && this.nullValuesMeansRemove) {
                batchRecords.addRemoveOperation(record);
            } else {
                batchRecords.addUpdateOperation(record, this.nullValuesMeansRemove);
            }
        } else {
            logger.warn("Unable to push to Geode, missing key in record : " + record.value());
        }
    }

    private Map<String, Region<Object, Object>> createProxyRegions(Collection<List<String>> regionNames) {
        List flat = regionNames.stream().flatMap(Collection::stream).collect(Collectors.toList());
        return flat.stream().map(this::createProxyRegion).collect(Collectors.toMap(Region::getName, region -> region));
    }

    private Region<Object, Object> createProxyRegion(String regionName) {
        try {
            return this.geodeContext.getClientCache().createClientRegionFactory(ClientRegionShortcut.PROXY).create(regionName);
        }
        catch (RegionExistsException e) {
            return this.geodeContext.getClientCache().getRegion(regionName);
        }
    }

    public void stop() {
        logger.info("Stopping task");
        this.geodeContext.close(false);
    }
}

