/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.RemoteClient;
import com.healthmarketscience.rmiio.RemoteOutputStream;
import com.healthmarketscience.rmiio.RemoteOutputStreamWrapper;
import com.healthmarketscience.rmiio.RemoteRetry;
import com.healthmarketscience.rmiio.util.PipeBuffer;
import com.healthmarketscience.rmiio.util.SingleByteAdapter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteOutputStreamClient {
    public static final RemoteRetry DEFAULT_RETRY = RemoteClient.DEFAULT_RETRY;
    protected static final Log LOG = LogFactory.getLog(RemoteOutputStreamClient.class);
    public static final Integer DEFAULT_CHUNK_SIZE = 7168;

    private RemoteOutputStreamClient() {
    }

    public static OutputStream wrap(RemoteOutputStream remoteOut) throws IOException {
        return RemoteOutputStreamClient.wrap(remoteOut, DEFAULT_RETRY, DEFAULT_CHUNK_SIZE);
    }

    public static OutputStream wrap(RemoteOutputStream remoteOut, RemoteRetry retry) throws IOException {
        return RemoteOutputStreamClient.wrap(remoteOut, retry, DEFAULT_CHUNK_SIZE);
    }

    public static OutputStream wrap(RemoteOutputStream remoteOut, RemoteRetry retry, Integer chunkSize) throws IOException {
        OutputStream retStream;
        if (retry == null) {
            retry = DEFAULT_RETRY;
        }
        if (chunkSize == null) {
            chunkSize = DEFAULT_CHUNK_SIZE;
        }
        if (((RemoteOutputStreamImpl)(retStream = new RemoteOutputStreamImpl(remoteOut, retry, chunkSize)))._remoteOut.usingGZIPCompression()) {
            retStream = new SaferGZIPOutputStream(retStream, (int)chunkSize);
        }
        return retStream;
    }

    private static class SaferGZIPOutputStream
    extends GZIPOutputStream {
        private SaferGZIPOutputStream(OutputStream out, int size) throws IOException {
            super(out, size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Exception closeFailure = null;
            try {
                super.close();
            }
            catch (Exception e) {
                closeFailure = e;
            }
            finally {
                this.out.close();
            }
            if (closeFailure != null) {
                if (closeFailure instanceof IOException) {
                    throw (IOException)closeFailure;
                }
                throw (RuntimeException)closeFailure;
            }
        }
    }

    private static class RemoteOutputStreamImpl
    extends OutputStream {
        private final SingleByteAdapter _singleByteAdapter = new SingleByteAdapter();
        private final RemoteOutputStream _remoteOut;
        private final int _chunkSize;
        private final PipeBuffer _byteBuffer;
        private int nextActionId = 0;
        private volatile boolean _remoteCloseSuccessful;
        private volatile boolean _writeSuccess = true;

        public RemoteOutputStreamImpl(RemoteOutputStream remoteOut, RemoteRetry retry, int chunkSize) {
            this._remoteOut = new RemoteOutputStreamWrapper(remoteOut, retry, LOG);
            this._chunkSize = chunkSize;
            this._byteBuffer = new PipeBuffer(this._chunkSize);
        }

        public void close() throws IOException {
            block3: {
                if (this._remoteCloseSuccessful) {
                    return;
                }
                try {
                    this.flush(false);
                }
                catch (IOException ignored) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)"Ignoring exception while flushing stream", (Throwable)ignored);
                }
            }
            this._remoteOut.close(this._writeSuccess);
            this._remoteCloseSuccessful = true;
        }

        private void flushPackets(boolean flushPartial) throws IOException {
            while (this._byteBuffer.hasRemaining() && (flushPartial || this._byteBuffer.packetsAvailable() > 0)) {
                byte[] packet = this._byteBuffer.readPacket();
                this._remoteOut.writePacket(packet, this.nextActionId++);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void flush(boolean remoteFlush) throws IOException {
            boolean success = false;
            try {
                this.flushPackets(true);
                if (remoteFlush) {
                    this._remoteOut.flush();
                }
                success = true;
            }
            finally {
                if (!success) {
                    this._writeSuccess = false;
                }
            }
        }

        public void flush() throws IOException {
            this.flush(true);
        }

        public synchronized void write(int b) throws IOException {
            this._singleByteAdapter.write(b, this);
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            boolean success = false;
            try {
                this._byteBuffer.write(b, off, len);
                this.flushPackets(false);
                success = true;
            }
            finally {
                if (!success) {
                    this._writeSuccess = false;
                }
            }
        }
    }
}

