/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio.socket;

import com.healthmarketscience.rmiio.RemoteClient;
import com.healthmarketscience.rmiio.RemoteOutputStream;
import com.healthmarketscience.rmiio.RemoteOutputStreamClient;
import com.healthmarketscience.rmiio.RemoteRetry;
import com.healthmarketscience.rmiio.RmiioUtil;
import com.healthmarketscience.rmiio.SimpleRemoteOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;

public class RMISocket
implements Closeable {
    private final PipedInputStream _in = new PipedInputStream(7168);
    private final Source _source;
    private Source _remoteSource;

    public RMISocket() throws IOException {
        this(null);
    }

    public RMISocket(Source remoteSource) throws IOException {
        PipedOutputStream out = new PipedOutputStream(this._in);
        this._source = new Source(new SimpleRemoteOutputStream(out));
        this._remoteSource = remoteSource;
    }

    public InputStream getInputStream() throws IOException {
        return this._in;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this._remoteSource == null) {
            throw new IllegalStateException("no remote source has been associated with this socket");
        }
        return this._remoteSource.getOutputStream();
    }

    public Source getSource() {
        return this._source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this._remoteSource != null) {
                this._remoteSource.close();
            }
        }
        finally {
            RmiioUtil.closeQuietly(this._in);
        }
    }

    public Source getRemoteSource() {
        return this._remoteSource;
    }

    public void setRemoteSource(Source newRemoteSource) {
        this._remoteSource = newRemoteSource;
    }

    public static class Source
    implements Serializable,
    RemoteClient,
    Closeable {
        private static final long serialVersionUID = 20120625L;
        private final RemoteOutputStream _remoteOut;
        private transient RemoteRetry _retry;
        private transient OutputStream _localOut;
        private transient Integer _chunkSize;

        private Source(RemoteOutputStream out) {
            this._remoteOut = out;
        }

        public OutputStream getOutputStream() throws IOException {
            if (this._localOut == null) {
                this._localOut = RemoteOutputStreamClient.wrap(this._remoteOut, this._retry, this._chunkSize);
            }
            return this._localOut;
        }

        public void setRemoteRetry(RemoteRetry retry) {
            this._retry = retry;
        }

        public void setChunkSize(Integer chunkSize) {
            this._chunkSize = chunkSize;
        }

        public void close() throws IOException {
            this.getOutputStream().close();
        }
    }
}

