/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.InterestResultPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.StatisticsDisabledException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.cache.client.internal.ProxyCache;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.snapshot.RegionSnapshotService;
import org.apache.geode.internal.cache.snapshot.RegionSnapshotServiceImpl;
import org.apache.geode.internal.statistics.StatisticsClock;

public class ProxyRegion
implements Region {
    private final ProxyCache proxyCache;
    private final Region realRegion;
    private final StatisticsClock statisticsClock;

    public ProxyRegion(ProxyCache proxyCache, Region realRegion, StatisticsClock statisticsClock) {
        this.proxyCache = proxyCache;
        this.realRegion = realRegion;
        this.statisticsClock = statisticsClock;
    }

    @Override
    public void becomeLockGrantor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        try {
            this.preOp();
            this.realRegion.clear();
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void close() {
        try {
            this.preOp();
            this.realRegion.close();
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            this.preOp();
            boolean bl = this.realRegion.containsKey(key);
            return bl;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public boolean containsKeyOnServer(Object key) {
        try {
            this.preOp();
            boolean bl = this.realRegion.containsKeyOnServer(key);
            return bl;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public int sizeOnServer() {
        try {
            this.preOp();
            int n = this.realRegion.sizeOnServer();
            return n;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public boolean isEmptyOnServer() {
        try {
            this.preOp();
            boolean bl = this.realRegion.isEmptyOnServer();
            return bl;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            this.preOp();
            boolean bl = this.realRegion.containsValue(value);
            return bl;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public boolean containsValueForKey(Object key) {
        try {
            this.preOp();
            boolean bl = this.realRegion.containsValueForKey(key);
            return bl;
        }
        finally {
            this.postOp();
        }
    }

    public void create(Object key, Object value) throws TimeoutException, EntryExistsException, CacheWriterException {
        try {
            this.preOp();
            this.realRegion.create(key, value);
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Object key, Object value, Object callbackArgument) throws TimeoutException, EntryExistsException, CacheWriterException {
        try {
            this.preOp();
            this.realRegion.create(key, value, callbackArgument);
        }
        finally {
            this.postOp();
        }
    }

    public Region createSubregion(String subregionName, RegionAttributes regionAttributes) throws RegionExistsException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    public Object destroy(Object key) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        try {
            this.preOp();
            Object v = this.realRegion.destroy(key);
            return v;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object destroy(Object key, Object callbackArgument) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        try {
            this.preOp();
            Object v = this.realRegion.destroy(key, callbackArgument);
            return v;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void destroyRegion() throws CacheWriterException, TimeoutException {
        try {
            this.preOp();
            this.realRegion.destroyRegion();
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void destroyRegion(Object callbackArgument) throws CacheWriterException, TimeoutException {
        try {
            this.preOp();
            this.realRegion.destroyRegion(callbackArgument);
        }
        finally {
            this.postOp();
        }
    }

    public Set entrySet(boolean recursive) {
        try {
            this.preOp();
            Set<Region.Entry<?, ?>> set = this.realRegion.entrySet(recursive);
            return set;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public Set entrySet() {
        try {
            this.preOp();
            Set set = this.realRegion.entrySet();
            return set;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public boolean existsValue(String queryPredicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        try {
            this.preOp();
            boolean bl = this.realRegion.existsValue(queryPredicate);
            return bl;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void forceRolling() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object key) throws CacheLoaderException, TimeoutException {
        try {
            this.preOp();
            Object v = this.realRegion.get(key);
            return v;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key, Object callbackArgument) throws TimeoutException, CacheLoaderException {
        try {
            this.preOp();
            Object v = this.realRegion.get(key, callbackArgument);
            return v;
        }
        finally {
            this.postOp();
        }
    }

    public Map getAll(Collection keys) {
        return this.getAll(keys, (Object)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAll(Collection keys, Object callback) {
        try {
            this.preOp();
            Map map = this.realRegion.getAll(keys, callback);
            return map;
        }
        finally {
            this.postOp();
        }
    }

    public RegionAttributes getAttributes() {
        return this.realRegion.getAttributes();
    }

    public AttributesMutator getAttributesMutator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cache getCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegionService getRegionService() {
        return this.proxyCache;
    }

    public ProxyCache getAuthenticatedCache() {
        return this.proxyCache;
    }

    @Override
    public Lock getDistributedLock(Object key) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public Region.Entry getEntry(Object key) {
        try {
            this.preOp();
            Region.Entry entry = this.realRegion.getEntry(key);
            return entry;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public String getFullPath() {
        return this.realRegion.getFullPath();
    }

    public List getInterestList() {
        throw new UnsupportedOperationException();
    }

    public List getInterestListRegex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.realRegion.getName();
    }

    public Region getParentRegion() {
        return this.realRegion.getParentRegion();
    }

    @Override
    public Lock getRegionDistributedLock() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheStatistics getStatistics() throws StatisticsDisabledException {
        return this.realRegion.getStatistics();
    }

    public Region getSubregion(String path) {
        Region region = this.realRegion.getSubregion(path);
        return region != null ? new ProxyRegion(this.proxyCache, region, this.statisticsClock) : null;
    }

    @Override
    public Object getUserAttribute() {
        return this.realRegion.getUserAttribute();
    }

    @Override
    public void invalidate(Object key) throws TimeoutException, EntryNotFoundException {
        try {
            this.preOp();
            this.realRegion.invalidate(key);
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void invalidate(Object key, Object callbackArgument) throws TimeoutException, EntryNotFoundException {
        try {
            this.preOp();
            this.realRegion.invalidate(key, callbackArgument);
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void invalidateRegion() throws TimeoutException {
        try {
            this.preOp();
            this.realRegion.invalidateRegion();
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void invalidateRegion(Object callbackArgument) throws TimeoutException {
        try {
            this.preOp();
            this.realRegion.invalidateRegion(callbackArgument);
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.realRegion.isDestroyed();
    }

    @Override
    public boolean isEmpty() {
        return this.realRegion.isEmpty();
    }

    public Set keySetOnServer() {
        try {
            this.preOp();
            Set set = this.realRegion.keySetOnServer();
            return set;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public Set keySet() {
        try {
            this.preOp();
            Set set = this.realRegion.keySet();
            return set;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void loadSnapshot(InputStream inputStream) throws IOException, ClassNotFoundException, CacheWriterException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void localClear() {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    @Override
    public void localDestroy(Object key) throws EntryNotFoundException {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    @Override
    public void localDestroy(Object key, Object callbackArgument) throws EntryNotFoundException {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    @Override
    public void localDestroyRegion() {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    @Override
    public void localDestroyRegion(Object callbackArgument) {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    @Override
    public void localInvalidate(Object key) throws EntryNotFoundException {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    @Override
    public void localInvalidate(Object key, Object callbackArgument) throws EntryNotFoundException {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    @Override
    public void localInvalidateRegion() {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    @Override
    public void localInvalidateRegion(Object callbackArgument) {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) throws TimeoutException, CacheWriterException {
        try {
            this.preOp();
            Object object = this.realRegion.put(key, value);
            return object;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value, Object callbackArgument) throws TimeoutException, CacheWriterException {
        try {
            this.preOp();
            Object object = this.realRegion.put(key, value, callbackArgument);
            return object;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void putAll(Map map) {
        this.putAll(map, (Object)null);
    }

    public void putAll(Map map, Object callbackArg) {
        try {
            this.preOp();
            this.realRegion.putAll(map, callbackArg);
        }
        finally {
            this.postOp();
        }
    }

    public SelectResults query(String queryPredicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        try {
            this.preOp();
            SelectResults selectResults = this.realRegion.query(queryPredicate);
            return selectResults;
        }
        finally {
            this.postOp();
        }
    }

    public void registerInterest(Object key) {
        throw new UnsupportedOperationException();
    }

    public void registerInterest(Object key, InterestResultPolicy policy) {
        throw new UnsupportedOperationException();
    }

    public void registerInterest(Object key, boolean isDurable) {
        throw new UnsupportedOperationException();
    }

    public void registerInterest(Object key, boolean isDurable, boolean receiveValues) {
        throw new UnsupportedOperationException();
    }

    public void registerInterest(Object key, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) {
        throw new UnsupportedOperationException();
    }

    public void registerInterest(Object key, InterestResultPolicy policy, boolean isDurable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex, boolean isDurable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex, boolean isDurable, boolean receiveValues) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy, boolean isDurable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        try {
            this.preOp();
            Object v = this.realRegion.remove(key);
            return v;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void saveSnapshot(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object selectValue(String queryPredicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        try {
            this.preOp();
            Object object = this.realRegion.selectValue(queryPredicate);
            return object;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void setUserAttribute(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        try {
            this.preOp();
            int n = this.realRegion.size();
            return n;
        }
        finally {
            this.postOp();
        }
    }

    public Set subregions(boolean recursive) {
        return this.realRegion.subregions(recursive);
    }

    public void unregisterInterest(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unregisterInterestRegex(String regex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection values() {
        try {
            this.preOp();
            Collection collection = this.realRegion.values();
            return collection;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void writeToDisk() {
        throw new UnsupportedOperationException();
    }

    private void preOp() {
        if (this.proxyCache.isClosed()) {
            throw this.proxyCache.getCacheClosedException("Cache is closed for this user.");
        }
        UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
    }

    private void postOp() {
        this.proxyCache.setUserAttributes(UserAttributes.userAttributes.get());
        UserAttributes.userAttributes.set(null);
    }

    public Region getRealRegion() {
        return this.realRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putIfAbsent(Object key, Object value) {
        try {
            this.preOp();
            Object object = this.realRegion.putIfAbsent(key, value);
            return object;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        try {
            this.preOp();
            boolean bl = this.realRegion.remove(key, value);
            return bl;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object replace(Object key, Object value) {
        try {
            this.preOp();
            Object object = this.realRegion.replace(key, value);
            return object;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        try {
            this.preOp();
            boolean bl = this.realRegion.replace(key, oldValue, newValue);
            return bl;
        }
        finally {
            this.postOp();
        }
    }

    public RegionSnapshotService<?, ?> getSnapshotService() {
        return new RegionSnapshotServiceImpl(this);
    }

    public void removeAll(Collection keys) {
        this.removeAll(keys, (Object)null);
    }

    public void removeAll(Collection keys, Object aCallbackArgument) {
        try {
            this.preOp();
            this.realRegion.removeAll(keys, aCallbackArgument);
        }
        finally {
            this.postOp();
        }
    }
}

