/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.pooling;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.cache.client.internal.Connection;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.Op;
import org.apache.geode.cache.client.internal.pooling.ConnectionDestroyedException;
import org.apache.geode.cache.client.internal.pooling.ConnectionManagerImpl;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.tier.sockets.ServerQueueStatus;

public class PooledConnection
implements Connection {
    private volatile Connection connection;
    private volatile Endpoint endpoint;
    private volatile long birthDate;
    private long lastAccessed;
    private boolean active = true;
    private final AtomicBoolean shouldDestroy = new AtomicBoolean();
    private boolean waitingToSwitch = false;

    public PooledConnection(ConnectionManagerImpl manager, Connection connection) {
        this.connection = connection;
        this.endpoint = connection.getEndpoint();
        this.lastAccessed = this.birthDate = System.nanoTime();
    }

    @Override
    public ServerLocation getServer() {
        return this.getEndpoint().getLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        PooledConnection pooledConnection = this;
        synchronized (pooledConnection) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean internalDestroy() {
        boolean result = false;
        this.shouldDestroy.set(true);
        PooledConnection pooledConnection = this;
        synchronized (pooledConnection) {
            this.active = false;
            this.notifyAll();
            Connection myCon = this.connection;
            if (myCon != null) {
                myCon.destroy();
                this.connection = null;
                result = true;
            }
        }
        return result;
    }

    @Override
    public void destroy() {
        this.shouldDestroy.set(true);
    }

    public void internalClose(boolean keepAlive) throws Exception {
        try {
            Connection con = this.connection;
            if (con != null) {
                con.close(keepAlive);
            }
        }
        finally {
            this.internalDestroy();
        }
    }

    @Override
    public void close(boolean keepAlive) throws Exception {
        this.internalClose(keepAlive);
    }

    @Override
    public void emergencyClose() {
        Connection con = this.connection;
        if (con != null) {
            this.connection.emergencyClose();
        }
        this.connection = null;
    }

    Connection getConnection() {
        Connection result = this.connection;
        if (result == null) {
            throw new ConnectionDestroyedException();
        }
        return result;
    }

    @Override
    public Connection getWrappedConnection() {
        return this.getConnection();
    }

    public boolean setShouldDestroy() {
        return this.shouldDestroy.compareAndSet(false, true);
    }

    public boolean shouldDestroy() {
        return this.shouldDestroy.get();
    }

    @Override
    public boolean isDestroyed() {
        return this.connection == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void passivate(boolean accessed) {
        long now = 0L;
        if (accessed) {
            now = System.nanoTime();
        }
        PooledConnection pooledConnection = this;
        synchronized (pooledConnection) {
            if (this.isDestroyed()) {
                return;
            }
            if (!this.active) {
                throw new InternalGemFireException("Connection not active");
            }
            this.active = false;
            if (this.waitingToSwitch) {
                this.notifyAll();
            }
            if (accessed) {
                this.lastAccessed = now;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean switchConnection(Connection newCon) throws InterruptedException {
        Connection oldCon = null;
        PooledConnection pooledConnection = this;
        synchronized (pooledConnection) {
            if (this.shouldDestroy()) {
                return false;
            }
            if (this.active && !this.shouldDestroy()) {
                this.waitingToSwitch = true;
                try {
                    while (this.active && !this.shouldDestroy()) {
                        this.wait();
                    }
                }
                finally {
                    this.waitingToSwitch = false;
                    this.notifyAll();
                }
            }
            if (this.shouldDestroy()) {
                return false;
            }
            assert (!this.active);
            long now = System.nanoTime();
            oldCon = this.connection;
            this.connection = newCon;
            this.endpoint = newCon.getEndpoint();
            this.birthDate = now;
        }
        if (oldCon != null) {
            try {
                oldCon.close(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean activate() {
        PooledConnection pooledConnection = this;
        synchronized (pooledConnection) {
            try {
                while (this.waitingToSwitch) {
                    this.wait();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            if (this.isDestroyed() || this.shouldDestroy()) {
                return false;
            }
            if (this.active) {
                throw new InternalGemFireException("Connection already active");
            }
            this.active = true;
            return true;
        }
    }

    private synchronized long getLastAccessed() {
        return this.lastAccessed;
    }

    public long getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(long ts) {
        this.birthDate = ts;
    }

    public long remainingLife(long now, long timeoutNanos) {
        return this.getBirthDate() - now + timeoutNanos;
    }

    private long remainingIdle(long now, long timeoutNanos) {
        return this.getLastAccessed() - now + timeoutNanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doIdleTimeout(long now, long timeoutNanos) {
        if (this.shouldDestroy()) {
            return 0L;
        }
        PooledConnection pooledConnection = this;
        synchronized (pooledConnection) {
            if (this.isActive()) {
                return timeoutNanos;
            }
            long idleRemaining = this.remainingIdle(now, timeoutNanos);
            if (idleRemaining <= 0L) {
                if (this.setShouldDestroy()) {
                    return -1L;
                }
                return 0L;
            }
            return idleRemaining;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasIdleExpired(long now, long timeoutNanos) {
        PooledConnection pooledConnection = this;
        synchronized (pooledConnection) {
            if (this.isActive()) {
                return false;
            }
            return this.remainingIdle(now, timeoutNanos) <= 0L;
        }
    }

    @Override
    public ByteBuffer getCommBuffer() throws SocketException {
        return this.getConnection().getCommBuffer();
    }

    @Override
    public Socket getSocket() {
        return this.getConnection().getSocket();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.getConnection().getOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.getConnection().getInputStream();
    }

    @Override
    public ConnectionStats getStats() {
        return this.getEndpoint().getStats();
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public ServerQueueStatus getQueueStatus() {
        return this.getConnection().getQueueStatus();
    }

    public String toString() {
        Connection myCon = this.connection;
        if (myCon != null) {
            return "Pooled Connection to " + this.endpoint + ": " + myCon.toString();
        }
        return "Pooled Connection to " + this.endpoint + ": Connection[DESTROYED]";
    }

    @Override
    public Object execute(Op op) throws Exception {
        return this.getConnection().execute(op);
    }

    @Override
    public short getWanSiteVersion() {
        return this.getConnection().getWanSiteVersion();
    }

    @Override
    public int getDistributedSystemId() {
        return this.getConnection().getDistributedSystemId();
    }

    @Override
    public void setWanSiteVersion(short wanSiteVersion) {
        this.getConnection().setWanSiteVersion(wanSiteVersion);
    }

    public void setConnection(Connection newConnection) {
        this.connection = newConnection;
    }

    @Override
    public void setConnectionID(long id) {
        this.connection.setConnectionID(id);
    }

    @Override
    public long getConnectionID() {
        return this.connection.getConnectionID();
    }
}

