/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.server.internal;

import java.util.ArrayList;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.client.internal.CacheServerLoadMessage;
import org.apache.geode.cache.server.ServerLoad;
import org.apache.geode.cache.server.ServerLoadProbe;
import org.apache.geode.cache.server.internal.ServerMetricsImpl;
import org.apache.geode.distributed.internal.Distribution;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.CacheServerAdvisor;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ConnectionListener;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class LoadMonitor
implements ConnectionListener {
    private static final Logger logger = LogService.getLogger();
    private final ServerLoadProbe probe;
    protected final ServerMetricsImpl metrics;
    protected final CacheServerAdvisor advisor;
    protected ServerLocation location;
    private final PollingThread pollingThread;
    protected volatile ServerLoad lastLoad;
    protected CacheServerStats stats;
    protected final ArrayList clientIds = new ArrayList();

    public LoadMonitor(ServerLoadProbe probe, int maxConnections, long pollInterval, int forceUpdateFrequency, CacheServerAdvisor advisor) {
        this.probe = probe;
        this.metrics = new ServerMetricsImpl(maxConnections);
        this.pollingThread = new PollingThread(pollInterval, forceUpdateFrequency);
        this.lastLoad = this.getLoad();
        this.advisor = advisor;
    }

    public void start(ServerLocation location, CacheServerStats cacheServerStats) {
        this.probe.open();
        this.location = location;
        this.pollingThread.start();
        this.stats = cacheServerStats;
        this.stats.setLoad(this.lastLoad);
    }

    public void stop() {
        this.pollingThread.close();
        try {
            this.pollingThread.join(5000L);
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted waiting for polling thread to finish");
            Thread.currentThread().interrupt();
        }
        this.probe.close();
    }

    @Override
    public void connectionClosed(boolean lastConnection, CommunicationMode communicationMode) {
        if (communicationMode.isClientOperations()) {
            this.metrics.decConnectionCount();
        }
        if (lastConnection) {
            this.metrics.decClientCount();
        }
    }

    public ServerLoad getLastLoad() {
        return this.lastLoad;
    }

    @Override
    public void connectionOpened(boolean firstConnection, CommunicationMode communicationMode) {
        if (communicationMode.isClientOperations()) {
            this.metrics.incConnectionCount();
        }
        if (firstConnection) {
            this.metrics.incClientCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueAdded(ClientProxyMembershipID id) {
        ArrayList arrayList = this.clientIds;
        synchronized (arrayList) {
            this.metrics.incQueueCount();
            this.clientIds.add(id);
        }
    }

    @Override
    public void queueRemoved() {
        this.metrics.decQueueCount();
    }

    protected ServerLoad getLoad() {
        ServerLoad load = this.probe.getLoad(this.metrics);
        if (load == null) {
            load = new ServerLoad();
        }
        return load;
    }

    private class PollingThread
    extends Thread {
        private final Object signal;
        private final long pollInterval;
        private volatile boolean alive;
        private final int forceUpdateFrequency;
        private int skippedLoadUpdates;

        public PollingThread(long pollInterval, int forceUpdateFrequency) {
            super("Cache Server Load Polling Thread");
            this.signal = new Object();
            this.alive = true;
            this.pollInterval = pollInterval;
            this.forceUpdateFrequency = forceUpdateFrequency;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.alive = false;
            Object object = this.signal;
            synchronized (object) {
                this.signal.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.alive) {
                try {
                    Object object = this.signal;
                    synchronized (object) {
                        long end = System.currentTimeMillis() + this.pollInterval;
                        long remaining = this.pollInterval;
                        while (this.alive && remaining > 0L) {
                            this.signal.wait(remaining);
                            remaining = end - System.currentTimeMillis();
                        }
                    }
                    if (!this.alive) {
                        return;
                    }
                    ServerLoad previousLoad = LoadMonitor.this.lastLoad;
                    ArrayList myClientIds = null;
                    ServerLoad load = null;
                    ArrayList remaining = LoadMonitor.this.clientIds;
                    synchronized (remaining) {
                        if (!LoadMonitor.this.clientIds.isEmpty()) {
                            myClientIds = new ArrayList(LoadMonitor.this.clientIds);
                            LoadMonitor.this.clientIds.clear();
                        }
                        load = LoadMonitor.this.getLoad();
                    }
                    LoadMonitor.this.lastLoad = load;
                    if (!previousLoad.equals(load) || myClientIds != null || ++this.skippedLoadUpdates > this.forceUpdateFrequency) {
                        Set locators = LoadMonitor.this.advisor.adviseControllers();
                        if (logger.isDebugEnabled()) {
                            logger.debug("cache server Load Monitor Transmitting load {} to locators {}", (Object)load, (Object)locators);
                        }
                        LoadMonitor.this.stats.setLoad(load);
                        if (locators != null) {
                            CacheServerLoadMessage message = new CacheServerLoadMessage(load, LoadMonitor.this.location, myClientIds);
                            message.setRecipients(locators);
                            Distribution mgr = LoadMonitor.this.advisor.getDistributionManager().getDistribution();
                            if (mgr == null || !mgr.isBeingSick()) {
                                LoadMonitor.this.advisor.getDistributionManager().putOutgoing(message);
                            }
                            message.updateLocalLocators();
                        }
                        this.skippedLoadUpdates = 0;
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("cache server Load Monitor Load {} hasn't changed, not transmitting. skippedLoadUpdates={}", (Object)load, (Object)this.skippedLoadUpdates);
                }
                catch (InterruptedException e) {
                    SystemFailure.checkFailure();
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure(e);
                    throw e;
                }
                catch (CancelException e) {
                    return;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.warn("CacheServer Load Monitor Error in polling thread", t);
                }
            }
        }
    }
}

