/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.internal.PoolStatHelper;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;

public class PooledExecutorWithDMStats
extends ThreadPoolExecutor {
    protected final PoolStatHelper stats;
    private final ThreadsMonitoring threadMonitoring;
    protected BlockingQueue<Runnable> bufferQueue;
    private Thread bufferConsumer;

    public PooledExecutorWithDMStats(SynchronousQueue<Runnable> q, int maxPoolSize, PoolStatHelper stats, ThreadFactory tf, int msTimeout, RejectedExecutionHandler reh, ThreadsMonitoring tMonitoring) {
        super(PooledExecutorWithDMStats.getCorePoolSize(maxPoolSize), maxPoolSize, msTimeout, TimeUnit.MILLISECONDS, q, tf, reh);
        this.stats = stats;
        this.threadMonitoring = tMonitoring;
    }

    private static SynchronousQueue<Runnable> initQ(BlockingQueue<Runnable> q) {
        if (q instanceof SynchronousQueue) {
            return (SynchronousQueue)q;
        }
        return new SynchronousQueue<Runnable>();
    }

    private static RejectedExecutionHandler initREH(BlockingQueue<Runnable> q) {
        if (q instanceof SynchronousQueue) {
            return new ThreadPoolExecutor.CallerRunsPolicy();
        }
        return new BufferHandler();
    }

    public PooledExecutorWithDMStats(BlockingQueue<Runnable> q, int maxPoolSize, PoolStatHelper stats, ThreadFactory tf, int msTimeout, ThreadsMonitoring tMonitoring) {
        this(PooledExecutorWithDMStats.initQ(q), maxPoolSize, stats, tf, msTimeout, PooledExecutorWithDMStats.initREH(q), tMonitoring);
        if (!(q instanceof SynchronousQueue)) {
            this.bufferQueue = q;
            final BlockingQueue<Runnable> takeQueue = q;
            final BlockingQueue<Runnable> putQueue = this.getQueue();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            SystemFailure.checkFailure();
                            Runnable job = (Runnable)takeQueue.take();
                            putQueue.put(job);
                        }
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            };
            this.bufferConsumer = tf.newThread(r);
            this.bufferConsumer.start();
        }
    }

    @Override
    public void shutdown() {
        try {
            super.shutdown();
        }
        finally {
            this.terminated();
        }
    }

    @Override
    protected void terminated() {
        if (this.bufferConsumer != null) {
            this.bufferConsumer.interrupt();
        }
        super.terminated();
    }

    public List shutdownNow() {
        this.terminated();
        List<Runnable> l = super.shutdownNow();
        if (this.bufferQueue != null) {
            this.bufferQueue.drainTo(l);
        }
        return l;
    }

    public PooledExecutorWithDMStats(BlockingQueue<Runnable> q, int poolSize, PoolStatHelper stats, ThreadFactory tf, ThreadsMonitoring tMonitoring, String systemPropertyPrefix) {
        this(q, poolSize, stats, tf, Integer.getInteger(systemPropertyPrefix + "IDLE_THREAD_TIMEOUT", 1800000), tMonitoring);
    }

    public PooledExecutorWithDMStats(BlockingQueue<Runnable> q, int poolSize, ThreadFactory tf, ThreadsMonitoring tMonitoring, String systemPropertyPrefix) {
        this(q, poolSize, null, tf, tMonitoring, systemPropertyPrefix);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        if (this.stats != null) {
            this.stats.startJob();
        }
        if (this.threadMonitoring != null) {
            this.threadMonitoring.startMonitor(ThreadsMonitoring.Mode.PooledExecutor);
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable ex) {
        if (this.stats != null) {
            this.stats.endJob();
        }
        if (this.threadMonitoring != null) {
            this.threadMonitoring.endMonitor();
        }
    }

    private static int getCorePoolSize(int maxSize) {
        if (maxSize == Integer.MAX_VALUE) {
            return 0;
        }
        return 1;
    }

    public static class BufferHandler
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("executor has been shutdown");
            }
            try {
                PooledExecutorWithDMStats pool = (PooledExecutorWithDMStats)executor;
                pool.bufferQueue.put(r);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                RejectedExecutionException e = new RejectedExecutionException("interrupted");
                e.initCause(ie);
                throw e;
            }
        }
    }

    public static class BlockHandler
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("executor has been shutdown");
            }
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                RejectedExecutionException e = new RejectedExecutionException("interrupted");
                e.initCause(ie);
            }
        }
    }
}

