/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminMultipleReplyProcessor;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.CliLegacyMessage;
import org.apache.geode.internal.admin.remote.CompactResponse;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class CompactRequest
extends CliLegacyMessage {
    private static final Logger logger = LogService.getLogger();

    public static Map<DistributedMember, Set<PersistentID>> send(DistributionManager dm) {
        Set<InternalDistributedMember> recipients = dm.getOtherDistributionManagerIds();
        CompactRequest request = new CompactRequest();
        request.setRecipients(recipients);
        CompactReplyProcessor replyProcessor = new CompactReplyProcessor(dm, recipients);
        request.msgId = replyProcessor.getProcessorId();
        dm.putOutgoing(request);
        request.setSender(dm.getDistributionManagerId());
        request.process((ClusterDistributionManager)dm);
        try {
            replyProcessor.waitForReplies();
        }
        catch (ReplyException e) {
            if (!(e.getCause() instanceof CancelException)) {
                throw e;
            }
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        return replyProcessor.results;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        super.process(dm);
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        InternalCache cache = dm.getCache();
        HashSet<PersistentID> compactedStores = new HashSet<PersistentID>();
        if (cache != null && !cache.isClosed()) {
            for (DiskStore store : cache.listDiskStoresIncludingRegionOwned()) {
                if (!store.forceCompaction()) continue;
                compactedStores.add(((DiskStoreImpl)store).getPersistentID());
            }
        }
        return new CompactResponse(this.getSender(), compactedStores);
    }

    public int getDSFID() {
        return 2118;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
    }

    @Override
    public String toString() {
        return "Compact request sent to " + this.getRecipientsDescription() + " from " + this.getSender();
    }

    private static class CompactReplyProcessor
    extends AdminMultipleReplyProcessor {
        Map<DistributedMember, Set<PersistentID>> results = Collections.synchronizedMap(new HashMap());

        CompactReplyProcessor(DistributionManager dm, Collection initMembers) {
            super(dm, initMembers);
        }

        @Override
        protected boolean stopBecauseOfExceptions() {
            return false;
        }

        @Override
        protected boolean allowReplyFromSender() {
            return true;
        }

        @Override
        protected void process(DistributionMessage message, boolean warn) {
            HashSet<PersistentID> persistentIds;
            if (message instanceof CompactResponse && (persistentIds = ((CompactResponse)message).getPersistentIds()) != null && !persistentIds.isEmpty()) {
                this.results.put(message.getSender(), persistentIds);
            }
            super.process(message, warn);
        }
    }
}

