/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.RemoveHealthListenerResponse;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class RemoveHealthListenerRequest
extends AdminRequest {
    private int id;

    public static RemoveHealthListenerRequest create(int id) {
        RemoveHealthListenerRequest m = new RemoveHealthListenerRequest();
        m.id = id;
        return m;
    }

    public RemoveHealthListenerRequest() {
        this.friendlyName = "Remove health listener";
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        return RemoveHealthListenerResponse.create(dm, this.getSender(), this.id);
    }

    public int getDSFID() {
        return 1049;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.id);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.id = in.readInt();
    }

    @Override
    public String toString() {
        return "RemoveHealthListenerRequest from " + this.getRecipient() + " id=" + this.id;
    }
}

