/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.HashSet;
import java.util.Set;

public class BucketSetHelper {
    public static int get(int[] bucketSet, int index) {
        return bucketSet[index + 1];
    }

    public static int length(int[] bucketSet) {
        return null == bucketSet || bucketSet.length < 2 ? 0 : bucketSet[0];
    }

    public static void add(int[] bucketSet, int value) {
        int index = bucketSet[0] + 1;
        bucketSet[index] = value;
        bucketSet[0] = index;
    }

    public static Set<Integer> toSet(int[] bucketSet) {
        HashSet<Integer> resultSet;
        int arrayLength = BucketSetHelper.length(bucketSet);
        if (arrayLength > 0) {
            resultSet = new HashSet(arrayLength);
            for (int i = 1; i <= arrayLength; ++i) {
                resultSet.add(bucketSet[i]);
            }
        } else {
            resultSet = new HashSet<Integer>();
        }
        return resultSet;
    }

    public static int[] fromSet(Set<Integer> bucketSet) {
        int setSize = bucketSet.size();
        int[] resultArray = new int[setSize + 1];
        resultArray[0] = setSize;
        if (setSize > 0) {
            int i = 1;
            for (Integer element : bucketSet) {
                resultArray[i] = element;
                ++i;
            }
        }
        return resultArray;
    }
}

