/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class DiskRegionStats {
    @Immutable
    private static final StatisticsType type;
    private static final int writesId;
    private static final int writeTimeId;
    private static final int bytesWrittenId;
    private static final int readsId;
    private static final int readTimeId;
    private static final int writesInProgressId;
    private static final int bytesReadId;
    private static final int removesId;
    private static final int removeTimeId;
    private static final int numOverflowOnDiskId;
    private static final int numEntriesInVMId;
    private static final int numOverflowBytesOnDiskId;
    private static final int localInitializationsId;
    private static final int remoteInitializationsId;
    private final Statistics stats;

    public DiskRegionStats(StatisticsFactory f, String name) {
        this.stats = f.createAtomicStatistics(type, name);
    }

    public void close() {
        this.stats.close();
    }

    public long getWrites() {
        return this.stats.getLong(writesId);
    }

    public long getWriteTime() {
        return this.stats.getLong(writeTimeId);
    }

    public long getBytesWritten() {
        return this.stats.getLong(bytesWrittenId);
    }

    public long getReads() {
        return this.stats.getLong(readsId);
    }

    public long getReadTime() {
        return this.stats.getLong(readTimeId);
    }

    public long getBytesRead() {
        return this.stats.getLong(bytesReadId);
    }

    public long getRemoves() {
        return this.stats.getLong(removesId);
    }

    public long getRemoveTime() {
        return this.stats.getLong(removeTimeId);
    }

    public long getNumOverflowOnDisk() {
        return this.stats.getLong(numOverflowOnDiskId);
    }

    public long getNumOverflowBytesOnDisk() {
        return this.stats.getLong(numOverflowBytesOnDiskId);
    }

    public long getNumEntriesInVM() {
        return this.stats.getLong(numEntriesInVMId);
    }

    public void incNumOverflowOnDisk(long delta) {
        this.stats.incLong(numOverflowOnDiskId, delta);
    }

    public void incNumEntriesInVM(long delta) {
        this.stats.incLong(numEntriesInVMId, delta);
    }

    public void incNumOverflowBytesOnDisk(long delta) {
        this.stats.incLong(numOverflowBytesOnDiskId, delta);
    }

    public void startWrite() {
        this.stats.incInt(writesInProgressId, 1);
    }

    public void incWrittenBytes(long bytesWritten) {
        this.stats.incLong(bytesWrittenId, bytesWritten);
    }

    public void endWrite(long start, long end) {
        this.stats.incInt(writesInProgressId, -1);
        this.stats.incLong(writesId, 1L);
        this.stats.incLong(writeTimeId, end - start);
    }

    public void endRead(long start, long end, long bytesRead) {
        this.stats.incLong(readsId, 1L);
        this.stats.incLong(readTimeId, end - start);
        this.stats.incLong(bytesReadId, bytesRead);
    }

    public void endRemove(long start, long end) {
        this.stats.incLong(removesId, 1L);
        this.stats.incLong(removeTimeId, end - start);
    }

    public void incInitializations(boolean local) {
        if (local) {
            this.stats.incInt(localInitializationsId, 1);
        } else {
            this.stats.incInt(remoteInitializationsId, 1);
        }
    }

    public int getLocalInitializations() {
        return this.stats.getInt(localInitializationsId);
    }

    public int getRemoteInitializations() {
        return this.stats.getInt(remoteInitializationsId);
    }

    public Statistics getStats() {
        return this.stats;
    }

    static {
        String statName = "DiskRegionStatistics";
        String statDescription = "Statistics about a Region's use of the disk";
        String writesDesc = "The total number of region entries that have been written to disk. A write is done every time an entry is created on disk or every time its value is modified on disk.";
        String writeTimeDesc = "The total amount of time spent writing to disk";
        String bytesWrittenDesc = "The total number of bytes that have been written to disk";
        String readsDesc = "The total number of region entries that have been read from disk";
        String readTimeDesc = "The total amount of time spent reading from disk";
        String bytesReadDesc = "The total number of bytes that have been read from disk";
        String removesDesc = "The total number of region entries that have been removed from disk";
        String removeTimeDesc = "The total amount of time spent removing from disk";
        String numOverflowOnDiskDesc = "The current number of entries whose value is on disk and is not in memory. This is true of overflowed entries. It is also true of recovered entries that have not yet been faulted in.";
        String numOverflowBytesOnDiskDesc = "The current number bytes on disk and not in memory. This is true of overflowed entries. It is also true of recovered entries that have not yet been faulted in.";
        String numEntriesInVMDesc = "The current number of entries whose value resides in the VM. The value may also have been written to disk.";
        String localInitializationsDesc = "The number of times that this region has been initialized solely from the local disk files (0 or 1)";
        String remoteInitializationsDesc = "The number of times that this region has been initialized by doing GII from a peer (0 or 1)";
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        type = f.createType(statName, statDescription, new StatisticDescriptor[]{f.createLongCounter("writes", "The total number of region entries that have been written to disk. A write is done every time an entry is created on disk or every time its value is modified on disk.", "ops"), f.createLongCounter("writeTime", "The total amount of time spent writing to disk", "nanoseconds"), f.createLongCounter("writtenBytes", "The total number of bytes that have been written to disk", "bytes"), f.createLongCounter("reads", "The total number of region entries that have been read from disk", "ops"), f.createLongCounter("readTime", "The total amount of time spent reading from disk", "nanoseconds"), f.createLongCounter("readBytes", "The total number of bytes that have been read from disk", "bytes"), f.createLongCounter("removes", "The total number of region entries that have been removed from disk", "ops"), f.createLongCounter("removeTime", "The total amount of time spent removing from disk", "nanoseconds"), f.createLongGauge("entriesOnlyOnDisk", "The current number of entries whose value is on disk and is not in memory. This is true of overflowed entries. It is also true of recovered entries that have not yet been faulted in.", "entries"), f.createLongGauge("bytesOnlyOnDisk", "The current number bytes on disk and not in memory. This is true of overflowed entries. It is also true of recovered entries that have not yet been faulted in.", "bytes"), f.createLongGauge("entriesInVM", "The current number of entries whose value resides in the VM. The value may also have been written to disk.", "entries"), f.createIntGauge("writesInProgress", "current number of oplog writes that are in progress", "writes"), f.createIntGauge("localInitializations", "The number of times that this region has been initialized solely from the local disk files (0 or 1)", "initializations"), f.createIntGauge("remoteInitializations", "The number of times that this region has been initialized by doing GII from a peer (0 or 1)", "initializations")});
        writesId = type.nameToId("writes");
        writeTimeId = type.nameToId("writeTime");
        bytesWrittenId = type.nameToId("writtenBytes");
        readsId = type.nameToId("reads");
        readTimeId = type.nameToId("readTime");
        bytesReadId = type.nameToId("readBytes");
        writesInProgressId = type.nameToId("writesInProgress");
        removesId = type.nameToId("removes");
        removeTimeId = type.nameToId("removeTime");
        numOverflowOnDiskId = type.nameToId("entriesOnlyOnDisk");
        numOverflowBytesOnDiskId = type.nameToId("bytesOnlyOnDisk");
        numEntriesInVMId = type.nameToId("entriesInVM");
        localInitializationsId = type.nameToId("localInitializations");
        remoteInitializationsId = type.nameToId("remoteInitializations");
    }
}

