/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.StatisticsDisabledException;
import org.apache.geode.internal.cache.CacheStatisticsImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;

public class NonTXEntry
implements Region.Entry {
    private final LocalRegion region;
    private final Object key;
    private volatile boolean entryIsDestroyed;

    @Override
    public boolean isLocal() {
        return true;
    }

    public NonTXEntry(LocalRegion region, RegionEntry regionEntry) {
        if (regionEntry == null) {
            throw new IllegalArgumentException("regionEntry should not be null");
        }
        this.region = region;
        this.key = regionEntry.getKey();
    }

    public RegionEntry getRegionEntry() {
        RegionEntry regionEntry = this.region.getRegionMap().getEntry(this.key);
        if (regionEntry == null) {
            throw new EntryDestroyedException(this.key.toString());
        }
        return regionEntry;
    }

    private RegionEntry basicGetEntry() {
        RegionEntry re = this.region.basicGetEntry(this.key);
        if (re == null) {
            throw new EntryDestroyedException(this.key.toString());
        }
        return re;
    }

    @Override
    public boolean isDestroyed() {
        if (this.entryIsDestroyed) {
            return true;
        }
        if (this.region.isThisRegionBeingClosedOrDestroyed() || this.region.basicGetEntry(this.key) == null) {
            this.entryIsDestroyed = true;
            return true;
        }
        return false;
    }

    @Override
    public Object getKey() {
        return this.basicGetEntry().getKey();
    }

    @Override
    public Object getValue() {
        return this.getValue(false);
    }

    public Object getValue(boolean ignoreCopyOnRead) {
        Object value = this.region.getDeserialized(this.basicGetEntry(), false, ignoreCopyOnRead, false, false);
        if (value == null) {
            throw new EntryDestroyedException(this.getKey().toString());
        }
        if (Token.isInvalid(value)) {
            return null;
        }
        return value;
    }

    public Object getRawValue() {
        Object value = this.basicGetEntry().getValue((RegionEntryContext)((Object)this.getRegion()));
        if (value == null) {
            throw new EntryDestroyedException(this.getRegionEntry().getKey().toString());
        }
        if (Token.isInvalid(value)) {
            return null;
        }
        return value;
    }

    public Region getRegion() {
        this.basicGetEntry();
        return this.region;
    }

    @Override
    public CacheStatistics getStatistics() {
        this.basicGetEntry();
        if (!this.region.isStatisticsEnabled()) {
            throw new StatisticsDisabledException(String.format("Statistics disabled for region '%s'", this.region.getFullPath()));
        }
        return new CacheStatisticsImpl(this.basicGetEntry(), this.region);
    }

    @Override
    public Object getUserAttribute() {
        this.basicGetEntry();
        return this.region.getEntryUserAttributes().get(this.basicGetEntry().getKey());
    }

    @Override
    public Object setUserAttribute(Object userAttribute) {
        return this.region.getEntryUserAttributes().put(this.basicGetEntry().getKey(), userAttribute);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof NonTXEntry)) {
            return false;
        }
        NonTXEntry entry = (NonTXEntry)obj;
        return this.basicGetEntry().equals(entry.getRegionEntry()) && this.getRegion() == entry.getRegion();
    }

    @Override
    public int hashCode() {
        return this.basicGetEntry().hashCode() ^ this.getRegion().hashCode();
    }

    public String toString() {
        return "NonTXEntry@" + Integer.toHexString(System.identityHashCode(this)) + ' ' + this.getRegionEntry();
    }

    @Override
    public Object setValue(Object value) {
        return this.region.put(this.getKey(), value);
    }
}

