/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.entries.VMStatsRegionEntry;
import org.apache.geode.internal.cache.entries.VMStatsRegionEntryHeapIntKey;
import org.apache.geode.internal.cache.entries.VMStatsRegionEntryHeapLongKey;
import org.apache.geode.internal.cache.entries.VMStatsRegionEntryHeapObjectKey;
import org.apache.geode.internal.cache.entries.VMStatsRegionEntryHeapStringKey1;
import org.apache.geode.internal.cache.entries.VMStatsRegionEntryHeapStringKey2;
import org.apache.geode.internal.cache.entries.VMStatsRegionEntryHeapUUIDKey;
import org.apache.geode.internal.cache.entries.VersionedStatsRegionEntryHeap;

public abstract class VMStatsRegionEntryHeap
extends VMStatsRegionEntry {
    @Immutable
    private static final VMStatsRegionEntryHeapFactory factory = new VMStatsRegionEntryHeapFactory();

    public VMStatsRegionEntryHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VMStatsRegionEntryHeapFactory
    implements RegionEntryFactory {
        private VMStatsRegionEntryHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VMStatsRegionEntryHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VMStatsRegionEntryHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VMStatsRegionEntryHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VMStatsRegionEntryHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VMStatsRegionEntryHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VMStatsRegionEntryHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VMStatsRegionEntryHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return VersionedStatsRegionEntryHeap.getEntryFactory();
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return this;
        }
    }
}

