/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.entries.VMThinDiskRegionEntryOffHeap;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VMThinDiskRegionEntryOffHeapStringKey2
extends VMThinDiskRegionEntryOffHeap {
    private static final AtomicLongFieldUpdater<VMThinDiskRegionEntryOffHeapStringKey2> LAST_MODIFIED_UPDATER = AtomicLongFieldUpdater.newUpdater(VMThinDiskRegionEntryOffHeapStringKey2.class, "lastModified");
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry;
    private volatile long lastModified;
    private volatile long offHeapAddress;
    private static final AtomicLongFieldUpdater<VMThinDiskRegionEntryOffHeapStringKey2> OFF_HEAP_ADDRESS_UPDATER = AtomicLongFieldUpdater.newUpdater(VMThinDiskRegionEntryOffHeapStringKey2.class, "offHeapAddress");
    protected DiskId id;
    private final long bits1;
    private final long bits2;

    public VMThinDiskRegionEntryOffHeapStringKey2(RegionEntryContext context, String key, Object value, boolean byteEncode) {
        super(context, value instanceof DiskEntry.RecoveredEntry ? null : value);
        this.initialize(context, value);
        long tempBits1 = 0L;
        long tempBits2 = 0L;
        if (byteEncode) {
            for (int i = key.length() - 1; i >= 0; --i) {
                if (i < 7) {
                    tempBits1 |= (long)((byte)key.charAt(i) & 0xFF);
                    tempBits1 <<= 8;
                    continue;
                }
                tempBits2 <<= 8;
                tempBits2 |= (long)((byte)key.charAt(i) & 0xFF);
            }
            tempBits1 |= 0x40L;
        } else {
            for (int i = key.length() - 1; i >= 0; --i) {
                if (i < 3) {
                    tempBits1 |= (long)key.charAt(i);
                    tempBits1 <<= 16;
                    continue;
                }
                tempBits2 <<= 16;
                tempBits2 |= (long)key.charAt(i);
            }
        }
        this.bits1 = tempBits1 |= (long)key.length();
        this.bits2 = tempBits2;
    }

    @Override
    public Token getValueAsToken() {
        return OffHeapRegionEntryHelper.getValueAsToken(this);
    }

    @Override
    protected Object getValueField() {
        return OffHeapRegionEntryHelper._getValue(this);
    }

    @Override
    protected void setValueField(Object value) {
        OffHeapRegionEntryHelper.setValue(this, value);
    }

    @Override
    public Object getValueRetain(RegionEntryContext context, boolean decompress) {
        return OffHeapRegionEntryHelper._getValueRetain(this, decompress, context);
    }

    @Override
    public long getAddress() {
        return OFF_HEAP_ADDRESS_UPDATER.get(this);
    }

    @Override
    public boolean setAddress(long expectedAddress, long newAddress) {
        return OFF_HEAP_ADDRESS_UPDATER.compareAndSet(this, expectedAddress, newAddress);
    }

    @Override
    public void release() {
        OffHeapRegionEntryHelper.releaseEntry(this);
    }

    @Override
    public void returnToPool() {
    }

    @Override
    protected long getLastModifiedField() {
        return LAST_MODIFIED_UPDATER.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return LAST_MODIFIED_UPDATER.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int hash) {
        this.hash = hash;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.nextEntry;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry) {
        this.nextEntry = nextEntry;
    }

    protected void initialize(RegionEntryContext context, Object value) {
        this.diskInitialize(context, value);
    }

    @Override
    public int updateAsyncEntrySize(EvictionController evictionController) {
        throw new IllegalStateException("should never be called");
    }

    @Override
    public DiskId getDiskId() {
        return this.id;
    }

    @Override
    public void setDiskId(RegionEntry oldEntry) {
        this.id = ((DiskEntry)oldEntry).getDiskId();
    }

    private void diskInitialize(RegionEntryContext context, Object value) {
        DiskRecoveryStore diskRecoveryStore = (DiskRecoveryStore)((Object)context);
        DiskStoreImpl diskStore = diskRecoveryStore.getDiskStore();
        long maxOplogSize = diskStore.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, true, diskStore.needsLinkedList());
        DiskEntry.Helper.initialize(this, diskRecoveryStore, value);
    }

    private int getKeyLength() {
        return (int)(this.bits1 & 0x3FL);
    }

    private int getEncoding() {
        return (int)(this.bits1 >> 6) & 3;
    }

    @Override
    public Object getKey() {
        int keyLength = this.getKeyLength();
        char[] chars = new char[keyLength];
        long tempBits1 = this.bits1;
        long tempBits2 = this.bits2;
        if (this.getEncoding() == 1) {
            for (int i = 0; i < keyLength; ++i) {
                if (i < 7) {
                    chars[i] = (char)((tempBits1 >>= 8) & 0xFFL);
                    continue;
                }
                chars[i] = (char)(tempBits2 & 0xFFL);
                tempBits2 >>= 8;
            }
        } else {
            for (int i = 0; i < keyLength; ++i) {
                if (i < 3) {
                    chars[i] = (char)((tempBits1 >>= 16) & 0xFFFFL);
                    continue;
                }
                chars[i] = (char)(tempBits2 & 0xFFFFL);
                tempBits2 >>= 16;
            }
        }
        return new String(chars);
    }

    @Override
    public boolean isKeyEqual(Object key) {
        if (key instanceof String) {
            String stringKey = (String)key;
            int keyLength = this.getKeyLength();
            if (stringKey.length() == keyLength) {
                long tempBits1 = this.bits1;
                long tempBits2 = this.bits2;
                if (this.getEncoding() == 1) {
                    for (int i = 0; i < keyLength; ++i) {
                        char character;
                        if (i < 7) {
                            character = (char)((tempBits1 >>= 8) & 0xFFL);
                        } else {
                            character = (char)(tempBits2 & 0xFFL);
                            tempBits2 >>= 8;
                        }
                        if (stringKey.charAt(i) == character) continue;
                        return false;
                    }
                } else {
                    for (int i = 0; i < keyLength; ++i) {
                        char character;
                        if (i < 3) {
                            character = (char)((tempBits1 >>= 16) & 0xFFFFL);
                        } else {
                            character = (char)(tempBits2 & 0xFFFFL);
                            tempBits2 >>= 16;
                        }
                        if (stringKey.charAt(i) == character) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

