/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.eviction;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.eviction.AbstractEvictionList;
import org.apache.geode.internal.cache.eviction.EvictableEntry;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.eviction.EvictionNode;
import org.apache.geode.internal.cache.versions.RegionVersionVector;
import org.apache.geode.internal.lang.SystemPropertyHelper;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class LRUListWithAsyncSorting
extends AbstractEvictionList {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    private static final Optional<Integer> EVICTION_SCAN_MAX_THREADS = SystemPropertyHelper.getProductIntegerProperty("EvictionScanMaxThreads");
    @MakeNotStatic
    private static final ExecutorService SINGLETON_EXECUTOR = LRUListWithAsyncSorting.createExecutor();
    private static final int DEFAULT_EVICTION_SCAN_THRESHOLD_PERCENT = 25;
    private static final int DEFAULT_MAX_EVICTION_ATTEMPTS = 10;
    private final AtomicInteger recentlyUsedCounter = new AtomicInteger();
    private final double scanThreshold = this.calculateScanThreshold();
    private final int maxEvictionAttempts;
    private Future<?> currentScan;
    private final ExecutorService executor;

    private static ExecutorService createExecutor() {
        int threads = EVICTION_SCAN_MAX_THREADS.orElse(0);
        if (threads < 1) {
            threads = Math.max(Runtime.getRuntime().availableProcessors() / 4, 1);
        }
        return LoggingExecutors.newFixedThreadPool((String)"LRUListWithAsyncSortingThread", (boolean)true, (int)threads);
    }

    LRUListWithAsyncSorting(EvictionController controller) {
        this(controller, SINGLETON_EXECUTOR, 10);
    }

    LRUListWithAsyncSorting(EvictionController controller, ExecutorService executor, int maxEvictionAttempts) {
        super(controller);
        this.executor = executor;
        this.maxEvictionAttempts = maxEvictionAttempts;
    }

    private double calculateScanThreshold() {
        Optional<Integer> configuredThresholdPercent = SystemPropertyHelper.getProductIntegerProperty("EvictionScanThresholdPercent");
        int thresholdPercent = configuredThresholdPercent.orElse(25);
        if (thresholdPercent < 0 || thresholdPercent > 100) {
            thresholdPercent = 25;
        }
        return (double)thresholdPercent / 100.0;
    }

    @Override
    public void clear(RegionVersionVector regionVersionVector, BucketRegion bucketRegion) {
        super.clear(regionVersionVector, bucketRegion);
        this.recentlyUsedCounter.set(0);
    }

    @Override
    public EvictableEntry getEvictableEntry() {
        EvictionNode evictionNode;
        int evictionAttempts = 0;
        while (true) {
            if ((evictionNode = this.unlinkHeadEntry()) == null) {
                return null;
            }
            if (logger.isTraceEnabled(LogMarker.LRU_CLOCK_VERBOSE)) {
                logger.trace(LogMarker.LRU_CLOCK_VERBOSE, "lru considering {}", (Object)evictionNode);
            }
            if (!this.isEvictable(evictionNode)) continue;
            if (!evictionNode.isRecentlyUsed() || evictionAttempts >= this.maxEvictionAttempts) break;
            ++evictionAttempts;
            evictionNode.unsetRecentlyUsed();
            this.appendEntry(evictionNode);
        }
        if (logger.isTraceEnabled(LogMarker.LRU_CLOCK_VERBOSE)) {
            logger.trace(LogMarker.LRU_CLOCK_VERBOSE, "returning unused entry: {}", (Object)evictionNode);
        }
        if (evictionNode.isRecentlyUsed()) {
            this.scanIfNeeded();
            this.getStatistics().incGreedyReturns(1L);
        }
        return (EvictableEntry)evictionNode;
    }

    private synchronized void scanIfNeeded() {
        if (!this.scanInProgress()) {
            this.recentlyUsedCounter.set(0);
            this.currentScan = this.executor.submit(this::scan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scan() {
        EvictionNode evictionNode;
        do {
            LRUListWithAsyncSorting lRUListWithAsyncSorting = this;
            synchronized (lRUListWithAsyncSorting) {
                evictionNode = this.head.next();
            }
            for (int nodesToIterate = this.size(); evictionNode != null && evictionNode != this.tail && nodesToIterate > 0; --nodesToIterate) {
                if (evictionNode.isRecentlyUsed()) {
                    evictionNode.unsetRecentlyUsed();
                    evictionNode = this.moveToTailAndGetNext(evictionNode);
                    continue;
                }
                LRUListWithAsyncSorting lRUListWithAsyncSorting2 = this;
                synchronized (lRUListWithAsyncSorting2) {
                    evictionNode = evictionNode.next();
                    continue;
                }
            }
        } while (evictionNode == null);
    }

    @Override
    public void incrementRecentlyUsed() {
        int recentlyUsedCount = this.recentlyUsedCounter.incrementAndGet();
        if (this.hasThresholdBeenMet(recentlyUsedCount)) {
            this.scanIfNeeded();
        }
    }

    int getRecentlyUsedCount() {
        return this.recentlyUsedCounter.get();
    }

    private boolean scanInProgress() {
        return this.currentScan != null && !this.currentScan.isDone();
    }

    private boolean hasThresholdBeenMet(int recentlyUsedCount) {
        return this.size() >= this.maxEvictionAttempts && (double)recentlyUsedCount / (double)this.size() >= this.scanThreshold;
    }

    private synchronized EvictionNode moveToTailAndGetNext(EvictionNode evictionNode) {
        EvictionNode next = evictionNode.next();
        if (next != null && next != this.tail) {
            EvictionNode previous = evictionNode.previous();
            next.setPrevious(previous);
            previous.setNext(next);
            evictionNode.setNext(this.tail);
            this.tail.previous().setNext(evictionNode);
            evictionNode.setPrevious(this.tail.previous());
            this.tail.setPrevious(evictionNode);
        }
        return next;
    }
}

