/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.snapshot;

import java.io.IOException;
import java.util.Map;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.snapshot.SnapshotOptions;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.snapshot.RegionSnapshotServiceImpl;
import org.apache.geode.internal.cache.snapshot.SnapshotPacket;

public class LocalExporter<K, V>
implements RegionSnapshotServiceImpl.Exporter<K, V> {
    @Override
    public long export(Region<K, V> region, RegionSnapshotServiceImpl.ExportSink sink, SnapshotOptions<K, V> options) throws IOException {
        LocalRegion local = RegionSnapshotServiceImpl.getLocalRegion(region);
        long count = 0L;
        for (Map.Entry<K, V> entry : region.entrySet()) {
            try {
                if (options.getFilter() != null && !options.getFilter().accept(entry)) continue;
                sink.write(new SnapshotPacket.SnapshotRecord(local, entry));
                ++count;
            }
            catch (EntryDestroyedException entryDestroyedException) {}
        }
        return count;
    }
}

