/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.cache.server.ServerLoad;
import org.apache.geode.distributed.internal.PoolStatHelper;
import org.apache.geode.internal.cache.tier.sockets.MessageStats;

public class CacheServerStats
implements MessageStats {
    private static final String typeName = "CacheServerStats";
    protected Statistics stats;
    int getRequestsId;
    int readGetRequestTimeId;
    int processGetTimeId;
    int getResponsesId;
    int writeGetResponseTimeId;
    int putAllRequestsId;
    int readPutAllRequestTimeId;
    int processPutAllTimeId;
    int putAllResponsesId;
    int writePutAllResponseTimeId;
    int removeAllRequestsId;
    int readRemoveAllRequestTimeId;
    int processRemoveAllTimeId;
    int removeAllResponsesId;
    int writeRemoveAllResponseTimeId;
    int getAllRequestsId;
    int readGetAllRequestTimeId;
    int processGetAllTimeId;
    int getAllResponsesId;
    int writeGetAllResponseTimeId;
    int putRequestsId;
    int readPutRequestTimeId;
    int processPutTimeId;
    int putResponsesId;
    int writePutResponseTimeId;
    int destroyRequestsId;
    int readDestroyRequestTimeId;
    int processDestroyTimeId;
    int destroyResponsesId;
    int writeDestroyResponseTimeId;
    int queryRequestsId;
    int readQueryRequestTimeId;
    int processQueryTimeId;
    int queryResponsesId;
    int writeQueryResponseTimeId;
    int destroyRegionRequestsId;
    int readDestroyRegionRequestTimeId;
    int processDestroyRegionTimeId;
    int destroyRegionResponsesId;
    int writeDestroyRegionResponseTimeId;
    int containsKeyRequestsId;
    int readContainsKeyRequestTimeId;
    int processContainsKeyTimeId;
    int containsKeyResponsesId;
    int writeContainsKeyResponseTimeId;
    int clearRegionRequestsId;
    int readClearRegionRequestTimeId;
    int processClearRegionTimeId;
    int clearRegionResponsesId;
    int writeClearRegionResponseTimeId;
    int processBatchRequestsId;
    int readProcessBatchRequestTimeId;
    int processBatchTimeId;
    int processBatchResponsesId;
    int writeProcessBatchResponseTimeId;
    int batchSizeId;
    int clientNotificationRequestsId;
    int readClientNotificationRequestTimeId;
    int processClientNotificationTimeId;
    int updateClientNotificationRequestsId;
    int readUpdateClientNotificationRequestTimeId;
    int processUpdateClientNotificationTimeId;
    int closeConnectionRequestsId;
    int readCloseConnectionRequestTimeId;
    int processCloseConnectionTimeId;
    int clientReadyRequestsId;
    int readClientReadyRequestTimeId;
    int processClientReadyTimeId;
    int clientReadyResponsesId;
    int writeClientReadyResponseTimeId;
    int currentClientConnectionsId;
    int currentQueueConnectionsId;
    int currentClientsId;
    int failedConnectionAttemptsId;
    int receivedBytesId;
    int sentBytesId;
    int outOfOrderBatchIdsId;
    int abandonedWriteRequestsId;
    int abandonedReadRequestsId;
    int messagesBeingReceivedId;
    int messageBytesBeingReceivedId;
    int connectionsTimedOutId;
    int threadQueueSizeId;
    int acceptsInProgressId;
    int acceptThreadStartsId;
    int connectionThreadStartsId;
    int connectionThreadsId;
    int connectionLoadId;
    int queueLoadId;
    int loadPerConnectionId;
    int loadPerQueueId;
    protected StatisticsType statType;

    public CacheServerStats(StatisticsFactory statisticsFactory, String ownerName) {
        this(statisticsFactory, ownerName, typeName, null);
    }

    public CacheServerStats(StatisticsFactory statisticsFactory, String ownerName, String typeName, StatisticDescriptor[] descriptors) {
        StatisticDescriptor[] serverStatDescriptors;
        if (statisticsFactory == null) {
            return;
        }
        StatisticDescriptor[] alldescriptors = serverStatDescriptors = new StatisticDescriptor[]{statisticsFactory.createIntCounter("getRequests", "Number of cache client get requests.", "operations"), statisticsFactory.createLongCounter("readGetRequestTime", "Total time spent in reading get requests.", "nanoseconds"), statisticsFactory.createLongCounter("processGetTime", "Total time spent in processing a cache client get request, including the time to get an object from the cache.", "nanoseconds"), statisticsFactory.createIntCounter("getResponses", "Number of get responses written to the cache client.", "operations"), statisticsFactory.createLongCounter("writeGetResponseTime", "Total time spent in writing get responses.", "nanoseconds"), statisticsFactory.createIntCounter("putRequests", "Number of cache client put requests.", "operations"), statisticsFactory.createLongCounter("readPutRequestTime", "Total time spent in reading put requests.", "nanoseconds"), statisticsFactory.createLongCounter("processPutTime", "Total time spent in processing a cache client put request, including the time to put an object into the cache.", "nanoseconds"), statisticsFactory.createIntCounter("putResponses", "Number of put responses written to the cache client.", "operations"), statisticsFactory.createLongCounter("writePutResponseTime", "Total time spent in writing put responses.", "nanoseconds"), statisticsFactory.createIntCounter("putAllRequests", "Number of cache client putAll requests.", "operations"), statisticsFactory.createLongCounter("readPutAllRequestTime", "Total time spent in reading putAll requests.", "nanoseconds"), statisticsFactory.createLongCounter("processPutAllTime", "Total time spent in processing a cache client putAll request, including the time to put all objects into the cache.", "nanoseconds"), statisticsFactory.createIntCounter("putAllResponses", "Number of putAll responses written to the cache client.", "operations"), statisticsFactory.createLongCounter("writePutAllResponseTime", "Total time spent in writing putAll responses.", "nanoseconds"), statisticsFactory.createIntCounter("removeAllRequests", "Number of cache client removeAll requests.", "operations"), statisticsFactory.createLongCounter("readRemoveAllRequestTime", "Total time spent in reading removeAll requests.", "nanoseconds"), statisticsFactory.createLongCounter("processRemoveAllTime", "Total time spent in processing a cache client removeAll request, including the time to remove all objects from the cache.", "nanoseconds"), statisticsFactory.createIntCounter("removeAllResponses", "Number of removeAll responses written to the cache client.", "operations"), statisticsFactory.createLongCounter("writeRemoveAllResponseTime", "Total time spent in writing removeAll responses.", "nanoseconds"), statisticsFactory.createIntCounter("getAllRequests", "Number of cache client getAll requests.", "operations"), statisticsFactory.createLongCounter("readGetAllRequestTime", "Total time spent in reading getAll requests.", "nanoseconds"), statisticsFactory.createLongCounter("processGetAllTime", "Total time spent in processing a cache client getAll request.", "nanoseconds"), statisticsFactory.createIntCounter("getAllResponses", "Number of getAll responses written to the cache client.", "operations"), statisticsFactory.createLongCounter("writeGetAllResponseTime", "Total time spent in writing getAll responses.", "nanoseconds"), statisticsFactory.createIntCounter("destroyRequests", "Number of cache client destroy requests.", "operations"), statisticsFactory.createLongCounter("readDestroyRequestTime", "Total time spent in reading destroy requests.", "nanoseconds"), statisticsFactory.createLongCounter("processDestroyTime", "Total time spent in processing a cache client destroy request, including the time to destroy an object from the cache.", "nanoseconds"), statisticsFactory.createIntCounter("destroyResponses", "Number of destroy responses written to the cache client.", "operations"), statisticsFactory.createLongCounter("writeDestroyResponseTime", "Total time spent in writing destroy responses.", "nanoseconds"), statisticsFactory.createIntCounter("invalidateRequests", "Number of cache client invalidate requests.", "operations"), statisticsFactory.createLongCounter("readInvalidateRequestTime", "Total time spent in reading invalidate requests.", "nanoseconds"), statisticsFactory.createLongCounter("processInvalidateTime", "Total time spent in processing a cache client invalidate request, including the time to invalidate an object from the cache.", "nanoseconds"), statisticsFactory.createIntCounter("invalidateResponses", "Number of invalidate responses written to the cache client.", "operations"), statisticsFactory.createLongCounter("writeInvalidateResponseTime", "Total time spent in writing invalidate responses.", "nanoseconds"), statisticsFactory.createIntCounter("sizeRequests", "Number of cache client size requests.", "operations"), statisticsFactory.createLongCounter("readSizeRequestTime", "Total time spent in reading size requests.", "nanoseconds"), statisticsFactory.createLongCounter("processSizeTime", "Total time spent in processing a cache client size request, including the time to size an object from the cache.", "nanoseconds"), statisticsFactory.createIntCounter("sizeResponses", "Number of size responses written to the cache client.", "operations"), statisticsFactory.createLongCounter("writeSizeResponseTime", "Total time spent in writing size responses.", "nanoseconds"), statisticsFactory.createIntCounter("queryRequests", "Number of cache client query requests.", "operations"), statisticsFactory.createLongCounter("readQueryRequestTime", "Total time spent in reading query requests.", "nanoseconds"), statisticsFactory.createLongCounter("processQueryTime", "Total time spent in processing a cache client query request, including the time to destroy an object from the cache.", "nanoseconds"), statisticsFactory.createIntCounter("queryResponses", "Number of query responses written to the cache client.", "operations"), statisticsFactory.createLongCounter("writeQueryResponseTime", "Total time spent in writing query responses.", "nanoseconds"), statisticsFactory.createIntCounter("destroyRegionRequests", "Number of cache client destroyRegion requests.", "operations"), statisticsFactory.createLongCounter("readDestroyRegionRequestTime", "Total time spent in reading destroyRegion requests.", "nanoseconds"), statisticsFactory.createLongCounter("processDestroyRegionTime", "Total time spent in processing a cache client destroyRegion request, including the time to destroy the region from the cache.", "nanoseconds"), statisticsFactory.createIntCounter("destroyRegionResponses", "Number of destroyRegion responses written to the cache client.", "operations"), statisticsFactory.createLongCounter("writeDestroyRegionResponseTime", "Total time spent in writing destroyRegion responses.", "nanoseconds"), statisticsFactory.createIntCounter("containsKeyRequests", "Number of cache client containsKey requests.", "operations"), statisticsFactory.createLongCounter("readContainsKeyRequestTime", "Total time spent reading containsKey requests.", "nanoseconds"), statisticsFactory.createLongCounter("processContainsKeyTime", "Total time spent processing a containsKey request.", "nanoseconds"), statisticsFactory.createIntCounter("containsKeyResponses", "Number of containsKey responses written to the cache client.", "operations"), statisticsFactory.createLongCounter("writeContainsKeyResponseTime", "Total time spent writing containsKey responses.", "nanoseconds"), statisticsFactory.createIntCounter("processBatchRequests", "Number of cache client processBatch requests.", "operations"), statisticsFactory.createLongCounter("readProcessBatchRequestTime", "Total time spent in reading processBatch requests.", "nanoseconds"), statisticsFactory.createLongCounter("processBatchTime", "Total time spent in processing a cache client processBatch request.", "nanoseconds"), statisticsFactory.createIntCounter("processBatchResponses", "Number of processBatch responses written to the cache client.", "operations"), statisticsFactory.createLongCounter("writeProcessBatchResponseTime", "Total time spent in writing processBatch responses.", "nanoseconds"), statisticsFactory.createLongCounter("batchSize", "The size of the batches received.", "bytes"), statisticsFactory.createIntCounter("clearRegionRequests", "Number of cache client clearRegion requests.", "operations"), statisticsFactory.createLongCounter("readClearRegionRequestTime", "Total time spent in reading clearRegion requests.", "nanoseconds"), statisticsFactory.createLongCounter("processClearRegionTime", "Total time spent in processing a cache client clearRegion request, including the time to clear the region from the cache.", "nanoseconds"), statisticsFactory.createIntCounter("clearRegionResponses", "Number of clearRegion responses written to the cache client.", "operations"), statisticsFactory.createLongCounter("writeClearRegionResponseTime", "Total time spent in writing clearRegion responses.", "nanoseconds"), statisticsFactory.createIntCounter("clientNotificationRequests", "Number of cache client notification requests.", "operations"), statisticsFactory.createLongCounter("readClientNotificationRequestTime", "Total time spent in reading client notification requests.", "nanoseconds"), statisticsFactory.createLongCounter("processClientNotificationTime", "Total time spent in processing a cache client notification request.", "nanoseconds"), statisticsFactory.createIntCounter("updateClientNotificationRequests", "Number of cache client notification update requests.", "operations"), statisticsFactory.createLongCounter("readUpdateClientNotificationRequestTime", "Total time spent in reading client notification update requests.", "nanoseconds"), statisticsFactory.createLongCounter("processUpdateClientNotificationTime", "Total time spent in processing a client notification update request.", "nanoseconds"), statisticsFactory.createIntCounter("clientReadyRequests", "Number of cache client ready requests.", "operations"), statisticsFactory.createLongCounter("readClientReadyRequestTime", "Total time spent in reading cache client ready requests.", "nanoseconds"), statisticsFactory.createLongCounter("processClientReadyTime", "Total time spent in processing a cache client ready request, including the time to destroy an object from the cache.", "nanoseconds"), statisticsFactory.createIntCounter("clientReadyResponses", "Number of client ready responses written to the cache client.", "operations"), statisticsFactory.createLongCounter("writeClientReadyResponseTime", "Total time spent in writing client ready responses.", "nanoseconds"), statisticsFactory.createIntCounter("closeConnectionRequests", "Number of cache client close connection requests.", "operations"), statisticsFactory.createLongCounter("readCloseConnectionRequestTime", "Total time spent in reading close connection requests.", "nanoseconds"), statisticsFactory.createLongCounter("processCloseConnectionTime", "Total time spent in processing a cache client close connection request.", "nanoseconds"), statisticsFactory.createIntCounter("failedConnectionAttempts", "Number of failed connection attempts.", "attempts"), statisticsFactory.createIntGauge("currentClientConnections", "Number of sockets accepted and used for client to server messaging.", "sockets"), statisticsFactory.createIntGauge("currentQueueConnections", "Number of sockets accepted and used for server to client messaging.", "sockets"), statisticsFactory.createIntGauge("currentClients", "Number of client virtual machines connected.", "clients"), statisticsFactory.createIntCounter("outOfOrderGatewayBatchIds", "Number of Out of order batch IDs.", "batches"), statisticsFactory.createIntCounter("abandonedWriteRequests", "Number of write opertations abandond by clients", "requests"), statisticsFactory.createIntCounter("abandonedReadRequests", "Number of read opertations abandond by clients", "requests"), statisticsFactory.createLongCounter("receivedBytes", "Total number of bytes received from clients.", "bytes"), statisticsFactory.createLongCounter("sentBytes", "Total number of bytes sent to clients.", "bytes"), statisticsFactory.createIntGauge("messagesBeingReceived", "Current number of message being received off the network or being processed after reception.", "messages"), statisticsFactory.createLongGauge("messageBytesBeingReceived", "Current number of bytes consumed by messages being received or processed.", "bytes"), statisticsFactory.createIntCounter("connectionsTimedOut", "Total number of connections that have been timed out by the server because of client inactivity", "connections"), statisticsFactory.createIntGauge("threadQueueSize", "Current number of connections waiting for a thread to start processing their message.", "connections"), statisticsFactory.createIntGauge("acceptsInProgress", "Current number of server accepts that are attempting to do the initial handshake with the client.", "accepts"), statisticsFactory.createIntCounter("acceptThreadStarts", "Total number of threads created to deal with an accepted socket. Note that this is not the current number of threads.", "starts"), statisticsFactory.createIntCounter("connectionThreadStarts", "Total number of threads created to deal with a client connection. Note that this is not the current number of threads.", "starts"), statisticsFactory.createIntGauge("connectionThreads", "Current number of threads dealing with a client connection.", "threads"), statisticsFactory.createDoubleGauge("connectionLoad", "The load from client to server connections as reported by the load probe installed in this server", "load"), statisticsFactory.createDoubleGauge("loadPerConnection", "The estimate of how much load is added for each new connection as reported by the load probe installed in this server", "load"), statisticsFactory.createDoubleGauge("queueLoad", "The load from queues as reported by the load probe installed in this server", "load"), statisticsFactory.createDoubleGauge("loadPerQueue", "The estimate of how much load is added for each new connection as reported by the load probe installed in this server", "load")};
        if (descriptors != null) {
            alldescriptors = new StatisticDescriptor[descriptors.length + serverStatDescriptors.length];
            System.arraycopy(descriptors, 0, alldescriptors, 0, descriptors.length);
            System.arraycopy(serverStatDescriptors, 0, alldescriptors, descriptors.length, serverStatDescriptors.length);
        }
        this.statType = statisticsFactory.createType(typeName, typeName, alldescriptors);
        this.stats = statisticsFactory.createAtomicStatistics(this.statType, ownerName);
        this.getRequestsId = this.stats.nameToId("getRequests");
        this.readGetRequestTimeId = this.stats.nameToId("readGetRequestTime");
        this.processGetTimeId = this.stats.nameToId("processGetTime");
        this.getResponsesId = this.stats.nameToId("getResponses");
        this.writeGetResponseTimeId = this.stats.nameToId("writeGetResponseTime");
        this.putRequestsId = this.stats.nameToId("putRequests");
        this.readPutRequestTimeId = this.stats.nameToId("readPutRequestTime");
        this.processPutTimeId = this.stats.nameToId("processPutTime");
        this.putResponsesId = this.stats.nameToId("putResponses");
        this.writePutResponseTimeId = this.stats.nameToId("writePutResponseTime");
        this.putAllRequestsId = this.stats.nameToId("putAllRequests");
        this.readPutAllRequestTimeId = this.stats.nameToId("readPutAllRequestTime");
        this.processPutAllTimeId = this.stats.nameToId("processPutAllTime");
        this.putAllResponsesId = this.stats.nameToId("putAllResponses");
        this.writePutAllResponseTimeId = this.stats.nameToId("writePutAllResponseTime");
        this.removeAllRequestsId = this.stats.nameToId("removeAllRequests");
        this.readRemoveAllRequestTimeId = this.stats.nameToId("readRemoveAllRequestTime");
        this.processRemoveAllTimeId = this.stats.nameToId("processRemoveAllTime");
        this.removeAllResponsesId = this.stats.nameToId("removeAllResponses");
        this.writeRemoveAllResponseTimeId = this.stats.nameToId("writeRemoveAllResponseTime");
        this.getAllRequestsId = this.stats.nameToId("getAllRequests");
        this.readGetAllRequestTimeId = this.stats.nameToId("readGetAllRequestTime");
        this.processGetAllTimeId = this.stats.nameToId("processGetAllTime");
        this.getAllResponsesId = this.stats.nameToId("getAllResponses");
        this.writeGetAllResponseTimeId = this.stats.nameToId("writeGetAllResponseTime");
        this.destroyRequestsId = this.stats.nameToId("destroyRequests");
        this.readDestroyRequestTimeId = this.stats.nameToId("readDestroyRequestTime");
        this.processDestroyTimeId = this.stats.nameToId("processDestroyTime");
        this.destroyResponsesId = this.stats.nameToId("destroyResponses");
        this.writeDestroyResponseTimeId = this.stats.nameToId("writeDestroyResponseTime");
        this.queryRequestsId = this.stats.nameToId("queryRequests");
        this.readQueryRequestTimeId = this.stats.nameToId("readQueryRequestTime");
        this.processQueryTimeId = this.stats.nameToId("processQueryTime");
        this.queryResponsesId = this.stats.nameToId("queryResponses");
        this.writeQueryResponseTimeId = this.stats.nameToId("writeQueryResponseTime");
        this.destroyRegionRequestsId = this.stats.nameToId("destroyRegionRequests");
        this.readDestroyRegionRequestTimeId = this.stats.nameToId("readDestroyRegionRequestTime");
        this.processDestroyRegionTimeId = this.stats.nameToId("processDestroyRegionTime");
        this.destroyRegionResponsesId = this.stats.nameToId("destroyRegionResponses");
        this.writeDestroyRegionResponseTimeId = this.stats.nameToId("writeDestroyRegionResponseTime");
        this.clearRegionRequestsId = this.stats.nameToId("clearRegionRequests");
        this.readClearRegionRequestTimeId = this.stats.nameToId("readClearRegionRequestTime");
        this.processClearRegionTimeId = this.stats.nameToId("processClearRegionTime");
        this.clearRegionResponsesId = this.stats.nameToId("clearRegionResponses");
        this.writeClearRegionResponseTimeId = this.stats.nameToId("writeClearRegionResponseTime");
        this.containsKeyRequestsId = this.stats.nameToId("containsKeyRequests");
        this.readContainsKeyRequestTimeId = this.stats.nameToId("readContainsKeyRequestTime");
        this.processContainsKeyTimeId = this.stats.nameToId("processContainsKeyTime");
        this.containsKeyResponsesId = this.stats.nameToId("containsKeyResponses");
        this.writeContainsKeyResponseTimeId = this.stats.nameToId("writeContainsKeyResponseTime");
        this.processBatchRequestsId = this.stats.nameToId("processBatchRequests");
        this.readProcessBatchRequestTimeId = this.stats.nameToId("readProcessBatchRequestTime");
        this.processBatchTimeId = this.stats.nameToId("processBatchTime");
        this.processBatchResponsesId = this.stats.nameToId("processBatchResponses");
        this.writeProcessBatchResponseTimeId = this.stats.nameToId("writeProcessBatchResponseTime");
        this.batchSizeId = this.stats.nameToId("batchSize");
        this.clientNotificationRequestsId = this.stats.nameToId("clientNotificationRequests");
        this.readClientNotificationRequestTimeId = this.stats.nameToId("readClientNotificationRequestTime");
        this.processClientNotificationTimeId = this.stats.nameToId("processClientNotificationTime");
        this.updateClientNotificationRequestsId = this.stats.nameToId("updateClientNotificationRequests");
        this.readUpdateClientNotificationRequestTimeId = this.stats.nameToId("readUpdateClientNotificationRequestTime");
        this.processUpdateClientNotificationTimeId = this.stats.nameToId("processUpdateClientNotificationTime");
        this.clientReadyRequestsId = this.stats.nameToId("clientReadyRequests");
        this.readClientReadyRequestTimeId = this.stats.nameToId("readClientReadyRequestTime");
        this.processClientReadyTimeId = this.stats.nameToId("processClientReadyTime");
        this.clientReadyResponsesId = this.stats.nameToId("clientReadyResponses");
        this.writeClientReadyResponseTimeId = this.stats.nameToId("writeClientReadyResponseTime");
        this.closeConnectionRequestsId = this.stats.nameToId("closeConnectionRequests");
        this.readCloseConnectionRequestTimeId = this.stats.nameToId("readCloseConnectionRequestTime");
        this.processCloseConnectionTimeId = this.stats.nameToId("processCloseConnectionTime");
        this.currentClientConnectionsId = this.stats.nameToId("currentClientConnections");
        this.currentQueueConnectionsId = this.stats.nameToId("currentQueueConnections");
        this.currentClientsId = this.stats.nameToId("currentClients");
        this.failedConnectionAttemptsId = this.stats.nameToId("failedConnectionAttempts");
        this.outOfOrderBatchIdsId = this.stats.nameToId("outOfOrderGatewayBatchIds");
        this.abandonedWriteRequestsId = this.stats.nameToId("abandonedWriteRequests");
        this.abandonedReadRequestsId = this.stats.nameToId("abandonedReadRequests");
        this.receivedBytesId = this.stats.nameToId("receivedBytes");
        this.sentBytesId = this.stats.nameToId("sentBytes");
        this.messagesBeingReceivedId = this.stats.nameToId("messagesBeingReceived");
        this.messageBytesBeingReceivedId = this.stats.nameToId("messageBytesBeingReceived");
        this.connectionsTimedOutId = this.stats.nameToId("connectionsTimedOut");
        this.threadQueueSizeId = this.stats.nameToId("threadQueueSize");
        this.acceptsInProgressId = this.stats.nameToId("acceptsInProgress");
        this.acceptThreadStartsId = this.stats.nameToId("acceptThreadStarts");
        this.connectionThreadStartsId = this.stats.nameToId("connectionThreadStarts");
        this.connectionThreadsId = this.stats.nameToId("connectionThreads");
        this.connectionLoadId = this.stats.nameToId("connectionLoad");
        this.queueLoadId = this.stats.nameToId("queueLoad");
        this.loadPerConnectionId = this.stats.nameToId("loadPerConnection");
        this.loadPerQueueId = this.stats.nameToId("loadPerQueue");
    }

    public void incAcceptThreadsCreated() {
        this.stats.incInt(this.acceptThreadStartsId, 1);
    }

    public void incConnectionThreadsCreated() {
        this.stats.incInt(this.connectionThreadStartsId, 1);
    }

    public void incAcceptsInProgress() {
        this.stats.incInt(this.acceptsInProgressId, 1);
    }

    public void decAcceptsInProgress() {
        this.stats.incInt(this.acceptsInProgressId, -1);
    }

    public void incConnectionThreads() {
        this.stats.incInt(this.connectionThreadsId, 1);
    }

    public void decConnectionThreads() {
        this.stats.incInt(this.connectionThreadsId, -1);
    }

    public void incAbandonedWriteRequests() {
        this.stats.incInt(this.abandonedWriteRequestsId, 1);
    }

    public void incAbandonedReadRequests() {
        this.stats.incInt(this.abandonedReadRequestsId, 1);
    }

    public void incFailedConnectionAttempts() {
        this.stats.incInt(this.failedConnectionAttemptsId, 1);
    }

    public void incConnectionsTimedOut() {
        this.stats.incInt(this.connectionsTimedOutId, 1);
    }

    public void incCurrentClientConnections() {
        this.stats.incInt(this.currentClientConnectionsId, 1);
    }

    public void decCurrentClientConnections() {
        this.stats.incInt(this.currentClientConnectionsId, -1);
    }

    public int getCurrentClientConnections() {
        return this.stats.getInt(this.currentClientConnectionsId);
    }

    public void incCurrentQueueConnections() {
        this.stats.incInt(this.currentQueueConnectionsId, 1);
    }

    public void decCurrentQueueConnections() {
        this.stats.incInt(this.currentQueueConnectionsId, -1);
    }

    public int getCurrentQueueConnections() {
        return this.stats.getInt(this.currentQueueConnectionsId);
    }

    public void incCurrentClients() {
        this.stats.incInt(this.currentClientsId, 1);
    }

    public void decCurrentClients() {
        this.stats.incInt(this.currentClientsId, -1);
    }

    public void incThreadQueueSize() {
        this.stats.incInt(this.threadQueueSizeId, 1);
    }

    public void decThreadQueueSize() {
        this.stats.incInt(this.threadQueueSizeId, -1);
    }

    public void incReadGetRequestTime(long delta) {
        this.stats.incLong(this.readGetRequestTimeId, delta);
        this.stats.incInt(this.getRequestsId, 1);
    }

    public void incProcessGetTime(long delta) {
        this.stats.incLong(this.processGetTimeId, delta);
    }

    public void incWriteGetResponseTime(long delta) {
        this.stats.incLong(this.writeGetResponseTimeId, delta);
        this.stats.incInt(this.getResponsesId, 1);
    }

    public void incReadPutAllRequestTime(long delta) {
        this.stats.incLong(this.readPutAllRequestTimeId, delta);
        this.stats.incInt(this.putAllRequestsId, 1);
    }

    public void incProcessPutAllTime(long delta) {
        this.stats.incLong(this.processPutAllTimeId, delta);
    }

    public void incWritePutAllResponseTime(long delta) {
        this.stats.incLong(this.writePutAllResponseTimeId, delta);
        this.stats.incInt(this.putAllResponsesId, 1);
    }

    public void incReadRemoveAllRequestTime(long delta) {
        this.stats.incLong(this.readRemoveAllRequestTimeId, delta);
        this.stats.incInt(this.removeAllRequestsId, 1);
    }

    public void incProcessRemoveAllTime(long delta) {
        this.stats.incLong(this.processRemoveAllTimeId, delta);
    }

    public void incWriteRemoveAllResponseTime(long delta) {
        this.stats.incLong(this.writeRemoveAllResponseTimeId, delta);
        this.stats.incInt(this.removeAllResponsesId, 1);
    }

    public void incReadGetAllRequestTime(long delta) {
        this.stats.incLong(this.readGetAllRequestTimeId, delta);
        this.stats.incInt(this.getAllRequestsId, 1);
    }

    public void incProcessGetAllTime(long delta) {
        this.stats.incLong(this.processGetAllTimeId, delta);
    }

    public void incWriteGetAllResponseTime(long delta) {
        this.stats.incLong(this.writeGetAllResponseTimeId, delta);
        this.stats.incInt(this.getAllResponsesId, 1);
    }

    public void incReadPutRequestTime(long delta) {
        this.stats.incLong(this.readPutRequestTimeId, delta);
        this.stats.incInt(this.putRequestsId, 1);
    }

    public void incProcessPutTime(long delta) {
        this.stats.incLong(this.processPutTimeId, delta);
    }

    public void incWritePutResponseTime(long delta) {
        this.stats.incLong(this.writePutResponseTimeId, delta);
        this.stats.incInt(this.putResponsesId, 1);
    }

    public void incReadDestroyRequestTime(long delta) {
        this.stats.incLong(this.readDestroyRequestTimeId, delta);
        this.stats.incInt(this.destroyRequestsId, 1);
    }

    public void incProcessDestroyTime(long delta) {
        this.stats.incLong(this.processDestroyTimeId, delta);
    }

    public void incWriteDestroyResponseTime(long delta) {
        this.stats.incLong(this.writeDestroyResponseTimeId, delta);
        this.stats.incInt(this.destroyResponsesId, 1);
    }

    public void incReadInvalidateRequestTime(long delta) {
    }

    public void incProcessInvalidateTime(long delta) {
    }

    public void incWriteInvalidateResponseTime(long delta) {
    }

    public void incReadSizeRequestTime(long delta) {
    }

    public void incProcessSizeTime(long delta) {
    }

    public void incWriteSizeResponseTime(long delta) {
    }

    public void incReadQueryRequestTime(long delta) {
        this.stats.incLong(this.readQueryRequestTimeId, delta);
        this.stats.incInt(this.queryRequestsId, 1);
    }

    public void incProcessQueryTime(long delta) {
        this.stats.incLong(this.processQueryTimeId, delta);
    }

    public void incWriteQueryResponseTime(long delta) {
        this.stats.incLong(this.writeQueryResponseTimeId, delta);
        this.stats.incInt(this.queryResponsesId, 1);
    }

    public void incProcessCreateCqTime(long delta) {
    }

    public void incProcessCloseCqTime(long delta) {
    }

    public void incProcessExecuteCqWithIRTime(long delta) {
    }

    public void incProcessStopCqTime(long delta) {
    }

    public void incProcessCloseClientCqsTime(long delta) {
    }

    public void incProcessGetCqStatsTime(long delta) {
    }

    public void incReadDestroyRegionRequestTime(long delta) {
        this.stats.incLong(this.readDestroyRegionRequestTimeId, delta);
        this.stats.incInt(this.destroyRegionRequestsId, 1);
    }

    public void incProcessDestroyRegionTime(long delta) {
        this.stats.incLong(this.processDestroyRegionTimeId, delta);
    }

    public void incWriteDestroyRegionResponseTime(long delta) {
        this.stats.incLong(this.writeDestroyRegionResponseTimeId, delta);
        this.stats.incInt(this.destroyRegionResponsesId, 1);
    }

    public void incReadContainsKeyRequestTime(long delta) {
        this.stats.incLong(this.readContainsKeyRequestTimeId, delta);
        this.stats.incInt(this.containsKeyRequestsId, 1);
    }

    public void incProcessContainsKeyTime(long delta) {
        this.stats.incLong(this.processContainsKeyTimeId, delta);
    }

    public void incWriteContainsKeyResponseTime(long delta) {
        this.stats.incLong(this.writeContainsKeyResponseTimeId, delta);
        this.stats.incInt(this.containsKeyResponsesId, 1);
    }

    public void incReadClearRegionRequestTime(long delta) {
        this.stats.incLong(this.readClearRegionRequestTimeId, delta);
        this.stats.incInt(this.clearRegionRequestsId, 1);
    }

    public void incProcessClearRegionTime(long delta) {
        this.stats.incLong(this.processClearRegionTimeId, delta);
    }

    public void incWriteClearRegionResponseTime(long delta) {
        this.stats.incLong(this.writeClearRegionResponseTimeId, delta);
        this.stats.incInt(this.clearRegionResponsesId, 1);
    }

    public void incReadProcessBatchRequestTime(long delta) {
        this.stats.incLong(this.readProcessBatchRequestTimeId, delta);
        this.stats.incInt(this.processBatchRequestsId, 1);
    }

    public void incWriteProcessBatchResponseTime(long delta) {
        this.stats.incLong(this.writeProcessBatchResponseTimeId, delta);
        this.stats.incInt(this.processBatchResponsesId, 1);
    }

    public void incProcessBatchTime(long delta) {
        this.stats.incLong(this.processBatchTimeId, delta);
    }

    public void incBatchSize(long size) {
        this.stats.incLong(this.batchSizeId, size);
    }

    public void incReadClientNotificationRequestTime(long delta) {
        this.stats.incLong(this.readClientNotificationRequestTimeId, delta);
        this.stats.incInt(this.clientNotificationRequestsId, 1);
    }

    public void incProcessClientNotificationTime(long delta) {
        this.stats.incLong(this.processClientNotificationTimeId, delta);
    }

    public void incReadUpdateClientNotificationRequestTime(long delta) {
        this.stats.incLong(this.readUpdateClientNotificationRequestTimeId, delta);
        this.stats.incInt(this.updateClientNotificationRequestsId, 1);
    }

    public void incProcessUpdateClientNotificationTime(long delta) {
        this.stats.incLong(this.processUpdateClientNotificationTimeId, delta);
    }

    public void incReadCloseConnectionRequestTime(long delta) {
        this.stats.incLong(this.readCloseConnectionRequestTimeId, delta);
        this.stats.incInt(this.closeConnectionRequestsId, 1);
    }

    public void incProcessCloseConnectionTime(long delta) {
        this.stats.incLong(this.processCloseConnectionTimeId, delta);
    }

    public void incOutOfOrderBatchIds() {
        this.stats.incInt(this.outOfOrderBatchIdsId, 1);
    }

    @Override
    public void incReceivedBytes(long v) {
        this.stats.incLong(this.receivedBytesId, v);
    }

    @Override
    public void incSentBytes(long v) {
        this.stats.incLong(this.sentBytesId, v);
    }

    @Override
    public void incMessagesBeingReceived(int bytes) {
        this.stats.incInt(this.messagesBeingReceivedId, 1);
        if (bytes > 0) {
            this.stats.incLong(this.messageBytesBeingReceivedId, (long)bytes);
        }
    }

    @Override
    public void decMessagesBeingReceived(int bytes) {
        this.stats.incInt(this.messagesBeingReceivedId, -1);
        if (bytes > 0) {
            this.stats.incLong(this.messageBytesBeingReceivedId, (long)(-bytes));
        }
    }

    public void incReadClientReadyRequestTime(long delta) {
        this.stats.incLong(this.readClientReadyRequestTimeId, delta);
        this.stats.incInt(this.clientReadyRequestsId, 1);
    }

    public void incProcessClientReadyTime(long delta) {
        this.stats.incLong(this.processClientReadyTimeId, delta);
    }

    public void incWriteClientReadyResponseTime(long delta) {
        this.stats.incLong(this.writeClientReadyResponseTimeId, delta);
        this.stats.incInt(this.clientReadyResponsesId, 1);
    }

    public void setLoad(ServerLoad load) {
        this.stats.setDouble(this.connectionLoadId, (double)load.getConnectionLoad());
        this.stats.setDouble(this.queueLoadId, (double)load.getSubscriptionConnectionLoad());
        this.stats.setDouble(this.loadPerConnectionId, (double)load.getLoadPerConnection());
        this.stats.setDouble(this.loadPerQueueId, (double)load.getLoadPerSubscriptionConnection());
    }

    public double getQueueLoad() {
        return this.stats.getDouble(this.queueLoadId);
    }

    public double getLoadPerQueue() {
        return this.stats.getDouble(this.loadPerQueueId);
    }

    public double getConnectionLoad() {
        return this.stats.getDouble(this.connectionLoadId);
    }

    public double getLoadPerConnection() {
        return this.stats.getDouble(this.loadPerConnectionId);
    }

    public int getProcessBatchRequests() {
        return this.stats.getInt(this.processBatchRequestsId);
    }

    public void close() {
        this.stats.close();
    }

    public PoolStatHelper getCnxPoolHelper() {
        return new PoolStatHelper(){

            @Override
            public void startJob() {
                CacheServerStats.this.incConnectionThreads();
            }

            @Override
            public void endJob() {
                CacheServerStats.this.decConnectionThreads();
            }
        };
    }

    public Statistics getStats() {
        return this.stats;
    }
}

