/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.geode.internal.cache.Conflatable;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.HAEventWrapper;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ClientRegistrationEventQueueManager {
    private static final Logger logger = LogService.getLogger();
    private final Set<ClientRegistrationEventQueue> registeringProxyEventQueues = ConcurrentHashMap.newKeySet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(InternalCacheEvent event, Conflatable conflatable, Set<ClientProxyMembershipID> originalFilterClientIDs, CacheClientNotifier cacheClientNotifier) {
        if (this.registeringProxyEventQueues.isEmpty()) {
            return;
        }
        ClientRegistrationEvent clientRegistrationEvent = new ClientRegistrationEvent(event, conflatable);
        for (ClientRegistrationEventQueue registrationEventQueue : this.registeringProxyEventQueues) {
            registrationEventQueue.lockForPutting();
            try {
                if (conflatable instanceof HAEventWrapper) {
                    ((HAEventWrapper)conflatable).incrementPutInProgressCounter("client registration");
                }
                ClientProxyMembershipID clientProxyMembershipID = registrationEventQueue.getClientProxyMembershipID();
                if (this.registeringProxyEventQueues.contains(registrationEventQueue)) {
                    this.copyOffHeapToHeapForRegistrationQueue(event);
                    registrationEventQueue.add(clientRegistrationEvent);
                    originalFilterClientIDs.remove(clientProxyMembershipID);
                    continue;
                }
                CacheClientProxy cacheClientProxy = cacheClientNotifier.getClientProxy(clientProxyMembershipID);
                this.processEventAndDeliverConflatable(cacheClientProxy, cacheClientNotifier, event, conflatable, originalFilterClientIDs);
            }
            finally {
                registrationEventQueue.unlockForPutting();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drain(ClientRegistrationEventQueue clientRegistrationEventQueue, CacheClientNotifier cacheClientNotifier) {
        try {
            ClientProxyMembershipID clientProxyMembershipID = clientRegistrationEventQueue.getClientProxyMembershipID();
            if (logger.isDebugEnabled()) {
                logger.debug("Draining events from registration queue for client proxy " + clientProxyMembershipID + " without synchronization");
            }
            CacheClientProxy cacheClientProxy = cacheClientNotifier.getClientProxy(clientProxyMembershipID);
            this.drainEventsReceivedWhileRegisteringClient(cacheClientProxy, clientRegistrationEventQueue, cacheClientNotifier);
            clientRegistrationEventQueue.lockForDraining();
            if (logger.isDebugEnabled()) {
                logger.debug("Draining remaining events from registration queue for client proxy " + clientProxyMembershipID + " with synchronization");
            }
            this.drainEventsReceivedWhileRegisteringClient(cacheClientProxy, clientRegistrationEventQueue, cacheClientNotifier);
        }
        finally {
            this.registeringProxyEventQueues.remove(clientRegistrationEventQueue);
            if (clientRegistrationEventQueue.isLockForDrainingHeld()) {
                clientRegistrationEventQueue.unlockForDraining();
            }
        }
    }

    ClientRegistrationEventQueue create(ClientProxyMembershipID clientProxyMembershipID, Queue<ClientRegistrationEvent> eventQueue, ReentrantReadWriteLock eventAddDrainLock) {
        ClientRegistrationEventQueue clientRegistrationEventQueue = new ClientRegistrationEventQueue(clientProxyMembershipID, eventQueue, eventAddDrainLock);
        this.registeringProxyEventQueues.add(clientRegistrationEventQueue);
        return clientRegistrationEventQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEventAndDeliverConflatable(CacheClientProxy cacheClientProxy, CacheClientNotifier cacheClientNotifier, InternalCacheEvent internalCacheEvent, Conflatable conflatable, Set<ClientProxyMembershipID> originalFilterClientIDs) {
        try {
            FilterRoutingInfo.FilterInfo filterInfo;
            FilterRoutingInfo filterRoutingInfo;
            FilterProfile filterProfile;
            if (cacheClientProxy != null && (filterProfile = ((LocalRegion)internalCacheEvent.getRegion()).getFilterProfile()) != null && (filterRoutingInfo = filterProfile.getFilterRoutingInfoPart2(null, internalCacheEvent)) != null && (filterInfo = filterRoutingInfo.getLocalFilterInfo()) != null) {
                ClientUpdateMessageImpl clientUpdateMessage = conflatable instanceof HAEventWrapper ? (ClientUpdateMessageImpl)((HAEventWrapper)conflatable).getClientUpdateMessage() : (ClientUpdateMessageImpl)conflatable;
                internalCacheEvent.setLocalFilterInfo(filterInfo);
                Set<ClientProxyMembershipID> newFilterClientIDs = cacheClientNotifier.getFilterClientIDs(internalCacheEvent, filterProfile, filterInfo, clientUpdateMessage);
                ClientProxyMembershipID proxyID = cacheClientProxy.getProxyID();
                if (this.eventNotInOriginalFilterClientIDs(proxyID, newFilterClientIDs, originalFilterClientIDs) && newFilterClientIDs.contains(proxyID)) {
                    cacheClientProxy.deliverMessage(conflatable);
                }
            }
        }
        finally {
            if (conflatable instanceof HAEventWrapper) {
                ((HAEventWrapper)conflatable).decrementPutInProgressCounter();
            }
        }
    }

    private boolean eventNotInOriginalFilterClientIDs(ClientProxyMembershipID proxyID, Set<ClientProxyMembershipID> newFilterClientIDs, Set<ClientProxyMembershipID> originalFilterClientIDs) {
        return originalFilterClientIDs == null || !originalFilterClientIDs.contains(proxyID) && newFilterClientIDs.contains(proxyID);
    }

    private void copyOffHeapToHeapForRegistrationQueue(InternalCacheEvent event) {
        if (event.getOperation().isEntry()) {
            EntryEventImpl entryEvent = (EntryEventImpl)event;
            entryEvent.copyOffHeapToHeap();
        }
    }

    private void drainEventsReceivedWhileRegisteringClient(CacheClientProxy cacheClientProxy, ClientRegistrationEventQueue registrationEventQueue, CacheClientNotifier cacheClientNotifier) {
        ClientRegistrationEvent queuedEvent;
        while ((queuedEvent = registrationEventQueue.poll()) != null) {
            InternalCacheEvent internalCacheEvent = queuedEvent.internalCacheEvent;
            Conflatable conflatable = queuedEvent.conflatable;
            this.processEventAndDeliverConflatable(cacheClientProxy, cacheClientNotifier, internalCacheEvent, conflatable, null);
        }
    }

    class ClientRegistrationEventQueue {
        private final ClientProxyMembershipID clientProxyMembershipID;
        private final Queue<ClientRegistrationEvent> eventQueue;
        private final ReentrantReadWriteLock eventAddDrainLock;

        ClientRegistrationEventQueue(ClientProxyMembershipID clientProxyMembershipID, Queue<ClientRegistrationEvent> eventQueue, ReentrantReadWriteLock eventAddDrainLock) {
            this.clientProxyMembershipID = clientProxyMembershipID;
            this.eventQueue = eventQueue;
            this.eventAddDrainLock = eventAddDrainLock;
        }

        public ClientProxyMembershipID getClientProxyMembershipID() {
            return this.clientProxyMembershipID;
        }

        boolean isEmpty() {
            return this.eventQueue.isEmpty();
        }

        private void add(ClientRegistrationEvent clientRegistrationEvent) {
            this.eventQueue.add(clientRegistrationEvent);
        }

        public ClientRegistrationEvent poll() {
            return this.eventQueue.poll();
        }

        private void lockForDraining() {
            this.eventAddDrainLock.writeLock().lock();
        }

        private void unlockForDraining() {
            this.eventAddDrainLock.writeLock().unlock();
        }

        private boolean isLockForDrainingHeld() {
            return this.eventAddDrainLock.writeLock().isHeldByCurrentThread();
        }

        private void lockForPutting() {
            this.eventAddDrainLock.readLock().lock();
        }

        private void unlockForPutting() {
            this.eventAddDrainLock.readLock().unlock();
        }
    }

    private class ClientRegistrationEvent {
        private final Conflatable conflatable;
        private final InternalCacheEvent internalCacheEvent;

        ClientRegistrationEvent(InternalCacheEvent internalCacheEvent, Conflatable conflatable) {
            this.conflatable = conflatable;
            this.internalCacheEvent = internalCacheEvent;
        }
    }
}

