/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.EntrySnapshot;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.NonLocalRegionEntry;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.Request;

public class GetEntryCommand
extends Request {
    @Immutable
    private static final GetEntryCommand singleton = new GetEntryCommand();

    public static Command getCommand() {
        return singleton;
    }

    protected GetEntryCommand() {
    }

    @Override
    public void getValueAndIsObject(Region p_region, Object key, Object callbackArg, ServerConnection servConn, Object[] result) {
        EntrySnapshot data = null;
        LocalRegion region = (LocalRegion)p_region;
        Region.Entry entry = region.getEntry(key);
        if (logger.isDebugEnabled()) {
            logger.debug("GetEntryCommand: for key: {} returning entry: {}", key, (Object)entry);
        }
        if (entry != null) {
            EntrySnapshot snap = new EntrySnapshot();
            NonLocalRegionEntry re = new NonLocalRegionEntry(entry, region);
            snap.setRegionEntry(re);
            snap.setRegion(region);
            data = snap;
        }
        result[0] = data;
        result[1] = true;
    }
}

