/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.geode.internal.cache.xmlcache.DefaultEntityResolver2;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GeodeEntityResolver
extends DefaultEntityResolver2 {
    private static final Pattern SYSTEM_ID_ROOT = Pattern.compile("^https?://geode.apache.org/");
    private static final String CLASSPATH_ROOT = "/META-INF/schemas/geode.apache.org/";

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        if (null == systemId) {
            return null;
        }
        Matcher matcher = SYSTEM_ID_ROOT.matcher(systemId);
        if (matcher.find()) {
            return this.getClassPathInputSource(publicId, systemId, matcher.replaceFirst(CLASSPATH_ROOT));
        }
        return null;
    }
}

