/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util.concurrent;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class CopyOnWriteHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private volatile Map<K, V> map = Collections.emptyMap();

    public CopyOnWriteHashMap() {
    }

    public CopyOnWriteHashMap(Map map) {
        this.putAll(map);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public synchronized V put(K key, V value) {
        HashMap<K, V> tmp = new HashMap<K, V>(this.map);
        V result = tmp.put(key, value);
        this.map = Collections.unmodifiableMap(tmp);
        return result;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        HashMap<? extends K, ? extends V> tmp = new HashMap<K, V>(this.map);
        tmp.putAll(m);
        this.map = Collections.unmodifiableMap(tmp);
    }

    @Override
    public synchronized V remove(Object key) {
        HashMap<K, V> tmp = new HashMap<K, V>(this.map);
        V result = tmp.remove(key);
        this.map = Collections.unmodifiableMap(tmp);
        return result;
    }

    @Override
    public synchronized void clear() {
        this.map = Collections.emptyMap();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        CopyOnWriteHashMap<K, V> clone = new CopyOnWriteHashMap<K, V>();
        clone.map = this.map;
        return clone;
    }

    public Map<K, V> getSnapshot() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public synchronized V putIfAbsent(K key, V value) {
        V oldValue = this.map.get(key);
        if (oldValue == null) {
            this.put(key, value);
            return null;
        }
        return oldValue;
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        V oldValue = this.map.get(key);
        if (oldValue != null && oldValue.equals(value)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean replace(K key, V oldValue, V newValue) {
        V existingValue = this.map.get(key);
        if (existingValue != null && existingValue.equals(oldValue)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    @Override
    public synchronized V replace(K key, V value) {
        if (this.map.containsKey(key)) {
            return this.put(key, value);
        }
        return null;
    }
}

