/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.distributed.LocatorLauncher;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.persistence.PersistentMemberPattern;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.management.internal.configuration.domain.SharedConfigurationStatus;
import org.apache.geode.management.internal.configuration.messages.SharedConfigurationStatusRequest;
import org.apache.geode.management.internal.configuration.messages.SharedConfigurationStatusResponse;

public class ClusterConfigurationStatusRetriever {
    private static final int NUM_ATTEMPTS_FOR_SHARED_CONFIGURATION_STATUS = 3;

    public static String fromLocator(String locatorHostName, int locatorPort, Properties configProps) throws ClassNotFoundException, IOException {
        StringBuilder buffer = new StringBuilder();
        InetAddress networkAddress = InetAddress.getByName(locatorHostName);
        TcpClient client = new TcpClient((TcpSocketCreator)new SocketCreator(SSLConfigurationFactory.getSSLConfigForComponent(configProps, SecurableCommunicationChannel.LOCATOR)), InternalDataSerializer.getDSFIDSerializer().getObjectSerializer(), InternalDataSerializer.getDSFIDSerializer().getObjectDeserializer());
        SharedConfigurationStatusResponse statusResponse = (SharedConfigurationStatusResponse)client.requestToServer(networkAddress, locatorPort, (Object)new SharedConfigurationStatusRequest(), 10000, true);
        for (int i = 0; i < 3 && (statusResponse.getStatus().equals((Object)SharedConfigurationStatus.STARTED) || statusResponse.getStatus().equals((Object)SharedConfigurationStatus.NOT_STARTED)); ++i) {
            statusResponse = (SharedConfigurationStatusResponse)client.requestToServer(networkAddress, locatorPort, (Object)new SharedConfigurationStatusRequest(), 10000, true);
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        switch (statusResponse.getStatus()) {
            case RUNNING: {
                buffer.append("\nCluster configuration service is up and running.");
                break;
            }
            case STOPPED: {
                buffer.append("\nCluster configuration service failed to start , please check the log file for errors.");
                break;
            }
            case WAITING: {
                buffer.append("\nCluster configuration service is waiting for other locators with newer shared configuration data.");
                Set<PersistentMemberPattern> pmpSet = statusResponse.getOtherLocatorInformation();
                if (!pmpSet.isEmpty()) {
                    buffer.append("\nThis locator might have stale cluster configuration data.");
                    buffer.append("\nFollowing locators contain potentially newer cluster configuration data");
                    for (PersistentMemberPattern pmp : pmpSet) {
                        buffer.append("\nHost : ").append(pmp.getHost());
                        buffer.append("\nDirectory : ").append(pmp.getDirectory());
                    }
                    break;
                }
                buffer.append("\nPlease check the log file for errors");
                break;
            }
            case UNDETERMINED: {
                buffer.append("\nUnable to determine the status of shared configuration service, please check the log file");
                break;
            }
            case NOT_STARTED: {
                buffer.append("\nCluster configuration service has not been started yet");
                break;
            }
            case STARTED: {
                buffer.append("\nCluster configuration service has been started, but its not running yet");
            }
        }
        return buffer.toString();
    }

    public static String fromLocator(LocatorLauncher.LocatorState locatorState, Properties properties) throws ClassNotFoundException, IOException {
        return ClusterConfigurationStatusRetriever.fromLocator(locatorState.getHost(), Integer.parseInt(locatorState.getPort()), properties);
    }
}

