/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.util;

import java.util.ArrayList;
import java.util.LinkedList;

public class RegionPath {
    private final String regionPath;
    private String regionName;
    private String regionParentPath;

    public RegionPath(String pathName) {
        this.regionPath = pathName;
        String[] regions = pathName.split("/");
        LinkedList<String> regionsNames = new LinkedList<String>();
        for (String region : regions) {
            if (region.isEmpty()) continue;
            regionsNames.add(region);
        }
        this.regionName = (String)regionsNames.removeLast();
        StringBuilder parentPathBuilder = new StringBuilder();
        while (!regionsNames.isEmpty()) {
            parentPathBuilder.append("/").append((String)regionsNames.removeFirst());
        }
        this.regionParentPath = parentPathBuilder.length() != 0 ? parentPathBuilder.toString() : null;
    }

    public String getName() {
        return this.regionName;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    public String getParent() {
        return this.regionParentPath;
    }

    public boolean isRoot() {
        return this.regionParentPath == "/" || this.regionParentPath == null;
    }

    public String[] getRegionsOnParentPath() {
        if (this.getParent() == null) {
            return new String[0];
        }
        String[] regionsOnPath = this.getParent().split("/");
        int start = regionsOnPath[0] == null || regionsOnPath[0].isEmpty() ? 1 : 0;
        ArrayList<String> regions = new ArrayList<String>();
        for (int i = start; i < regionsOnPath.length; ++i) {
            regions.add(regionsOnPath[i]);
        }
        return regions.toArray(new String[0]);
    }

    public String getRootRegionName() {
        if (this.isRoot()) {
            return this.getName();
        }
        return this.getRegionsOnParentPath()[0];
    }

    public RegionPath getParentRegionPath() {
        if (this.regionParentPath == null) {
            return null;
        }
        return new RegionPath(this.getParent());
    }

    public boolean isRootRegion() {
        return this.regionParentPath == null;
    }

    public String toString() {
        return "RegionPath [regionPath=" + this.regionPath + "]";
    }

    public static void main(String[] args) {
        RegionPath rp = new RegionPath("/region1/region11/region111/region1112");
        System.out.println("name :: " + rp.getName());
        System.out.println("regionpath :: " + rp.getRegionPath());
        System.out.println("parent :: " + rp.getParent());
        System.out.println("parent region path :: " + rp.getParentRegionPath());
        System.out.println("---------------------------------------------------");
        rp = new RegionPath("/region1");
        System.out.println("name :: " + rp.getName());
        System.out.println("regionpath :: " + rp.getRegionPath());
        System.out.println("parent :: " + rp.getParent());
        System.out.println("parent region path :: " + rp.getParentRegionPath());
    }
}

