/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.james.mime4j.stream;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.geronimo.mail.james.mime4j.MimeException;
import org.apache.geronimo.mail.james.mime4j.stream.NameValuePair;
import org.apache.geronimo.mail.james.mime4j.stream.ParserCursor;
import org.apache.geronimo.mail.james.mime4j.stream.RawBody;
import org.apache.geronimo.mail.james.mime4j.stream.RawField;
import org.apache.geronimo.mail.james.mime4j.util.ByteSequence;
import org.apache.geronimo.mail.james.mime4j.util.CharsetUtil;
import org.apache.geronimo.mail.james.mime4j.util.ContentUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawFieldParser {
    static final BitSet COLON = RawFieldParser.INIT_BITSET(58);
    static final BitSet EQUAL_OR_SEMICOLON = RawFieldParser.INIT_BITSET(61, 59);
    static final BitSet SEMICOLON = RawFieldParser.INIT_BITSET(59);
    public static final RawFieldParser DEFAULT = new RawFieldParser();

    public static BitSet INIT_BITSET(int ... b) {
        BitSet bitset = new BitSet(b.length);
        for (int aB : b) {
            bitset.set(aB);
        }
        return bitset;
    }

    public RawField parseField(ByteSequence raw) throws MimeException {
        if (raw == null) {
            return null;
        }
        ParserCursor cursor = new ParserCursor(0, raw.length());
        String name = this.parseToken(raw, cursor, COLON);
        if (cursor.atEnd()) {
            throw new MimeException("Invalid MIME field: no name/value separator found: " + raw.toString());
        }
        return new RawField(raw, cursor.getPos(), name, null);
    }

    public RawBody parseRawBody(RawField field) {
        ByteSequence buf = field.getRaw();
        int pos = field.getDelimiterIdx() + 1;
        if (buf == null) {
            String body = field.getBody();
            if (body == null) {
                return new RawBody("", null);
            }
            buf = ContentUtil.encode(body);
            pos = 0;
        }
        ParserCursor cursor = new ParserCursor(pos, buf.length());
        return this.parseRawBody(buf, cursor);
    }

    public RawBody parseRawBody(ByteSequence buf, ParserCursor cursor) {
        String value = this.parseToken(buf, cursor, SEMICOLON);
        if (cursor.atEnd()) {
            return new RawBody(value, new ArrayList<NameValuePair>());
        }
        cursor.updatePos(cursor.getPos() + 1);
        List<NameValuePair> params = this.parseParameters(buf, cursor);
        return new RawBody(value, params);
    }

    public List<NameValuePair> parseParameters(ByteSequence buf, ParserCursor cursor) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        this.skipWhiteSpace(buf, cursor);
        while (!cursor.atEnd()) {
            NameValuePair param = this.parseParameter(buf, cursor);
            params.add(param);
        }
        return params;
    }

    public NameValuePair parseParameter(ByteSequence buf, ParserCursor cursor) {
        String name = this.parseToken(buf, cursor, EQUAL_OR_SEMICOLON);
        if (cursor.atEnd()) {
            return new NameValuePair(name, null);
        }
        byte delim = buf.byteAt(cursor.getPos());
        cursor.updatePos(cursor.getPos() + 1);
        if (delim == 59) {
            return new NameValuePair(name, null);
        }
        String value = this.parseValue(buf, cursor, SEMICOLON);
        if (!cursor.atEnd()) {
            cursor.updatePos(cursor.getPos() + 1);
        }
        return new NameValuePair(name, value);
    }

    public String parseToken(ByteSequence buf, ParserCursor cursor, BitSet delimiters) {
        StringBuilder dst = new StringBuilder();
        boolean whitespace = false;
        while (!cursor.atEnd()) {
            char current = (char)(buf.byteAt(cursor.getPos()) & 0xFF);
            if (delimiters != null && delimiters.get(current)) break;
            if (CharsetUtil.isWhitespace(current)) {
                this.skipWhiteSpace(buf, cursor);
                whitespace = true;
                continue;
            }
            if (current == '(') {
                this.skipComment(buf, cursor);
                continue;
            }
            if (dst.length() > 0 && whitespace) {
                dst.append(' ');
            }
            this.copyContent(buf, cursor, delimiters, dst);
            whitespace = false;
        }
        return dst.toString();
    }

    public String parseValue(ByteSequence buf, ParserCursor cursor, BitSet delimiters) {
        StringBuilder dst = new StringBuilder();
        boolean whitespace = false;
        while (!cursor.atEnd()) {
            char current = (char)(buf.byteAt(cursor.getPos()) & 0xFF);
            if (delimiters != null && delimiters.get(current)) break;
            if (CharsetUtil.isWhitespace(current)) {
                this.skipWhiteSpace(buf, cursor);
                whitespace = true;
                continue;
            }
            if (current == '(') {
                this.skipComment(buf, cursor);
                continue;
            }
            if (current == '\"') {
                if (dst.length() > 0 && whitespace) {
                    dst.append(' ');
                }
                this.copyQuotedContent(buf, cursor, dst);
                whitespace = false;
                continue;
            }
            if (dst.length() > 0 && whitespace) {
                dst.append(' ');
            }
            this.copyUnquotedContent(buf, cursor, delimiters, dst);
            whitespace = false;
        }
        return dst.toString();
    }

    public void skipWhiteSpace(ByteSequence buf, ParserCursor cursor) {
        char current;
        int pos = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        for (int i = indexFrom; i < indexTo && CharsetUtil.isWhitespace(current = (char)(buf.byteAt(i) & 0xFF)); ++i) {
            ++pos;
        }
        cursor.updatePos(pos);
    }

    public void skipComment(ByteSequence buf, ParserCursor cursor) {
        if (cursor.atEnd()) {
            return;
        }
        int pos = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        char current = (char)(buf.byteAt(pos) & 0xFF);
        if (current != '(') {
            return;
        }
        ++pos;
        int level = 1;
        boolean escaped = false;
        int i = ++indexFrom;
        while (i < indexTo) {
            current = (char)(buf.byteAt(i) & 0xFF);
            if (escaped) {
                escaped = false;
            } else if (current == '\\') {
                escaped = true;
            } else if (current == '(') {
                ++level;
            } else if (current == ')') {
                --level;
            }
            if (level <= 0) {
                ++pos;
                break;
            }
            ++i;
            ++pos;
        }
        cursor.updatePos(pos);
    }

    public void skipAllWhiteSpace(ByteSequence buf, ParserCursor cursor) {
        while (!cursor.atEnd()) {
            char current = (char)(buf.byteAt(cursor.getPos()) & 0xFF);
            if (CharsetUtil.isWhitespace(current)) {
                this.skipWhiteSpace(buf, cursor);
                continue;
            }
            if (current != '(') break;
            this.skipComment(buf, cursor);
        }
    }

    public void copyContent(ByteSequence buf, ParserCursor cursor, BitSet delimiters, StringBuilder dst) {
        int pos = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        for (int i = indexFrom; i < indexTo; ++i) {
            char current = (char)(buf.byteAt(i) & 0xFF);
            if (delimiters != null && delimiters.get(current) || CharsetUtil.isWhitespace(current) || current == '(') break;
            ++pos;
            dst.append(current);
        }
        cursor.updatePos(pos);
    }

    public void copyUnquotedContent(ByteSequence buf, ParserCursor cursor, BitSet delimiters, StringBuilder dst) {
        int pos = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        for (int i = indexFrom; i < indexTo; ++i) {
            char current = (char)(buf.byteAt(i) & 0xFF);
            if (delimiters != null && delimiters.get(current) || CharsetUtil.isWhitespace(current) || current == '(' || current == '\"') break;
            ++pos;
            dst.append(current);
        }
        cursor.updatePos(pos);
    }

    public void copyQuotedContent(ByteSequence buf, ParserCursor cursor, StringBuilder dst) {
        if (cursor.atEnd()) {
            return;
        }
        int pos = cursor.getPos();
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        char current = (char)(buf.byteAt(pos) & 0xFF);
        if (current != '\"') {
            return;
        }
        ++pos;
        boolean escaped = false;
        int i = ++indexFrom;
        while (i < indexTo) {
            current = (char)(buf.byteAt(i) & 0xFF);
            if (escaped) {
                if (current != '\"' && current != '\\') {
                    dst.append('\\');
                }
                dst.append(current);
                escaped = false;
            } else {
                if (current == '\"') {
                    ++pos;
                    break;
                }
                if (current == '\\') {
                    escaped = true;
                } else if (current != '\r' && current != '\n') {
                    dst.append(current);
                }
            }
            ++i;
            ++pos;
        }
        cursor.updatePos(pos);
    }
}

