/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.cli.command;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.util.functional.ThrowingSupplier;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.grails.forge.application.Project;
import org.grails.forge.cli.CodeGenConfig;
import org.grails.forge.cli.command.BaseCommand;
import org.grails.forge.io.ConsoleOutput;
import org.grails.forge.io.FileSystemOutputHandler;
import org.grails.forge.io.OutputHandler;
import org.grails.forge.template.TemplateRenderer;
import org.grails.forge.util.NameUtils;
import picocli.CommandLine;

public abstract class CodeGenCommand
extends BaseCommand
implements Callable<Integer> {
    protected final CodeGenConfig config;
    @ReflectiveAccess
    @CommandLine.Option(names={"-f", "--force"}, description={"Whether to overwrite existing files"})
    protected boolean overwrite;
    private final ThrowingSupplier<OutputHandler, IOException> outputHandlerSupplier;
    private final ConsoleOutput consoleOutput;
    private BeanContext beanContext;

    public CodeGenCommand(CodeGenConfig config) {
        this.config = config;
        this.outputHandlerSupplier = () -> new FileSystemOutputHandler(FileSystemOutputHandler.getDefaultBaseDirectory(), this);
        this.consoleOutput = null;
    }

    public CodeGenCommand(CodeGenConfig config, ThrowingSupplier<OutputHandler, IOException> outputHandlerSupplier, ConsoleOutput consoleOutput) {
        this.config = config;
        this.outputHandlerSupplier = outputHandlerSupplier;
        this.consoleOutput = consoleOutput;
    }

    @Inject
    public void setBeanContext(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    public abstract boolean applies();

    protected Project getProject(String name) {
        if (name.indexOf(45) > -1) {
            name = NameUtils.getNameFromScript(name);
        }
        if (this.config != null && this.config.getDefaultPackage() != null && name.indexOf(46) == -1) {
            return NameUtils.parse(this.config.getDefaultPackage() + "." + name);
        }
        return NameUtils.parse(name);
    }

    protected TemplateRenderer getTemplateRenderer(Project project) throws IOException {
        return TemplateRenderer.create(project, this.outputHandlerSupplier.get());
    }

    protected TemplateRenderer getTemplateRenderer() throws IOException {
        return TemplateRenderer.create(this.outputHandlerSupplier.get());
    }

    protected <T extends CodeGenCommand> T getCommand(Class<T> clazz) {
        CodeGenCommand bean2 = (CodeGenCommand)this.beanContext.createBean(clazz, this.config);
        bean2.overwrite = this.overwrite;
        bean2.spec = this.spec;
        bean2.commonOptions = this.commonOptions;
        return (T)bean2;
    }

    @Override
    public void out(String message) {
        if (this.consoleOutput == null) {
            super.out(message);
        } else {
            this.consoleOutput.out(message);
        }
    }

    @Override
    public void err(String message) {
        if (this.consoleOutput == null) {
            super.err(message);
        } else {
            this.consoleOutput.err(message);
        }
    }

    @Override
    public void warning(String message) {
        if (this.consoleOutput == null) {
            super.warning(message);
        } else {
            this.consoleOutput.warning(message);
        }
    }
}

