/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.grails.forge.io.OutputHandler;
import org.grails.forge.template.Template;

public class MapOutputHandler
implements OutputHandler {
    private final Map<String, String> templates = new LinkedHashMap<String, String>(16);

    @Override
    public boolean exists(String path) {
        return this.templates.containsKey(path);
    }

    @Override
    public void write(String path, Template contents) throws IOException {
        if (contents.isBinary()) {
            this.templates.put(path, null);
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            contents.write(out);
            this.templates.put(path, out.toString(StandardCharsets.UTF_8.name()));
        }
    }

    @Override
    public String getOutputLocation() {
        return null;
    }

    @Override
    public void close() throws IOException {
    }

    public Map<String, String> getProject() {
        return this.templates;
    }
}

