/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.pages;

import grails.config.Config;
import grails.core.GrailsApplication;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.grails.encoder.CodecLookupHelper;
import org.grails.encoder.Encoder;

public class FilteringCodecsByContentTypeSettings {
    private static final String WILDCARD_CONTENT_TYPE = "*/*";
    public static final String CONFIG_PROPERTY_CODEC_FOR_CONTENT_TYPE = "grails.views.filteringCodecForContentType";
    public static final String BEAN_NAME = "filteringCodecsByContentTypeSettings";
    Map<String, Encoder> contentTypeToEncoderMapping;
    Map<Pattern, Encoder> contentTypePatternToEncoderMapping;

    public FilteringCodecsByContentTypeSettings(GrailsApplication grailsApplication) {
        this.initialize(grailsApplication);
    }

    public void initialize(GrailsApplication grailsApplication) {
        this.contentTypeToEncoderMapping = null;
        this.contentTypePatternToEncoderMapping = null;
        Map codecForContentTypeConfig = this.getConfigSettings(grailsApplication.getConfig());
        if (codecForContentTypeConfig != null) {
            this.contentTypeToEncoderMapping = new LinkedHashMap<String, Encoder>();
            this.contentTypePatternToEncoderMapping = new LinkedHashMap<Pattern, Encoder>();
            Map codecForContentTypeMapping = codecForContentTypeConfig;
            for (Map.Entry entry : codecForContentTypeMapping.entrySet()) {
                Encoder encoder = CodecLookupHelper.lookupEncoder(grailsApplication, String.valueOf(entry.getValue()));
                if (entry.getKey() instanceof Pattern) {
                    this.contentTypePatternToEncoderMapping.put((Pattern)entry.getKey(), encoder);
                    continue;
                }
                this.contentTypeToEncoderMapping.put(String.valueOf(entry.getKey()), encoder);
            }
        }
    }

    public Encoder getEncoderForContentType(String contentType) {
        Encoder encoder;
        if (this.contentTypeToEncoderMapping == null) {
            return null;
        }
        if (contentType == null) {
            contentType = WILDCARD_CONTENT_TYPE;
        }
        if ((encoder = this.contentTypeToEncoderMapping.get(contentType)) != null) {
            return encoder;
        }
        for (Map.Entry<Pattern, Encoder> entry : this.contentTypePatternToEncoderMapping.entrySet()) {
            if (!entry.getKey().matcher(contentType).matches()) continue;
            return encoder;
        }
        return this.contentTypeToEncoderMapping.get(WILDCARD_CONTENT_TYPE);
    }

    protected Map getConfigSettings(Config config) {
        return config.getProperty(CONFIG_PROPERTY_CODEC_FOR_CONTENT_TYPE, Map.class);
    }
}

