/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cache.query.index.IndexQueryResultMeta;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.metric.IoStatisticsHolder;
import org.apache.ignite.internal.metric.IoStatisticsQueryHelper;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.query.CacheQuery;
import org.apache.ignite.internal.processors.cache.query.CacheQueryEntry;
import org.apache.ignite.internal.processors.cache.query.CacheQueryFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheDistributedFieldsQueryFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheDistributedQueryFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheLocalFieldsQueryFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheLocalQueryFuture;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryBean;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryFutureAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryInfo;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryRequest;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryResponse;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.util.GridBoundedConcurrentOrderedSet;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridPlainCallable;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.CI2;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteReducer;
import org.jetbrains.annotations.Nullable;

public class GridCacheDistributedQueryManager<K, V>
extends GridCacheQueryManager<K, V> {
    private static final int MAX_CANCEL_IDS = 1000;
    private static final long RESEND_FREQ = 3000L;
    private static final int RESEND_ATTEMPTS = 5;
    private static final String TOPIC_PREFIX = "QUERY";
    private ConcurrentMap<Long, Thread> threads = new ConcurrentHashMap<Long, Thread>();
    private final ConcurrentMap<Long, GridCacheDistributedQueryFuture<?, ?, ?>> futs = new ConcurrentHashMap();
    private Collection<CancelMessageId> cancelIds = new GridBoundedConcurrentOrderedSet<CancelMessageId>(1000);
    private Collection<Long> cancelled = new GridBoundedConcurrentOrderedSet<Long>(1000);
    private IgniteBiInClosure<UUID, GridCacheQueryResponse> resHnd = new CI2<UUID, GridCacheQueryResponse>(){

        @Override
        public void apply(UUID nodeId, GridCacheQueryResponse res) {
            GridCacheDistributedQueryManager.this.processQueryResponse(nodeId, res);
        }
    };
    private GridLocalEventListener lsnr = new GridLocalEventListener(){

        @Override
        public void onEvent(Event evt) {
            DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
            for (GridCacheDistributedQueryFuture fut : GridCacheDistributedQueryManager.this.futs.values()) {
                fut.onNodeLeft(discoEvt.eventNode().id());
            }
        }
    };

    @Override
    public void onKernalStart0() throws IgniteCheckedException {
        super.onKernalStart0();
        assert (!this.cctx.isRecoveryMode()) : "Registering message handlers in recovery mode [cacheName=" + this.cctx.name() + "]";
        this.cctx.io().addCacheHandler(this.cctx.cacheId(), this.cctx.startTopologyVersion(), GridCacheQueryRequest.class, this::processQueryRequest);
        this.cctx.events().addListener(this.lsnr, 11, 12);
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        super.onKernalStop0(cancel);
        this.cctx.events().removeListener(this.lsnr);
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        IgniteClientDisconnectedCheckedException err = new IgniteClientDisconnectedCheckedException(reconnectFut, "Query was cancelled, client node disconnected.");
        for (Map.Entry e : this.futs.entrySet()) {
            GridCacheDistributedQueryFuture fut = (GridCacheDistributedQueryFuture)e.getValue();
            fut.onPage(null, null, null, err, true);
            this.futs.remove(e.getKey(), fut);
        }
    }

    @Override
    public void printMemoryStats() {
        super.printMemoryStats();
        X.println(">>>   threadsSize: " + this.threads.size(), new Object[0]);
        X.println(">>>   futsSize: " + this.futs.size(), new Object[0]);
    }

    protected void removeQueryFuture(long reqId) {
        this.futs.remove(reqId);
    }

    protected GridCacheDistributedQueryFuture<?, ?, ?> getQueryFuture(long reqId) {
        return (GridCacheDistributedQueryFuture)this.futs.get(reqId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processQueryRequest(UUID sndId, GridCacheQueryRequest req) {
        if (req.cancel()) {
            this.cancelIds.add(new CancelMessageId(req.id(), sndId));
            if (req.fields()) {
                this.removeFieldsQueryResult(sndId, req.id());
            } else {
                this.removeQueryResult(sndId, req.id());
            }
        } else if (!this.cancelIds.contains(new CancelMessageId(req.id(), sndId))) {
            if (!F.eq(req.cacheName(), this.cctx.name())) {
                GridCacheQueryResponse res = new GridCacheQueryResponse(this.cctx.cacheId(), req.id(), new IgniteCheckedException("Received request for incorrect cache [expected=" + this.cctx.name() + ", actual=" + req.cacheName()), this.cctx.deploymentEnabled());
                this.sendQueryResponse(sndId, res, 0L);
            } else {
                this.threads.put(req.id(), Thread.currentThread());
                try {
                    GridCacheQueryInfo info = this.distributedQueryInfo(sndId, req);
                    if (info == null) {
                        return;
                    }
                    if (req.fields()) {
                        this.runFieldsQuery(info);
                    } else {
                        this.runQuery(info);
                    }
                }
                catch (Throwable e) {
                    U.error(this.log(), "Failed to run query.", e);
                    this.sendQueryResponse(sndId, new GridCacheQueryResponse(this.cctx.cacheId(), req.id(), e.getCause(), this.cctx.deploymentEnabled()), 0L);
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                }
                finally {
                    this.threads.remove(req.id());
                }
            }
        }
    }

    @Nullable
    private GridCacheQueryInfo distributedQueryInfo(UUID sndId, GridCacheQueryRequest req) {
        IgniteReducer<Object, Object> rdc = req.reducer();
        IgniteClosure<?, ?> trans = req.transformer();
        ClusterNode sndNode = this.cctx.node(sndId);
        if (sndNode == null) {
            return null;
        }
        CacheQuery qry = new CacheQuery(this.cctx, req.type(), this.log, req.pageSize(), 0L, req.includeBackups(), false, null, req.keyValueFilter(), req.partition() == -1 ? null : Integer.valueOf(req.partition()), req.className(), req.clause(), req.idxQryDesc(), req.limit(), req.includeMetaData(), req.keepBinary(), req.taskHash(), req.isDataPageScanEnabled(), req.skipKeys());
        return new GridCacheQueryInfo(false, trans, rdc, qry, null, sndId, req.id(), req.includeMetaData(), req.allPages(), req.arguments());
    }

    private boolean sendQueryResponse(UUID nodeId, GridCacheQueryResponse res, long timeout) {
        ClusterNode node = this.cctx.node(nodeId);
        if (node == null) {
            return false;
        }
        int attempt = 1;
        IgniteCheckedException err = null;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Send query response: " + res);
                }
                Object topic = this.topic(nodeId, res.requestId());
                this.cctx.io().sendOrderedMessage(node, topic, res, (byte)10, timeout > 0L ? timeout : Long.MAX_VALUE);
                return true;
            }
            catch (ClusterTopologyCheckedException ignored) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to send query response since node left grid [nodeId=" + nodeId + ", res=" + res + "]");
                }
                return false;
            }
            catch (IgniteCheckedException e) {
                if (err == null) {
                    err = e;
                }
                if (Thread.currentThread().isInterrupted()) break;
                if (attempt < 5) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Failed to send queries response (will try again) [nodeId=" + nodeId + ", res=" + res + ", attempt=" + attempt + ", err=" + e + "]");
                    }
                    if (!Thread.currentThread().isInterrupted()) {
                        try {
                            U.sleep(3000L);
                        }
                        catch (IgniteInterruptedCheckedException e1) {
                            U.error(this.log, "Waiting for queries response resending was interrupted (response will not be sent) [nodeId=" + nodeId + ", response=" + res + "]", e1);
                            return false;
                        }
                    }
                } else {
                    U.error(this.log, "Failed to sender cache response [nodeId=" + nodeId + ", response=" + res + "]", err);
                    return false;
                }
                ++attempt;
            }
        }
        return false;
    }

    private void processQueryResponse(UUID sndId, GridCacheQueryResponse res) {
        GridCacheDistributedQueryFuture<Object, Object, Object> fut;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received query response: " + res);
        }
        if ((fut = this.getQueryFuture(res.requestId())) != null) {
            if (res.fields()) {
                ((GridCacheDistributedFieldsQueryFuture)fut).onFieldsPage(sndId, res.metadata(), res.data(), res.error(), res.isFinished());
            } else {
                fut.onPage(sndId, res.idxQryMetadata(), res.data(), res.error(), res.isFinished());
            }
        } else if (!this.cancelled.contains(res.requestId())) {
            U.warn(this.log, "Received response for finished or unknown query [rmtNodeId=" + sndId + ", res=" + res + "]");
        }
    }

    @Override
    void onQueryFutureCanceled(long reqId) {
        this.cancelled.add(reqId);
    }

    @Override
    void onCancelAtStop() {
        super.onCancelAtStop();
        for (GridCacheQueryFutureAdapter fut : this.futs.values()) {
            try {
                fut.cancel();
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to cancel running query future: " + fut, e);
            }
        }
        U.interrupt(this.threads.values());
    }

    @Override
    protected boolean onPageReady(boolean loc, GridCacheQueryInfo qryInfo, IndexQueryResultMeta idxQryMetadata, Collection<?> data, boolean finished, Throwable e) {
        GridCacheLocalQueryFuture<?, ?, ?> fut = qryInfo.localQueryFuture();
        if (loc) assert (fut != null);
        if (e != null) {
            if (loc) {
                fut.onPage(null, null, null, e, true);
            } else {
                this.sendQueryResponse(qryInfo.senderId(), new GridCacheQueryResponse(this.cctx.cacheId(), qryInfo.requestId(), e, this.cctx.deploymentEnabled()), qryInfo.query().timeout());
            }
            return true;
        }
        if (loc) {
            fut.onPage(null, null, data, null, finished);
        } else {
            GridCacheQueryResponse res = new GridCacheQueryResponse(this.cctx.cacheId(), qryInfo.requestId(), finished, false, this.cctx.deploymentEnabled());
            if (qryInfo.query().type() == GridCacheQueryType.INDEX) {
                res.idxQryMetadata(idxQryMetadata);
            }
            res.data(data);
            if (!this.sendQueryResponse(qryInfo.senderId(), res, qryInfo.query().timeout())) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean onFieldsPageReady(boolean loc, GridCacheQueryInfo qryInfo, @Nullable List<GridQueryFieldMetadata> metadata, @Nullable Collection<?> entities, @Nullable Collection<?> data, boolean finished, @Nullable Throwable e) {
        assert (qryInfo != null);
        if (e != null) {
            if (loc) {
                GridCacheLocalFieldsQueryFuture fut = (GridCacheLocalFieldsQueryFuture)qryInfo.localQueryFuture();
                fut.onPage(null, null, null, e, true);
            } else {
                this.sendQueryResponse(qryInfo.senderId(), new GridCacheQueryResponse(this.cctx.cacheId(), qryInfo.requestId(), e, this.cctx.deploymentEnabled()), qryInfo.query().timeout());
            }
            return true;
        }
        if (loc) {
            GridCacheLocalFieldsQueryFuture fut = (GridCacheLocalFieldsQueryFuture)qryInfo.localQueryFuture();
            fut.onFieldsPage(null, metadata, data, null, finished);
        } else {
            GridCacheQueryResponse res = new GridCacheQueryResponse(this.cctx.cacheId(), qryInfo.requestId(), finished, qryInfo.reducer() == null, this.cctx.deploymentEnabled());
            res.metadata(metadata);
            res.data(entities != null ? entities : data);
            if (!this.sendQueryResponse(qryInfo.senderId(), res, qryInfo.query().timeout())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public CacheQueryFuture<?> queryDistributed(GridCacheQueryBean qry, Collection<ClusterNode> nodes) {
        return this.queryDistributed(qry, nodes, false);
    }

    private CacheQueryFuture<?> queryDistributed(GridCacheQueryBean qry, Collection<ClusterNode> nodes, boolean fields) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Executing distributed query: " + qry);
        }
        long reqId = this.cctx.io().nextIoId();
        GridCacheDistributedQueryFuture fut = fields ? new GridCacheDistributedFieldsQueryFuture((GridCacheContext<?, ?>)this.cctx, reqId, qry, nodes) : new GridCacheDistributedQueryFuture(this.cctx, reqId, qry, nodes);
        try {
            fut.qry.query().validate();
            final Object topic = this.topic(this.cctx.nodeId(), reqId);
            this.cctx.io().addOrderedCacheHandler(this.cctx.shared(), topic, this.resHnd);
            fut.listen(new CI1<IgniteInternalFuture<?>>(){

                @Override
                public void apply(IgniteInternalFuture<?> fut) {
                    GridCacheDistributedQueryManager.this.cctx.io().removeOrderedHandler(false, topic);
                }
            });
            this.futs.put(reqId, fut);
            if (this.cctx.kernalContext().clientDisconnected()) {
                IgniteClientDisconnectedCheckedException err = new IgniteClientDisconnectedCheckedException(this.cctx.kernalContext().cluster().clientReconnectFuture(), "Query was cancelled, client node disconnected.");
                fut.onError(err);
            }
            fut.startQuery();
        }
        catch (IgniteCheckedException e) {
            fut.onError(e);
        }
        return fut;
    }

    @Override
    public GridCloseableIterator scanQueryDistributed(final CacheQuery qry, Collection<ClusterNode> nodes) throws IgniteCheckedException {
        assert (qry.type() == GridCacheQueryType.SCAN) : qry;
        final boolean performanceStatsEnabled = this.cctx.kernalContext().performanceStatistics().enabled();
        GridCloseableIterator locIter0 = null;
        for (ClusterNode node : nodes) {
            if (!node.isLocal()) continue;
            locIter0 = this.scanQueryLocal(qry, false);
            ArrayList<ClusterNode> rmtNodes = new ArrayList<ClusterNode>(nodes.size() - 1);
            for (ClusterNode n : nodes) {
                if (n == node) continue;
                rmtNodes.add(n);
            }
            nodes = rmtNodes;
            break;
        }
        final GridCloseableIterator locIter = locIter0;
        GridCacheQueryBean bean = new GridCacheQueryBean(qry, null, qry.transform(), null);
        final CacheQueryFuture<?> fut = this.queryDistributed(bean, nodes);
        return new GridCloseableIteratorAdapter(){
            private Object cur;
            private long logicalReads;
            private long physicalReads;

            protected Object onNext() throws IgniteCheckedException {
                if (!this.onHasNext()) {
                    throw new NoSuchElementException();
                }
                Object e = this.cur;
                this.cur = null;
                return e;
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                if (this.cur != null) {
                    return true;
                }
                if (locIter != null) {
                    if (performanceStatsEnabled) {
                        IoStatisticsQueryHelper.startGatheringQueryStatistics();
                    }
                    try {
                        if (locIter.hasNextX()) {
                            this.cur = locIter.nextX();
                        }
                    }
                    finally {
                        if (performanceStatsEnabled) {
                            IoStatisticsHolder stat = IoStatisticsQueryHelper.finishGatheringQueryStatistics();
                            this.logicalReads += stat.logicalReads();
                            this.physicalReads += stat.physicalReads();
                        }
                    }
                }
                return this.cur != null || (this.cur = this.convert(fut.next())) != null;
            }

            private Object convert(Object obj) {
                if (qry.transform() != null) {
                    return obj;
                }
                Map.Entry e = (Map.Entry)obj;
                return e == null ? null : new CacheQueryEntry(e.getKey(), e.getValue());
            }

            @Override
            protected void onClose() throws IgniteCheckedException {
                super.onClose();
                if (locIter != null) {
                    locIter.close();
                }
                if (fut != null) {
                    fut.cancel();
                }
                if (performanceStatsEnabled && (this.logicalReads > 0L || this.physicalReads > 0L)) {
                    GridCacheDistributedQueryManager.this.cctx.kernalContext().performanceStatistics().queryReads(GridCacheQueryType.SCAN, GridCacheDistributedQueryManager.this.cctx.localNodeId(), ((GridCacheDistributedQueryFuture)fut).requestId(), this.logicalReads, this.physicalReads);
                }
            }
        };
    }

    @Override
    public CacheQueryFuture<?> queryFieldsLocal(GridCacheQueryBean qry) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Executing query on local node: " + qry);
        }
        GridCacheLocalFieldsQueryFuture fut = new GridCacheLocalFieldsQueryFuture((GridCacheContext<?, ?>)this.cctx, qry);
        try {
            qry.query().validate();
            fut.execute();
        }
        catch (IgniteCheckedException e) {
            fut.onDone(e);
        }
        return fut;
    }

    @Override
    public CacheQueryFuture<?> queryFieldsDistributed(GridCacheQueryBean qry, Collection<ClusterNode> nodes) {
        return this.queryDistributed(qry, nodes, true);
    }

    public void sendRequest(GridCacheDistributedQueryFuture<?, ?, ?> fut, final GridCacheQueryRequest req, Collection<UUID> nodeIds) throws IgniteCheckedException {
        assert (fut != null);
        assert (req != null);
        assert (nodeIds != null);
        final UUID locNodeId = this.cctx.localNodeId();
        boolean locNode = false;
        ArrayList<UUID> rmtNodes = null;
        for (UUID nodeId : nodeIds) {
            if (nodeId.equals(locNodeId)) {
                locNode = true;
                continue;
            }
            if (rmtNodes == null) {
                rmtNodes = new ArrayList<UUID>(nodeIds.size());
            }
            rmtNodes.add(nodeId);
        }
        if (!F.isEmpty(rmtNodes)) {
            for (UUID node : rmtNodes) {
                try {
                    this.cctx.io().send(node, (GridCacheMessage)req, (byte)10);
                }
                catch (IgniteCheckedException e) {
                    if (this.cctx.io().checkNodeLeft(node, e, true)) {
                        fut.onNodeLeft(node);
                        if (!fut.isDone()) continue;
                        return;
                    }
                    throw e;
                }
            }
        }
        if (locNode) {
            this.cctx.closures().callLocalSafe(new GridPlainCallable<Object>(){

                @Override
                public Object call() throws Exception {
                    req.beforeLocalExecution(GridCacheDistributedQueryManager.this.cctx);
                    GridCacheDistributedQueryManager.this.processQueryRequest(locNodeId, req);
                    return null;
                }
            }, (byte)10);
        }
    }

    private Object topic(UUID nodeId, long reqId) {
        return GridTopic.TOPIC_CACHE.topic(TOPIC_PREFIX, nodeId, reqId);
    }

    private static class CancelMessageId
    implements Comparable<CancelMessageId> {
        private long reqId;
        private UUID nodeId;

        private CancelMessageId(long reqId, UUID nodeId) {
            this.reqId = reqId;
            this.nodeId = nodeId;
        }

        @Override
        public int compareTo(CancelMessageId m) {
            int res = Long.compare(this.reqId, m.reqId);
            if (res == 0) {
                res = m.nodeId.compareTo(this.nodeId);
            }
            return res;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            CancelMessageId other = (CancelMessageId)obj;
            return this.reqId == other.reqId && this.nodeId.equals(other.nodeId);
        }

        public int hashCode() {
            return 31 * (int)(this.reqId ^ this.reqId >>> 32) + this.nodeId.hashCode();
        }

        public String toString() {
            return S.toString(CancelMessageId.class, this);
        }
    }
}

