/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule;

import java.util.Collections;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteCorrelatedNestedLoopJoin;
import org.apache.ignite.internal.processors.query.calcite.rule.AbstractIgniteConverterRule;
import org.apache.ignite.internal.processors.query.calcite.trait.CorrelationTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.RewindabilityTrait;

public class CorrelateToNestedLoopRule
extends AbstractIgniteConverterRule<LogicalCorrelate> {
    public static final RelOptRule INSTANCE = new CorrelateToNestedLoopRule();

    public CorrelateToNestedLoopRule() {
        super(LogicalCorrelate.class, "CorrelateToNestedLoopRule");
    }

    @Override
    protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, LogicalCorrelate rel) {
        RelOptCluster cluster = rel.getCluster();
        Set<CorrelationId> correlationIds = Collections.singleton(rel.getCorrelationId());
        CorrelationTrait corrTrait = CorrelationTrait.correlations(correlationIds);
        RelTraitSet outTraits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
        RelTraitSet leftInTraits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE);
        RelTraitSet rightInTraits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)RewindabilityTrait.REWINDABLE).replace((RelTrait)corrTrait);
        RelNode left = CorrelateToNestedLoopRule.convert((RelNode)rel.getLeft(), (RelTraitSet)leftInTraits);
        RelNode right = CorrelateToNestedLoopRule.convert((RelNode)rel.getRight(), (RelTraitSet)rightInTraits);
        return new IgniteCorrelatedNestedLoopJoin(cluster, outTraits, left, right, (RexNode)cluster.getRexBuilder().makeLiteral(true), correlationIds, rel.getJoinType());
    }

    public boolean matches(RelOptRuleCall call) {
        Correlate corr = (Correlate)call.rel(0);
        return corr.getJoinType() == JoinRelType.INNER || corr.getJoinType() == JoinRelType.LEFT;
    }
}

