/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.replicator.Replica;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.exception.ReplicaIsAlreadyStartedException;
import org.apache.ignite.internal.replicator.exception.ReplicaUnavailableException;
import org.apache.ignite.internal.replicator.listener.ReplicaListener;
import org.apache.ignite.internal.replicator.message.ReplicaMessageGroup;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.replicator.message.ReplicaSafeTimeSyncRequest;
import org.apache.ignite.internal.replicator.message.TimestampAware;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.NodeStoppingException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.ClusterService;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.NetworkMessage;
import org.apache.ignite.network.NetworkMessageHandler;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ReplicaManager
implements IgniteComponent {
    private static final int IDLE_SAFE_TIME_PROPAGATION_PERIOD_SECONDS = 1;
    private static final IgniteLogger LOG = Loggers.forClass(ReplicaManager.class);
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final ClusterService clusterNetSvc;
    private final NetworkMessageHandler handler;
    private final ConcurrentHashMap<ReplicationGroupId, Replica> replicas = new ConcurrentHashMap();
    private final HybridClock clock;
    private final ScheduledExecutorService scheduledIdleSafeTimeSyncExecutor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("scheduled-idle-safe-time-sync-thread", LOG));
    Set<Class<?>> messageGroupsToHandle;

    public ReplicaManager(ClusterService clusterNetSvc, HybridClock clock, Set<Class<?>> messageGroupsToHandle) {
        this.clusterNetSvc = clusterNetSvc;
        this.clock = clock;
        this.messageGroupsToHandle = messageGroupsToHandle;
        this.handler = (message, senderAddr, correlationId) -> {
            if (!this.busyLock.enterBusy()) {
                throw new IgniteException((Throwable)new NodeStoppingException());
            }
            try {
                if (!(message instanceof ReplicaRequest)) {
                    return;
                }
                ReplicaRequest request = (ReplicaRequest)message;
                HybridTimestamp requestTimestamp = this.extractTimestamp(request);
                Replica replica = this.replicas.get(request.groupId());
                if (replica == null) {
                    this.sendReplicaUnavailableErrorResponse(senderAddr, correlationId, request, requestTimestamp);
                    return;
                }
                CompletableFuture<Object> result = replica.processRequest(request);
                result.handle((res, ex) -> {
                    NetworkMessage msg;
                    if (ex == null) {
                        msg = this.prepareReplicaResponse(requestTimestamp, res);
                    } else {
                        LOG.warn("Failed to process replica request [request={}]", ex, new Object[]{request});
                        msg = this.prepareReplicaErrorResponse(requestTimestamp, (Throwable)ex);
                    }
                    clusterNetSvc.messagingService().respond(senderAddr, msg, correlationId.longValue());
                    return null;
                });
            }
            finally {
                this.busyLock.leaveBusy();
            }
        };
    }

    public Replica replica(ReplicationGroupId replicaGrpId) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            Replica replica = this.replicas.get(replicaGrpId);
            return replica;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Replica startReplica(ReplicationGroupId replicaGrpId, ReplicaListener listener) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            Replica replica = this.startReplicaInternal(replicaGrpId, listener);
            return replica;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private Replica startReplicaInternal(ReplicationGroupId replicaGrpId, ReplicaListener listener) {
        Replica replica = new Replica(replicaGrpId, listener);
        Replica previous = this.replicas.putIfAbsent(replicaGrpId, replica);
        if (previous != null) {
            throw new ReplicaIsAlreadyStartedException(replicaGrpId);
        }
        return replica;
    }

    public boolean stopReplica(ReplicationGroupId replicaGrpId) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            boolean bl = this.stopReplicaInternal(replicaGrpId);
            return bl;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private boolean stopReplicaInternal(ReplicationGroupId replicaGrpId) {
        return this.replicas.remove(replicaGrpId) != null;
    }

    public void start() {
        this.clusterNetSvc.messagingService().addMessageHandler(ReplicaMessageGroup.class, this.handler);
        this.messageGroupsToHandle.forEach(mg -> this.clusterNetSvc.messagingService().addMessageHandler(mg, this.handler));
        this.scheduledIdleSafeTimeSyncExecutor.scheduleAtFixedRate(this::idleSafeTimeSync, 0L, 1L, TimeUnit.SECONDS);
    }

    public void stop() throws Exception {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.scheduledIdleSafeTimeSyncExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        assert (this.replicas.isEmpty()) : "There are replicas alive [replicas=" + (ConcurrentHashMap.KeySetView)this.replicas.keySet() + "]";
    }

    public boolean shouldHaveReplicationGroupLocally(Collection<ClusterNode> replicas) {
        String locNodeName = this.clusterNetSvc.topologyService().localMember().name();
        return replicas.stream().anyMatch(r -> locNodeName.equals(r.name()));
    }

    private HybridTimestamp extractTimestamp(ReplicaRequest request) {
        if (request instanceof TimestampAware) {
            return ((TimestampAware)((Object)request)).timestamp();
        }
        return null;
    }

    private void sendReplicaUnavailableErrorResponse(NetworkAddress senderAddr, @Nullable Long correlationId, ReplicaRequest request, HybridTimestamp requestTimestamp) {
        if (requestTimestamp != null) {
            this.clusterNetSvc.messagingService().respond(senderAddr, (NetworkMessage)REPLICA_MESSAGES_FACTORY.errorTimestampAwareReplicaResponse().throwable((Throwable)((Object)new ReplicaUnavailableException(request.groupId(), this.clusterNetSvc.topologyService().localMember()))).timestamp(this.clock.update(requestTimestamp)).build(), correlationId.longValue());
        } else {
            this.clusterNetSvc.messagingService().respond(senderAddr, (NetworkMessage)REPLICA_MESSAGES_FACTORY.errorReplicaResponse().throwable((Throwable)((Object)new ReplicaUnavailableException(request.groupId(), this.clusterNetSvc.topologyService().localMember()))).build(), correlationId.longValue());
        }
    }

    private NetworkMessage prepareReplicaResponse(HybridTimestamp requestTimestamp, Object result) {
        if (requestTimestamp != null) {
            return REPLICA_MESSAGES_FACTORY.timestampAwareReplicaResponse().result(result).timestamp(this.clock.update(requestTimestamp)).build();
        }
        return REPLICA_MESSAGES_FACTORY.replicaResponse().result(result).build();
    }

    private NetworkMessage prepareReplicaErrorResponse(HybridTimestamp requestTimestamp, Throwable ex) {
        if (requestTimestamp != null) {
            return REPLICA_MESSAGES_FACTORY.errorTimestampAwareReplicaResponse().throwable(ex).timestamp(this.clock.update(requestTimestamp)).build();
        }
        return REPLICA_MESSAGES_FACTORY.errorReplicaResponse().throwable(ex).build();
    }

    private void idleSafeTimeSync() {
        this.replicas.values().forEach(r -> {
            ReplicaSafeTimeSyncRequest req = REPLICA_MESSAGES_FACTORY.replicaSafeTimeSyncRequest().groupId(r.groupId()).build();
            r.processRequest(req);
        });
    }

    @TestOnly
    public Set<ReplicationGroupId> startedGroups() {
        return this.replicas.keySet();
    }
}

