/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.client.IgniteClientConfiguration;
import org.apache.ignite.compute.IgniteCompute;
import org.apache.ignite.internal.client.ClientChannel;
import org.apache.ignite.internal.client.ClientChannelConfiguration;
import org.apache.ignite.internal.client.ClientUtils;
import org.apache.ignite.internal.client.PayloadReader;
import org.apache.ignite.internal.client.PayloadWriter;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.TcpClientChannel;
import org.apache.ignite.internal.client.compute.ClientCompute;
import org.apache.ignite.internal.client.io.ClientConnectionMultiplexer;
import org.apache.ignite.internal.client.sql.ClientSql;
import org.apache.ignite.internal.client.table.ClientTables;
import org.apache.ignite.internal.client.tx.ClientTransactions;
import org.apache.ignite.internal.jdbc.proto.ClientMessage;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.lang.LoggerFactory;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.table.manager.IgniteTables;
import org.apache.ignite.tx.IgniteTransactions;

public class TcpIgniteClient
implements IgniteClient {
    private final IgniteClientConfiguration cfg;
    private final ReliableChannel ch;
    private final ClientTables tables;
    private final ClientTransactions transactions;
    private final ClientCompute compute;
    private final ClientSql sql;

    private TcpIgniteClient(IgniteClientConfiguration cfg) {
        this(TcpClientChannel::new, cfg);
    }

    private TcpIgniteClient(BiFunction<ClientChannelConfiguration, ClientConnectionMultiplexer, ClientChannel> chFactory, IgniteClientConfiguration cfg) {
        assert (chFactory != null);
        assert (cfg != null);
        this.cfg = cfg;
        LoggerFactory loggerFactory = cfg.loggerFactory() == null ? System::getLogger : cfg.loggerFactory();
        IgniteLogger log = Loggers.forClass(TcpIgniteClient.class, (LoggerFactory)loggerFactory);
        this.ch = new ReliableChannel(chFactory, cfg, log);
        this.tables = new ClientTables(this.ch);
        this.transactions = new ClientTransactions(this.ch);
        this.compute = new ClientCompute(this.ch, this.tables);
        this.sql = new ClientSql(this.ch);
    }

    public CompletableFuture<Void> initAsync() {
        return this.ch.channelsInitAsync();
    }

    public static CompletableFuture<IgniteClient> startAsync(IgniteClientConfiguration cfg) {
        TcpIgniteClient client = new TcpIgniteClient(cfg);
        return client.initAsync().thenApply(x -> client);
    }

    public IgniteTables tables() {
        return this.tables;
    }

    public IgniteTransactions transactions() {
        return this.transactions;
    }

    public IgniteSql sql() {
        return this.sql;
    }

    public IgniteCompute compute() {
        return this.compute;
    }

    public Collection<ClusterNode> clusterNodes() {
        return ClientUtils.sync(this.clusterNodesAsync());
    }

    public CompletableFuture<Collection<ClusterNode>> clusterNodesAsync() {
        return this.ch.serviceAsync(48, r -> {
            int cnt = r.in().unpackArrayHeader();
            ArrayList<ClusterNode> res = new ArrayList<ClusterNode>(cnt);
            for (int i = 0; i < cnt; ++i) {
                res.add(new ClusterNode(r.in().unpackString(), r.in().unpackString(), new NetworkAddress(r.in().unpackString(), r.in().unpackInt())));
            }
            return res;
        });
    }

    public void close() throws Exception {
        this.ch.close();
    }

    public String name() {
        return "thin-client";
    }

    @Override
    public IgniteClientConfiguration configuration() {
        return this.cfg;
    }

    @Override
    public List<ClusterNode> connections() {
        return this.ch.connections();
    }

    public <T extends ClientMessage> CompletableFuture<T> sendRequestAsync(int opCode, PayloadWriter writer, PayloadReader<T> reader) {
        return this.ch.serviceAsync(opCode, writer, reader);
    }
}

