/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.ConfigurationChangeException;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.NamedConfigurationTree;
import org.apache.ignite.configuration.NamedListChange;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.configuration.validation.ConfigurationValidationException;
import org.apache.ignite.internal.affinity.AffinityUtils;
import org.apache.ignite.internal.baseline.BaselineManager;
import org.apache.ignite.internal.causality.VersionedValue;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.Event;
import org.apache.ignite.internal.manager.EventListener;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.manager.Producer;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.client.Entry;
import org.apache.ignite.internal.metastorage.client.WatchEvent;
import org.apache.ignite.internal.metastorage.client.WatchListener;
import org.apache.ignite.internal.raft.Loza;
import org.apache.ignite.internal.raft.configuration.LogStorageBudgetView;
import org.apache.ignite.internal.raft.server.RaftGroupEventsListener;
import org.apache.ignite.internal.raft.server.RaftGroupOptions;
import org.apache.ignite.internal.raft.server.ReplicationGroupOptions;
import org.apache.ignite.internal.raft.storage.SnapshotStorageFactory;
import org.apache.ignite.internal.raft.storage.impl.LogStorageFactoryCreator;
import org.apache.ignite.internal.replicator.ReplicaManager;
import org.apache.ignite.internal.replicator.ReplicaService;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.listener.ReplicaListener;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaManager;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.SchemaUtils;
import org.apache.ignite.internal.schema.configuration.ExtendedTableChange;
import org.apache.ignite.internal.schema.configuration.ExtendedTableConfiguration;
import org.apache.ignite.internal.schema.configuration.ExtendedTableView;
import org.apache.ignite.internal.schema.configuration.TableChange;
import org.apache.ignite.internal.schema.configuration.TableConfiguration;
import org.apache.ignite.internal.schema.configuration.TableView;
import org.apache.ignite.internal.schema.configuration.TablesConfiguration;
import org.apache.ignite.internal.schema.configuration.index.TableIndexConfiguration;
import org.apache.ignite.internal.schema.event.SchemaEvent;
import org.apache.ignite.internal.schema.event.SchemaEventParameters;
import org.apache.ignite.internal.schema.marshaller.schema.SchemaSerializerImpl;
import org.apache.ignite.internal.storage.DataStorageManager;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.TableImpl;
import org.apache.ignite.internal.table.distributed.TableMessageGroup;
import org.apache.ignite.internal.table.distributed.TableMessagesFactory;
import org.apache.ignite.internal.table.distributed.TableSchemaAwareIndexStorage;
import org.apache.ignite.internal.table.distributed.message.HasDataRequest;
import org.apache.ignite.internal.table.distributed.message.HasDataRequestBuilder;
import org.apache.ignite.internal.table.distributed.message.HasDataResponse;
import org.apache.ignite.internal.table.distributed.raft.PartitionListener;
import org.apache.ignite.internal.table.distributed.raft.RebalanceRaftGroupEventsListener;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionSnapshotStorageFactory;
import org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing.OutgoingSnapshotsManager;
import org.apache.ignite.internal.table.distributed.replicator.PartitionReplicaListener;
import org.apache.ignite.internal.table.distributed.replicator.PlacementDriver;
import org.apache.ignite.internal.table.distributed.replicator.TablePartitionId;
import org.apache.ignite.internal.table.distributed.storage.InternalTableImpl;
import org.apache.ignite.internal.table.event.TableEvent;
import org.apache.ignite.internal.table.event.TableEventParameters;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.tx.LockManager;
import org.apache.ignite.internal.tx.TxManager;
import org.apache.ignite.internal.tx.storage.state.TxStateTableStorage;
import org.apache.ignite.internal.tx.storage.state.rocksdb.TxStateRocksDbTableStorage;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.IgniteNameUtils;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.Lazy;
import org.apache.ignite.internal.util.PendingComparableValuesTracker;
import org.apache.ignite.internal.utils.RebalanceUtil;
import org.apache.ignite.lang.ByteArray;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.IgniteStringFormatter;
import org.apache.ignite.lang.IgniteSystemProperties;
import org.apache.ignite.lang.IgniteTriConsumer;
import org.apache.ignite.lang.NodeStoppingException;
import org.apache.ignite.lang.TableAlreadyExistsException;
import org.apache.ignite.lang.TableNotFoundException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.MessagingService;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.NetworkMessage;
import org.apache.ignite.network.TopologyService;
import org.apache.ignite.raft.client.Peer;
import org.apache.ignite.raft.client.service.RaftGroupListener;
import org.apache.ignite.raft.client.service.RaftGroupService;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.storage.impl.VolatileRaftMetaStorage;
import org.apache.ignite.raft.jraft.util.Utils;
import org.apache.ignite.raft.jraft.util.concurrent.ConcurrentHashSet;
import org.apache.ignite.table.Table;
import org.apache.ignite.table.manager.IgniteTables;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TableManager
extends Producer<TableEvent, TableEventParameters>
implements IgniteTables,
IgniteTablesInternal,
IgniteComponent {
    private static final String DEFAULT_SCHEMA_NAME = "PUBLIC";
    private static final long TABLES_COMPLETE_TIMEOUT = 120L;
    private static final long QUERY_DATA_NODES_COUNT_TIMEOUT = TimeUnit.SECONDS.toMillis(3L);
    private static final IgniteLogger LOG = Loggers.forClass(TableManager.class);
    private static final String TX_STATE_DIR = "tx-state-";
    private static final int TX_STATE_STORAGE_FLUSH_DELAY = 1000;
    private static final IntSupplier TX_STATE_STORAGE_FLUSH_DELAY_SUPPLIER = () -> 1000;
    private final boolean getMetadataLocallyOnly = IgniteSystemProperties.getBoolean((String)"IGNITE_GET_METADATA_LOCALLY_ONLY");
    private final TablesConfiguration tablesCfg;
    private final Loza raftMgr;
    private final ReplicaManager replicaMgr;
    private final LockManager lockMgr;
    private final ReplicaService replicaSvc;
    private final BaselineManager baselineMgr;
    private final TxManager txManager;
    private final MetaStorageManager metaStorageMgr;
    private final DataStorageManager dataStorageMgr;
    private final PlacementDriver placementDriver;
    private final Map<UUID, CompletableFuture<Table>> tableCreateFuts = new ConcurrentHashMap<UUID, CompletableFuture<Table>>();
    private final VersionedValue<Map<UUID, TableImpl>> tablesByIdVv;
    private final Set<CompletableFuture<?>> beforeTablesVvComplete = new ConcurrentHashSet();
    private final Map<UUID, TableImpl> tablesToStopInCaseOfError = new ConcurrentHashMap<UUID, TableImpl>();
    private final Function<NetworkAddress, String> netAddrResolver;
    private final Function<NetworkAddress, ClusterNode> clusterNodeResolver;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final SchemaManager schemaManager;
    private final LogStorageFactoryCreator volatileLogStorageFactoryCreator;
    private final ScheduledExecutorService rebalanceScheduler;
    private final ScheduledExecutorService txStateStorageScheduledPool;
    private final ExecutorService txStateStoragePool;
    private final ExecutorService scanRequestExecutor;
    private final ExecutorService ioExecutor;
    private final HybridClock clock;
    private final Path storagePath;
    private final CopyOnWriteArrayList<Consumer<IgniteTablesInternal>> assignmentsChangeListeners = new CopyOnWriteArrayList();
    private static final int REBALANCE_SCHEDULER_POOL_SIZE = Math.min(Utils.cpus() * 3, 20);
    private static final TableMessagesFactory TABLE_MESSAGES_FACTORY = new TableMessagesFactory();

    public TableManager(String nodeName, Consumer<Function<Long, CompletableFuture<?>>> registry, TablesConfiguration tablesCfg, Loza raftMgr, ReplicaManager replicaMgr, LockManager lockMgr, ReplicaService replicaSvc, BaselineManager baselineMgr, TopologyService topologyService, TxManager txManager, DataStorageManager dataStorageMgr, Path storagePath, MetaStorageManager metaStorageMgr, SchemaManager schemaManager, LogStorageFactoryCreator volatileLogStorageFactoryCreator, HybridClock clock) {
        this.tablesCfg = tablesCfg;
        this.raftMgr = raftMgr;
        this.baselineMgr = baselineMgr;
        this.replicaMgr = replicaMgr;
        this.lockMgr = lockMgr;
        this.replicaSvc = replicaSvc;
        this.txManager = txManager;
        this.dataStorageMgr = dataStorageMgr;
        this.storagePath = storagePath;
        this.metaStorageMgr = metaStorageMgr;
        this.schemaManager = schemaManager;
        this.volatileLogStorageFactoryCreator = volatileLogStorageFactoryCreator;
        this.clock = clock;
        this.placementDriver = new PlacementDriver(replicaSvc);
        this.netAddrResolver = addr -> {
            ClusterNode node = topologyService.getByAddress(addr);
            if (node == null) {
                throw new IllegalStateException("Can't resolve ClusterNode by its networkAddress=" + addr);
            }
            return node.id();
        };
        this.clusterNodeResolver = arg_0 -> ((TopologyService)topologyService).getByAddress(arg_0);
        this.tablesByIdVv = new VersionedValue(null, HashMap::new);
        registry.accept(token -> {
            ArrayList futures = new ArrayList(this.beforeTablesVvComplete);
            this.beforeTablesVvComplete.clear();
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).orTimeout(120L, TimeUnit.SECONDS).whenComplete((v, e) -> {
                if (!this.busyLock.enterBusy()) {
                    if (e != null) {
                        LOG.warn("Error occurred while updating tables and stopping components.", e);
                    }
                    return;
                }
                try {
                    if (e != null) {
                        Throwable th;
                        LOG.warn("Error occurred while updating tables.", e);
                        if (e instanceof CompletionException && ((th = e.getCause()) instanceof NodeStoppingException || th.getCause() != null && th.getCause() instanceof NodeStoppingException)) {
                            return;
                        }
                        this.tablesByIdVv.completeExceptionally(token.longValue(), e);
                    }
                    this.tablesByIdVv.complete(token.longValue());
                    this.tablesToStopInCaseOfError.clear();
                }
                finally {
                    this.busyLock.leaveBusy();
                }
            });
        });
        this.txStateStorageScheduledPool = Executors.newSingleThreadScheduledExecutor((ThreadFactory)NamedThreadFactory.create((String)nodeName, (String)"tx-state-storage-scheduled-pool", (IgniteLogger)LOG));
        this.txStateStoragePool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), (ThreadFactory)NamedThreadFactory.create((String)nodeName, (String)"tx-state-storage-pool", (IgniteLogger)LOG));
        this.scanRequestExecutor = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.create((String)nodeName, (String)"scan-query-executor-", (IgniteLogger)LOG));
        this.rebalanceScheduler = new ScheduledThreadPoolExecutor(REBALANCE_SCHEDULER_POOL_SIZE, (ThreadFactory)NamedThreadFactory.create((String)nodeName, (String)"rebalance-scheduler", (IgniteLogger)LOG));
        this.ioExecutor = new ThreadPoolExecutor(Math.min(Utils.cpus() * 3, 25), Integer.MAX_VALUE, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)NamedThreadFactory.create((String)nodeName, (String)"tableManager-io", (IgniteLogger)LOG));
    }

    public void start() {
        ((TableConfiguration)this.tablesCfg.tables().any()).replicas().listen(this::onUpdateReplicas);
        this.registerRebalanceListeners();
        ((ExtendedTableConfiguration)this.tablesCfg.tables().any()).assignments().listen(this::onUpdateAssignments);
        this.tablesCfg.tables().listenElements((ConfigurationNamedListListener)new ConfigurationNamedListListener<TableView>(){

            public CompletableFuture<?> onCreate(ConfigurationNotificationEvent<TableView> ctx) {
                return TableManager.this.onTableCreate(ctx);
            }

            public CompletableFuture<?> onRename(String oldName, String newName, ConfigurationNotificationEvent<TableView> ctx) {
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> onDelete(ConfigurationNotificationEvent<TableView> ctx) {
                return TableManager.this.onTableDelete(ctx);
            }
        });
        this.schemaManager.listen((Event)SchemaEvent.CREATE, (EventListener)new EventListener<SchemaEventParameters>(){

            public CompletableFuture<Boolean> notify(@NotNull SchemaEventParameters parameters, @Nullable Throwable exception) {
                if (((Map)TableManager.this.tablesByIdVv.latest()).get(parameters.tableId()) != null) {
                    TableManager.this.fireEvent(TableEvent.ALTER, new TableEventParameters(parameters.causalityToken(), (TableImpl)((Map)TableManager.this.tablesByIdVv.latest()).get(parameters.tableId())), null);
                }
                return CompletableFuture.completedFuture(false);
            }
        });
        this.addMessageHandler(this.raftMgr.messagingService());
    }

    private void addMessageHandler(MessagingService messagingService) {
        messagingService.addMessageHandler(TableMessageGroup.class, (message, senderAddr, correlationId) -> {
            if (message instanceof HasDataRequest) {
                MvTableStorage storage;
                MvPartitionStorage mvPartition;
                assert (correlationId != null);
                HasDataRequest msg = (HasDataRequest)message;
                UUID tableId = msg.tableId();
                int partitionId = msg.partitionId();
                boolean contains = false;
                TableImpl table = (TableImpl)((Map)this.tablesByIdVv.latest()).get(tableId);
                if (table != null && (mvPartition = (storage = table.internalTable().storage()).getMvPartition(partitionId)) != null) {
                    contains = mvPartition.lastAppliedIndex() > 0L;
                }
                messagingService.respond(senderAddr, (NetworkMessage)TABLE_MESSAGES_FACTORY.hasDataResponse().result(contains).build(), correlationId.longValue());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<?> onTableCreate(ConfigurationNotificationEvent<TableView> ctx) {
        if (!this.busyLock.enterBusy()) {
            String tblName = ((TableView)ctx.newValue()).name();
            UUID tblId = ((ExtendedTableView)ctx.newValue()).id();
            this.fireEvent(TableEvent.CREATE, new TableEventParameters(ctx.storageRevision(), tblId, tblName), new NodeStoppingException());
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            CompletableFuture<?> completableFuture = this.createTableLocally(ctx.storageRevision(), ((TableView)ctx.newValue()).name(), ((ExtendedTableView)ctx.newValue()).id(), ((TableView)ctx.newValue()).partitions());
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<?> onTableDelete(ConfigurationNotificationEvent<TableView> ctx) {
        if (!this.busyLock.enterBusy()) {
            String tblName = ((TableView)ctx.oldValue()).name();
            UUID tblId = ((ExtendedTableView)ctx.oldValue()).id();
            this.fireEvent(TableEvent.DROP, new TableEventParameters(ctx.storageRevision(), tblId, tblName), new NodeStoppingException());
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            this.dropTableLocally(ctx.storageRevision(), ((TableView)ctx.oldValue()).name(), ((ExtendedTableView)ctx.oldValue()).id(), (List)ByteUtils.fromBytes((byte[])((ExtendedTableView)ctx.oldValue()).assignments()));
        }
        finally {
            this.busyLock.leaveBusy();
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<?> onUpdateReplicas(ConfigurationNotificationEvent<Integer> replicasCtx) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.completedFuture(new NodeStoppingException());
        }
        try {
            if (replicasCtx.oldValue() != null && (Integer)replicasCtx.oldValue() > 0) {
                TableConfiguration tblCfg = (TableConfiguration)replicasCtx.config(TableConfiguration.class);
                LOG.info("Received update for replicas number [table={}, oldNumber={}, newNumber={}]", new Object[]{tblCfg.name().value(), replicasCtx.oldValue(), replicasCtx.newValue()});
                int partCnt = (Integer)tblCfg.partitions().value();
                int newReplicas = (Integer)replicasCtx.newValue();
                CompletableFuture[] futures = new CompletableFuture[partCnt];
                for (int i = 0; i < partCnt; ++i) {
                    TablePartitionId replicaGrpId = new TablePartitionId((UUID)((ExtendedTableConfiguration)tblCfg).id().value(), i);
                    futures[i] = RebalanceUtil.updatePendingAssignmentsKeys((String)tblCfg.name().value(), replicaGrpId, this.baselineMgr.nodes(), newReplicas, replicasCtx.storageRevision(), this.metaStorageMgr, i);
                }
                CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures);
                return completableFuture;
            }
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private CompletableFuture<?> onUpdateAssignments(ConfigurationNotificationEvent<byte[]> assignmentsCtx) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture(new NodeStoppingException());
        }
        try {
            this.updateAssignmentInternal(assignmentsCtx);
        }
        finally {
            this.busyLock.leaveBusy();
        }
        for (Consumer<IgniteTablesInternal> listener : this.assignmentsChangeListeners) {
            listener.accept(this);
        }
        return CompletableFuture.completedFuture(null);
    }

    private void updateAssignmentInternal(ConfigurationNotificationEvent<byte[]> assignmentsCtx) {
        ExtendedTableConfiguration tblCfg = (ExtendedTableConfiguration)assignmentsCtx.config(ExtendedTableConfiguration.class);
        UUID tblId = (UUID)tblCfg.id().value();
        long causalityToken = assignmentsCtx.storageRevision();
        List oldAssignments = assignmentsCtx.oldValue() == null ? null : (List)ByteUtils.fromBytes((byte[])((byte[])assignmentsCtx.oldValue()));
        List newAssignments = (List)ByteUtils.fromBytes((byte[])((byte[])assignmentsCtx.newValue()));
        assert (newAssignments != null) : IgniteStringFormatter.format((String)"Table [id={}] has empty assignments.", (Object[])new Object[]{tblId});
        int partitions = newAssignments.size();
        CompletableFuture[] futures = new CompletableFuture[partitions];
        List assignmentsLatest = (List)ByteUtils.fromBytes((byte[])((byte[])this.directProxy(tblCfg.assignments()).value()));
        TopologyService topologyService = this.raftMgr.topologyService();
        ClusterNode localMember = topologyService.localMember();
        for (int i = 0; i < partitions; ++i) {
            int partId = i;
            Set oldPartAssignment = oldAssignments == null ? Collections.emptySet() : (Set)oldAssignments.get(partId);
            Set newPartAssignment = (Set)newAssignments.get(partId);
            this.tablesByIdVv.update(causalityToken, (tablesById, e) -> {
                if (e != null) {
                    return CompletableFuture.failedFuture(e);
                }
                TableImpl table = (TableImpl)tablesById.get(tblId);
                InternalTable internalTbl = table.internalTable();
                MvTableStorage storage = internalTbl.storage();
                boolean isInMemory = storage.isVolatile();
                assert (internalTbl.storage() instanceof MvTableStorage) : "Only multi version storages are supported. Current storage is a " + internalTbl.storage().getClass().getName();
                Set<ClusterNode> nodes = oldPartAssignment.isEmpty() ? newPartAssignment : Collections.emptySet();
                TablePartitionId replicaGrpId = new TablePartitionId(tblId, partId);
                this.placementDriver.updateAssignment(replicaGrpId, nodes);
                CompletionStage<Object> startGroupFut = CompletableFuture.completedFuture(null);
                PendingComparableValuesTracker safeTime = new PendingComparableValuesTracker((Comparable)this.clock.now());
                if (this.raftMgr.shouldHaveRaftGroupLocally(nodes)) {
                    startGroupFut = CompletableFuture.supplyAsync(() -> internalTbl.storage().getOrCreateMvPartition(partId), this.ioExecutor).thenComposeAsync(partitionStorage -> {
                        CompletionStage<Boolean> fut;
                        boolean hasData;
                        boolean bl = hasData = partitionStorage.lastAppliedIndex() > 0L;
                        if (isInMemory || !hasData) {
                            Set partAssignments = (Set)assignmentsLatest.get(partId);
                            fut = this.queryDataNodesCount(tblId, partId, partAssignments).thenApply(dataNodesCount -> {
                                boolean majorityAvailable;
                                boolean fullPartitionRestart;
                                boolean bl = fullPartitionRestart = dataNodesCount == 0L;
                                if (fullPartitionRestart) {
                                    return true;
                                }
                                boolean bl2 = majorityAvailable = dataNodesCount >= (long)(partAssignments.size() / 2 + 1);
                                if (majorityAvailable) {
                                    RebalanceUtil.startPeerRemoval(replicaGrpId, localMember, this.metaStorageMgr);
                                    return false;
                                }
                                String msg = "Unable to start partition " + partId + ". Majority not available.";
                                throw new IgniteInternalException(msg);
                            });
                        } else {
                            fut = CompletableFuture.completedFuture(true);
                        }
                        return fut.thenComposeAsync(startGroup -> {
                            if (!startGroup.booleanValue()) {
                                return CompletableFuture.completedFuture(null);
                            }
                            RaftGroupOptions groupOptions = this.groupOptionsForPartition(internalTbl, tblCfg, (MvPartitionStorage)partitionStorage, newPartAssignment, (PendingComparableValuesTracker<HybridTimestamp>)safeTime);
                            try {
                                this.raftMgr.startRaftGroupNode((ReplicationGroupId)replicaGrpId, (Collection)newPartAssignment, (RaftGroupListener)new PartitionListener((MvPartitionStorage)partitionStorage, internalTbl.txStateStorage().getOrCreateTxStateStorage(partId), this.txManager, table.indexStorageAdapters(partId)), (RaftGroupEventsListener)new RebalanceRaftGroupEventsListener(this.metaStorageMgr, (TableConfiguration)this.tablesCfg.tables().get(((TableImpl)tablesById.get(tblId)).name()), replicaGrpId, partId, this.busyLock, this.movePartition(() -> internalTbl.partitionRaftGroupService(partId)), this::calculateAssignments, this.rebalanceScheduler), groupOptions);
                                return CompletableFuture.completedFuture(null);
                            }
                            catch (NodeStoppingException ex) {
                                return CompletableFuture.failedFuture(ex);
                            }
                        }, (Executor)this.ioExecutor);
                    }, (Executor)this.ioExecutor);
                }
                futures[partId] = ((CompletableFuture)((CompletableFuture)startGroupFut.thenComposeAsync(v -> {
                    try {
                        return this.raftMgr.startRaftGroupService((ReplicationGroupId)replicaGrpId, (Collection)newPartAssignment);
                    }
                    catch (NodeStoppingException ex) {
                        return CompletableFuture.failedFuture(ex);
                    }
                }, (Executor)this.ioExecutor)).thenAccept(updatedRaftGroupService -> {
                    ((InternalTableImpl)internalTbl).updateInternalTableRaftGroupService(partId, (RaftGroupService)updatedRaftGroupService);
                    if (this.replicaMgr.shouldHaveReplicationGroupLocally((Collection)nodes)) {
                        MvPartitionStorage partitionStorage = internalTbl.storage().getOrCreateMvPartition(partId);
                        try {
                            this.replicaMgr.startReplica((ReplicationGroupId)replicaGrpId, (ReplicaListener)new PartitionReplicaListener(partitionStorage, (RaftGroupService)updatedRaftGroupService, this.txManager, this.lockMgr, this.scanRequestExecutor, partId, tblId, table.indexesLockers(partId), (Lazy<TableSchemaAwareIndexStorage>)new Lazy(() -> table.indexStorageAdapters(partId).get().get(table.pkId())), () -> table.indexStorageAdapters(partId).get(), this.clock, (PendingComparableValuesTracker<HybridTimestamp>)safeTime, internalTbl.txStateStorage().getOrCreateTxStateStorage(partId), topologyService, this.placementDriver, peer -> this.clusterNodeResolver.apply(peer.address()).equals((Object)topologyService.localMember())));
                        }
                        catch (NodeStoppingException ex) {
                            throw new AssertionError("Loza was stopped before Table manager", ex);
                        }
                    }
                })).exceptionally(th -> {
                    LOG.warn("Unable to update raft groups on the node", th);
                    return null;
                });
                return CompletableFuture.completedFuture(tablesById);
            });
        }
        CompletableFuture.allOf(futures).join();
    }

    private CompletableFuture<Long> queryDataNodesCount(UUID tblId, int partId, Set<ClusterNode> partAssignments) {
        HasDataRequestBuilder requestBuilder = TABLE_MESSAGES_FACTORY.hasDataRequest().tableId(tblId).partitionId(partId);
        CompletableFuture[] requestFutures = (CompletableFuture[])partAssignments.stream().map(node -> {
            HasDataRequest request = requestBuilder.build();
            return ((CompletableFuture)this.raftMgr.messagingService().invoke(node, (NetworkMessage)request, QUERY_DATA_NODES_COUNT_TIMEOUT).thenApply(response -> {
                assert (response instanceof HasDataResponse) : response;
                return ((HasDataResponse)response).result();
            })).exceptionally(unused -> false);
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(requestFutures).thenApply(unused -> Arrays.stream(requestFutures).filter(CompletableFuture::join).count());
    }

    private RaftGroupOptions groupOptionsForPartition(InternalTable internalTbl, ExtendedTableConfiguration tableConfig, MvPartitionStorage partitionStorage, Set<ClusterNode> peers, PendingComparableValuesTracker<HybridTimestamp> safeTime) {
        RaftGroupOptions raftGroupOptions = internalTbl.storage().isVolatile() ? RaftGroupOptions.forVolatileStores().setLogStorageFactory(this.volatileLogStorageFactoryCreator.factory((LogStorageBudgetView)this.raftMgr.volatileRaft().logStorage().value())).raftMetaStorageFactory((groupId, raftOptions) -> new VolatileRaftMetaStorage()) : RaftGroupOptions.forPersistentStores();
        raftGroupOptions.snapshotStorageFactory((SnapshotStorageFactory)new PartitionSnapshotStorageFactory(this.raftMgr.topologyService(), new OutgoingSnapshotsManager(this.raftMgr.messagingService()), () -> ((MvPartitionStorage)partitionStorage).persistedIndex(), peers.stream().map(n -> new Peer(n.address())).map(PeerId::fromPeer).map(Object::toString).collect(Collectors.toList()), List.of()));
        raftGroupOptions.replicationGroupOptions(new ReplicationGroupOptions().safeTime(safeTime));
        return raftGroupOptions;
    }

    public void stop() {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        Map tables = (Map)this.tablesByIdVv.latest();
        this.cleanUpTablesResources(tables);
        this.cleanUpTablesResources(this.tablesToStopInCaseOfError);
        this.tablesToStopInCaseOfError.clear();
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.rebalanceScheduler, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.ioExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.txStateStoragePool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.txStateStorageScheduledPool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.scanRequestExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    private void cleanUpTablesResources(Map<UUID, TableImpl> tables) {
        for (TableImpl table : tables.values()) {
            try {
                for (int p = 0; p < table.internalTable().partitions(); ++p) {
                    TablePartitionId replicationGroupId = new TablePartitionId(table.tableId(), p);
                    this.raftMgr.stopRaftGroup((ReplicationGroupId)replicationGroupId);
                    this.replicaMgr.stopReplica((ReplicationGroupId)replicationGroupId);
                }
                table.internalTable().storage().stop();
                table.internalTable().txStateStorage().stop();
                table.internalTable().close();
            }
            catch (Exception e) {
                LOG.info("Unable to stop table [name={}]", (Throwable)e, new Object[]{table.name()});
            }
        }
    }

    @Override
    public List<String> assignments(UUID tableId) throws NodeStoppingException {
        if (!this.busyLock.enterBusy()) {
            throw new NodeStoppingException();
        }
        try {
            List<String> list = this.table(tableId).internalTable().assignments();
            return list;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public void addAssignmentsChangeListener(Consumer<IgniteTablesInternal> listener) {
        Objects.requireNonNull(listener);
        this.assignmentsChangeListeners.add(listener);
    }

    @Override
    public boolean removeAssignmentsChangeListener(Consumer<IgniteTablesInternal> listener) {
        Objects.requireNonNull(listener);
        return this.assignmentsChangeListeners.remove(listener);
    }

    private CompletableFuture<?> createTableLocally(long causalityToken, String name, UUID tblId, int partitions) {
        LOG.trace("Creating local table: name={}, id={}, token={}", new Object[]{name, tblId, causalityToken});
        TableConfiguration tableCfg = (TableConfiguration)this.tablesCfg.tables().get(name);
        MvTableStorage tableStorage = this.dataStorageMgr.engine(tableCfg.dataStorage()).createMvTable(tableCfg, this.tablesCfg);
        TxStateTableStorage txStateStorage = this.createTxStateTableStorage(tableCfg);
        tableStorage.start();
        InternalTableImpl internalTable = new InternalTableImpl(name, tblId, (Int2ObjectMap<RaftGroupService>)new Int2ObjectOpenHashMap(partitions), partitions, this.netAddrResolver, this.clusterNodeResolver, this.txManager, tableStorage, txStateStorage, this.replicaSvc, this.clock);
        TableImpl table = new TableImpl((InternalTable)internalTable, this.lockMgr, this::directIndexIds);
        this.tablesByIdVv.update(causalityToken, (previous, e) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            if (e != null) {
                return CompletableFuture.failedFuture(e);
            }
            HashMap<UUID, TableImpl> val = new HashMap<UUID, TableImpl>((Map<UUID, TableImpl>)previous);
            val.put(tblId, table);
            return CompletableFuture.completedFuture(val);
        }));
        CompletionStage schemaFut = ((CompletableFuture)this.schemaManager.schemaRegistry(causalityToken, tblId).thenAccept(schema -> IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> table.schemaView((SchemaRegistry)schema)))).thenCompose(v -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.fireEvent(TableEvent.CREATE, new TableEventParameters(causalityToken, table))));
        this.beforeTablesVvComplete.add((CompletableFuture<?>)schemaFut);
        this.tablesToStopInCaseOfError.put(tblId, table);
        this.tablesByIdVv.get(causalityToken).thenRun(() -> IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.completeApiCreateFuture(table)));
        return CompletableFuture.completedFuture(null);
    }

    private TxStateTableStorage createTxStateTableStorage(TableConfiguration tableCfg) {
        Path path = this.storagePath.resolve(TX_STATE_DIR + ((TableView)tableCfg.value()).tableId());
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new StorageException("Failed to create transaction state storage directory for " + ((TableView)tableCfg.value()).name(), (Throwable)e);
        }
        TxStateRocksDbTableStorage txStateTableStorage = new TxStateRocksDbTableStorage(tableCfg, path, this.txStateStorageScheduledPool, this.txStateStoragePool, TX_STATE_STORAGE_FLUSH_DELAY_SUPPLIER);
        txStateTableStorage.start();
        return txStateTableStorage;
    }

    private void completeApiCreateFuture(TableImpl table) {
        LOG.trace("Finish creating table: name={}, id={}", new Object[]{table.name(), table.tableId()});
        CompletableFuture<Table> tblFut = this.tableCreateFuts.get(table.tableId());
        if (tblFut != null) {
            tblFut.complete(table);
            this.tableCreateFuts.values().removeIf(fut -> fut == tblFut);
        }
    }

    private void dropTableLocally(long causalityToken, String name, UUID tblId, List<Set<ClusterNode>> assignment) {
        try {
            int partitions = assignment.size();
            for (int p = 0; p < partitions; ++p) {
                TablePartitionId replicationGroupId = new TablePartitionId(tblId, p);
                this.raftMgr.stopRaftGroup((ReplicationGroupId)replicationGroupId);
                this.replicaMgr.stopReplica((ReplicationGroupId)replicationGroupId);
            }
            this.tablesByIdVv.update(causalityToken, (previousVal, e) -> (CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                if (e != null) {
                    return CompletableFuture.failedFuture(e);
                }
                HashMap map = new HashMap(previousVal);
                map.remove(tblId);
                return CompletableFuture.completedFuture(map);
            }));
            TableImpl table = (TableImpl)((Map)this.tablesByIdVv.latest()).get(tblId);
            assert (table != null) : IgniteStringFormatter.format((String)"There is no table with the name specified [name={}, id={}]", (Object[])new Object[]{name, tblId});
            table.internalTable().storage().destroy();
            CompletionStage fut = this.schemaManager.dropRegistry(causalityToken, table.tableId()).thenCompose(v -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.fireEvent(TableEvent.DROP, new TableEventParameters(causalityToken, table))));
            this.beforeTablesVvComplete.add((CompletableFuture<?>)fut);
        }
        catch (Exception e2) {
            this.fireEvent(TableEvent.DROP, new TableEventParameters(causalityToken, tblId, name), e2);
        }
    }

    private Set<ClusterNode> calculateAssignments(TableConfiguration tableCfg, int partNum) {
        return AffinityUtils.calculateAssignmentForPartition((Collection)this.baselineMgr.nodes(), (int)partNum, (int)((TableView)tableCfg.value()).replicas());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Table> createTableAsync(String name, Consumer<TableChange> tableInitChange) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException((Throwable)new NodeStoppingException());
        }
        try {
            CompletableFuture<Table> completableFuture = this.createTableAsyncInternal(name, tableInitChange);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private CompletableFuture<Table> createTableAsyncInternal(String name, Consumer<TableChange> tableInitChange) {
        CompletableFuture<Table> tblFut = new CompletableFuture<Table>();
        this.tableAsyncInternal(name).thenAccept(tbl -> {
            if (tbl != null) {
                tblFut.completeExceptionally((Throwable)new TableAlreadyExistsException(DEFAULT_SCHEMA_NAME, name));
            } else {
                this.tablesCfg.change(tablesChange -> tablesChange.changeTables(tablesListChange -> {
                    if (tablesListChange.get(name) != null) {
                        throw new TableAlreadyExistsException(DEFAULT_SCHEMA_NAME, name);
                    }
                    tablesListChange.create(name, tableChange -> {
                        tableChange.changeDataStorage(this.dataStorageMgr.defaultTableDataStorageConsumer(tablesChange.defaultDataStorage()));
                        tableInitChange.accept((TableChange)tableChange);
                        ExtendedTableChange extConfCh = (ExtendedTableChange)tableChange;
                        int intTableId = tablesChange.globalIdCounter() + 1;
                        tablesChange.changeGlobalIdCounter(intTableId);
                        extConfCh.changeTableId(intTableId);
                        this.tableCreateFuts.put(extConfCh.id(), tblFut);
                        extConfCh.changeAssignments(ByteUtils.toBytes((Object)AffinityUtils.calculateAssignments((Collection)this.baselineMgr.nodes(), (int)tableChange.partitions(), (int)tableChange.replicas(), HashSet::new))).changeSchemas(schemasCh -> schemasCh.create(String.valueOf(1), schemaCh -> {
                            SchemaDescriptor schemaDesc;
                            try {
                                schemaDesc = SchemaUtils.prepareSchemaDescriptor((int)((ExtendedTableView)tableChange).schemas().size(), (TableView)tableChange);
                            }
                            catch (IllegalArgumentException ex) {
                                throw new ConfigurationValidationException(ex.getMessage());
                            }
                            schemaCh.changeSchema(SchemaSerializerImpl.INSTANCE.serialize(schemaDesc));
                        }));
                    });
                })).exceptionally(t -> {
                    IgniteException ex = this.getRootCause((Throwable)t);
                    if (ex instanceof TableAlreadyExistsException) {
                        tblFut.completeExceptionally((Throwable)ex);
                    } else {
                        LOG.debug("Unable to create table [name={}]", (Throwable)ex, new Object[]{name});
                        tblFut.completeExceptionally((Throwable)ex);
                        this.tableCreateFuts.values().removeIf(fut -> fut == tblFut);
                    }
                    return null;
                });
            }
        });
        return tblFut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> alterTableAsync(String name, Consumer<TableChange> tableChange) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException((Throwable)new NodeStoppingException());
        }
        try {
            CompletableFuture<Void> completableFuture = this.alterTableAsyncInternal(name, tableChange);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private CompletableFuture<Void> alterTableAsyncInternal(String name, Consumer<TableChange> tableChange) {
        CompletableFuture<Void> tblFut = new CompletableFuture<Void>();
        ((CompletableFuture)this.tableAsync(name).thenAccept(tbl -> {
            if (tbl == null) {
                tblFut.completeExceptionally((Throwable)new TableNotFoundException(DEFAULT_SCHEMA_NAME, name));
            } else {
                TableImpl tblImpl = (TableImpl)tbl;
                this.tablesCfg.tables().change(ch -> {
                    if (ch.get(name) == null) {
                        throw new TableNotFoundException(DEFAULT_SCHEMA_NAME, name);
                    }
                    ch.update(name, tblCh -> {
                        tableChange.accept((TableChange)tblCh);
                        ((ExtendedTableChange)tblCh).changeSchemas(schemasCh -> schemasCh.createOrUpdate(String.valueOf(schemasCh.size() + 1), schemaCh -> {
                            SchemaDescriptor descriptor;
                            ExtendedTableView currTableView = (ExtendedTableView)((TableConfiguration)this.tablesCfg.tables().get(name)).value();
                            try {
                                descriptor = SchemaUtils.prepareSchemaDescriptor((int)((ExtendedTableView)tblCh).schemas().size(), (TableView)tblCh);
                                descriptor.columnMapping(SchemaUtils.columnMapper((SchemaDescriptor)tblImpl.schemaView().schema(currTableView.schemas().size()), (NamedListView)currTableView.columns(), (SchemaDescriptor)descriptor, (NamedListView)tblCh.columns()));
                            }
                            catch (IllegalArgumentException ex) {
                                ConfigurationValidationException e = new ConfigurationValidationException(ex.getMessage());
                                e.addSuppressed((Throwable)ex);
                                throw e;
                            }
                            schemaCh.changeSchema(SchemaSerializerImpl.INSTANCE.serialize(descriptor));
                        }));
                    });
                }).whenComplete((res, t) -> {
                    if (t != null) {
                        IgniteException ex = this.getRootCause((Throwable)t);
                        if (ex instanceof TableNotFoundException) {
                            tblFut.completeExceptionally((Throwable)ex);
                        } else {
                            LOG.debug("Unable to modify table [name={}]", (Throwable)ex, new Object[]{name});
                            tblFut.completeExceptionally((Throwable)ex);
                        }
                    } else {
                        tblFut.complete((Void)res);
                    }
                });
            }
        })).exceptionally(th -> {
            tblFut.completeExceptionally((Throwable)th);
            return null;
        });
        return tblFut;
    }

    @NotNull
    private IgniteException getRootCause(Throwable t) {
        Throwable ex = t instanceof CompletionException ? (t.getCause() instanceof ConfigurationChangeException ? t.getCause().getCause() : t.getCause()) : t;
        return ex instanceof IgniteException ? (IgniteException)ex : new IgniteException(ex);
    }

    public CompletableFuture<Void> dropTableAsync(String name) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException((Throwable)new NodeStoppingException());
        }
        try {
            CompletableFuture<Void> completableFuture = this.dropTableAsyncInternal(name);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private CompletableFuture<Void> dropTableAsyncInternal(String name) {
        CompletableFuture<Void> dropTblFut = new CompletableFuture<Void>();
        this.tableAsyncInternal(name).thenAccept(tbl -> {
            if (tbl == null) {
                dropTblFut.completeExceptionally((Throwable)new TableNotFoundException(DEFAULT_SCHEMA_NAME, name));
            } else {
                this.tablesCfg.change(chg -> chg.changeTables(tblChg -> {
                    TableView tableCfg = (TableView)tblChg.get(name);
                    if (tableCfg == null) {
                        throw new TableNotFoundException(DEFAULT_SCHEMA_NAME, name);
                    }
                    tblChg.delete(name);
                }).changeIndexes(idxChg -> {
                    List indicesNames = ((NamedListView)this.tablesCfg.indexes().value()).namedListKeys();
                    indicesNames.stream().filter(idx -> ((UUID)((TableIndexConfiguration)this.tablesCfg.indexes().get(idx)).tableId().value()).equals(tbl.tableId())).forEach(arg_0 -> ((NamedListChange)idxChg).delete(arg_0));
                })).whenComplete((res, t) -> {
                    if (t != null) {
                        IgniteException ex = this.getRootCause((Throwable)t);
                        if (ex instanceof TableNotFoundException) {
                            dropTblFut.completeExceptionally((Throwable)ex);
                        } else {
                            LOG.debug("Unable to drop table [name={}]", (Throwable)ex, new Object[]{name});
                            dropTblFut.completeExceptionally((Throwable)ex);
                        }
                    } else {
                        dropTblFut.complete((Void)res);
                    }
                });
            }
        });
        return dropTblFut;
    }

    public List<Table> tables() {
        return this.join(this.tablesAsync());
    }

    public CompletableFuture<List<Table>> tablesAsync() {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException((Throwable)new NodeStoppingException());
        }
        try {
            CompletableFuture<List<Table>> completableFuture = this.tablesAsyncInternal();
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private CompletableFuture<List<Table>> tablesAsyncInternal() {
        return CompletableFuture.supplyAsync(() -> (List)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, this::directTableIds)).thenCompose(tableIds -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            CompletableFuture[] tableFuts = new CompletableFuture[tableIds.size()];
            int i = 0;
            for (UUID tblId : tableIds) {
                tableFuts[i++] = this.tableAsyncInternal(tblId, false);
            }
            return CompletableFuture.allOf(tableFuts).thenApply(unused -> (List)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
                ArrayList<Table> tables = new ArrayList<Table>(tableIds.size());
                for (CompletableFuture fut : tableFuts) {
                    Object table = fut.join();
                    if (table == null) continue;
                    tables.add((Table)table);
                }
                return tables;
            }));
        }));
    }

    private List<UUID> directTableIds() {
        return ConfigurationUtil.internalIds((NamedConfigurationTree)this.directProxy(this.tablesCfg.tables()));
    }

    private List<UUID> directIndexIds() {
        return ConfigurationUtil.internalIds((NamedConfigurationTree)this.directProxy(this.tablesCfg.indexes()));
    }

    @Nullable
    private UUID directTableId(String tblName) {
        try {
            ExtendedTableConfiguration exTblCfg = (ExtendedTableConfiguration)this.directProxy(this.tablesCfg.tables()).get(tblName);
            if (exTblCfg == null) {
                return null;
            }
            return (UUID)exTblCfg.id().value();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @TestOnly
    public Map<UUID, TableImpl> latestTables() {
        return Collections.unmodifiableMap((Map)this.tablesByIdVv.latest());
    }

    public Table table(String name) {
        return this.join(this.tableAsync(name));
    }

    @Override
    public TableImpl table(UUID id) throws NodeStoppingException {
        return this.join(this.tableAsync(id));
    }

    public CompletableFuture<Table> tableAsync(String name) {
        return this.tableAsyncInternal(IgniteNameUtils.parseSimpleName((String)name)).thenApply(Function.identity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<TableImpl> tableAsync(long causalityToken, UUID id) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException((Throwable)new NodeStoppingException());
        }
        try {
            CompletionStage completionStage = this.tablesByIdVv.get(causalityToken).thenApply(tablesById -> (TableImpl)tablesById.get(id));
            return completionStage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public CompletableFuture<TableImpl> tableAsync(UUID id) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException((Throwable)new NodeStoppingException());
        }
        try {
            CompletableFuture<TableImpl> completableFuture = this.tableAsyncInternal(id, true);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public TableImpl tableImpl(String name) {
        return this.join(this.tableImplAsync(name));
    }

    @Override
    public CompletableFuture<TableImpl> tableImplAsync(String name) {
        return this.tableAsyncInternal(IgniteNameUtils.parseSimpleName((String)name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<TableImpl> tableAsyncInternal(String name) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException((Throwable)new NodeStoppingException());
        }
        try {
            UUID tableId = this.directTableId(name);
            if (tableId == null) {
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                return completableFuture;
            }
            CompletableFuture<TableImpl> completableFuture = this.tableAsyncInternal(tableId, false);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public CompletableFuture<TableImpl> tableAsyncInternal(UUID id, boolean checkConfiguration) {
        if (checkConfiguration && !this.isTableConfigured(id)) {
            return CompletableFuture.completedFuture(null);
        }
        TableImpl tbl = (TableImpl)((Map)this.tablesByIdVv.latest()).get(id);
        if (tbl != null) {
            return CompletableFuture.completedFuture(tbl);
        }
        CompletableFuture getTblFut = new CompletableFuture();
        IgniteTriConsumer tablesListener = (token, tables, th) -> {
            if (th == null) {
                TableImpl table = (TableImpl)tables.get(id);
                if (table != null) {
                    getTblFut.complete(table);
                }
            } else {
                getTblFut.completeExceptionally((Throwable)th);
            }
        };
        this.tablesByIdVv.whenComplete(tablesListener);
        tbl = (TableImpl)((Map)this.tablesByIdVv.latest()).get(id);
        if (tbl != null) {
            this.tablesByIdVv.removeWhenComplete(tablesListener);
            return CompletableFuture.completedFuture(tbl);
        }
        return getTblFut.whenComplete((unused, throwable) -> this.tablesByIdVv.removeWhenComplete(tablesListener));
    }

    private boolean isTableConfigured(UUID id) {
        try {
            ((ExtendedTableConfiguration)ConfigurationUtil.getByInternalId((NamedConfigurationTree)this.directProxy(this.tablesCfg.tables()), (UUID)id)).id().value();
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    private <T> T join(CompletableFuture<T> future) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException((Throwable)new NodeStoppingException());
        }
        try {
            T t = future.join();
            return t;
        }
        catch (CompletionException ex) {
            throw this.convertThrowable(ex.getCause());
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private RuntimeException convertThrowable(Throwable th) {
        if (th instanceof RuntimeException) {
            return (RuntimeException)th;
        }
        return new IgniteException(th);
    }

    private void registerRebalanceListeners() {
        this.metaStorageMgr.registerWatchByPrefix(ByteArray.fromString((String)"assignments.pending."), new WatchListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean onUpdate(@NotNull WatchEvent evt) {
                if (!TableManager.this.busyLock.enterBusy()) {
                    throw new IgniteInternalException((Throwable)new NodeStoppingException());
                }
                try {
                    assert (evt.single());
                    Entry pendingAssignmentsWatchEvent = evt.entryEvent().newEntry();
                    if (pendingAssignmentsWatchEvent.value() == null) {
                        boolean bl = true;
                        return bl;
                    }
                    int partId = RebalanceUtil.extractPartitionNumber(pendingAssignmentsWatchEvent.key());
                    UUID tblId = RebalanceUtil.extractTableId(pendingAssignmentsWatchEvent.key(), "assignments.pending.");
                    TablePartitionId replicaGrpId = new TablePartitionId(tblId, partId);
                    Set newPeers = (Set)ByteUtils.fromBytes((byte[])pendingAssignmentsWatchEvent.value());
                    Entry pendingAssignments = (Entry)TableManager.this.metaStorageMgr.get(RebalanceUtil.pendingPartAssignmentsKey(replicaGrpId)).join();
                    assert (pendingAssignmentsWatchEvent.revision() <= pendingAssignments.revision()) : "Meta Storage watch cannot notify about an event with the revision that is more than the actual revision.";
                    TableImpl tbl = (TableImpl)((Map)TableManager.this.tablesByIdVv.latest()).get(tblId);
                    ExtendedTableConfiguration tblCfg = (ExtendedTableConfiguration)TableManager.this.tablesCfg.tables().get(tbl.name());
                    assert (tbl.internalTable().storage() instanceof MvTableStorage) : "Only multi version storages are supported. Current storage is a " + tbl.internalTable().storage().getClass().getName();
                    byte[] stableAssignments = ((Entry)TableManager.this.metaStorageMgr.get(RebalanceUtil.stablePartAssignmentsKey(replicaGrpId), pendingAssignmentsWatchEvent.revision()).join()).value();
                    Set assignments = stableAssignments == null ? (Set)((List)ByteUtils.fromBytes((byte[])((byte[])tblCfg.assignments().value()))).get(partId) : (Set)ByteUtils.fromBytes((byte[])stableAssignments);
                    TableManager.this.placementDriver.updateAssignment(replicaGrpId, assignments);
                    ClusterNode localMember = TableManager.this.raftMgr.topologyService().localMember();
                    List deltaPeers = newPeers.stream().filter(p -> !assignments.contains(p)).collect(Collectors.toList());
                    PendingComparableValuesTracker safeTime = new PendingComparableValuesTracker((Comparable)TableManager.this.clock.now());
                    try {
                        MvPartitionStorage partitionStorage;
                        LOG.info("Received update on pending assignments. Check if new raft group should be started [key={}, partition={}, table={}, localMemberAddress={}]", new Object[]{pendingAssignmentsWatchEvent.key(), partId, tbl.name(), localMember.address()});
                        if (TableManager.this.raftMgr.shouldHaveRaftGroupLocally(deltaPeers)) {
                            partitionStorage = tbl.internalTable().storage().getOrCreateMvPartition(partId);
                            RaftGroupOptions groupOptions = TableManager.this.groupOptionsForPartition(tbl.internalTable(), tblCfg, partitionStorage, assignments, (PendingComparableValuesTracker<HybridTimestamp>)safeTime);
                            PartitionListener raftGrpLsnr = new PartitionListener(partitionStorage, tbl.internalTable().txStateStorage().getOrCreateTxStateStorage(partId), TableManager.this.txManager, tbl.indexStorageAdapters(partId));
                            RebalanceRaftGroupEventsListener raftGrpEvtsLsnr = new RebalanceRaftGroupEventsListener(TableManager.this.metaStorageMgr, (TableConfiguration)tblCfg, replicaGrpId, partId, TableManager.this.busyLock, TableManager.this.movePartition(() -> tbl.internalTable().partitionRaftGroupService(partId)), (x$0, x$1) -> TableManager.this.calculateAssignments((TableConfiguration)x$0, (int)x$1), TableManager.this.rebalanceScheduler);
                            TableManager.this.raftMgr.startRaftGroupNode((ReplicationGroupId)replicaGrpId, (Collection)assignments, (RaftGroupListener)raftGrpLsnr, (RaftGroupEventsListener)raftGrpEvtsLsnr, groupOptions);
                        }
                        if (TableManager.this.replicaMgr.shouldHaveReplicationGroupLocally(deltaPeers)) {
                            partitionStorage = tbl.internalTable().storage().getOrCreateMvPartition(partId);
                            TableManager.this.replicaMgr.startReplica((ReplicationGroupId)replicaGrpId, (ReplicaListener)new PartitionReplicaListener(partitionStorage, tbl.internalTable().partitionRaftGroupService(partId), TableManager.this.txManager, TableManager.this.lockMgr, TableManager.this.scanRequestExecutor, partId, tblId, tbl.indexesLockers(partId), (Lazy<TableSchemaAwareIndexStorage>)new Lazy(() -> tbl.indexStorageAdapters(partId).get().get(tbl.pkId())), () -> tbl.indexStorageAdapters(partId).get(), TableManager.this.clock, (PendingComparableValuesTracker<HybridTimestamp>)safeTime, tbl.internalTable().txStateStorage().getOrCreateTxStateStorage(partId), TableManager.this.raftMgr.topologyService(), TableManager.this.placementDriver, peer -> TableManager.this.clusterNodeResolver.apply(peer.address()).equals((Object)TableManager.this.raftMgr.topologyService().localMember())));
                        }
                    }
                    catch (NodeStoppingException partitionStorage) {
                        // empty catch block
                    }
                    if (pendingAssignmentsWatchEvent.revision() < pendingAssignments.revision()) {
                        boolean partitionStorage = true;
                        return partitionStorage;
                    }
                    List newNodes = newPeers.stream().map(n -> new Peer(n.address())).collect(Collectors.toList());
                    RaftGroupService partGrpSvc = tbl.internalTable().partitionRaftGroupService(partId);
                    IgniteBiTuple leaderWithTerm = (IgniteBiTuple)partGrpSvc.refreshAndGetLeaderWithTerm().join();
                    if (localMember.address().equals((Object)((Peer)leaderWithTerm.get1()).address())) {
                        LOG.info("Current node={} is the leader of partition raft group={}. Initiate rebalance process for partition={}, table={}", new Object[]{localMember.address(), replicaGrpId, partId, tbl.name()});
                        partGrpSvc.changePeersAsync(newNodes, ((Long)leaderWithTerm.get2()).longValue()).join();
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    TableManager.this.busyLock.leaveBusy();
                }
            }

            public void onError(@NotNull Throwable e) {
                LOG.warn("Unable to process pending assignments event", e);
            }
        });
        this.metaStorageMgr.registerWatchByPrefix(ByteArray.fromString((String)"assignments.stable."), new WatchListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean onUpdate(@NotNull WatchEvent evt) {
                if (!TableManager.this.busyLock.enterBusy()) {
                    throw new IgniteInternalException((Throwable)new NodeStoppingException());
                }
                try {
                    assert (evt.single());
                    Entry stableAssignmentsWatchEvent = evt.entryEvent().newEntry();
                    if (stableAssignmentsWatchEvent.value() == null) {
                        boolean bl = true;
                        return bl;
                    }
                    int part = RebalanceUtil.extractPartitionNumber(stableAssignmentsWatchEvent.key());
                    UUID tblId = RebalanceUtil.extractTableId(stableAssignmentsWatchEvent.key(), "assignments.stable.");
                    TablePartitionId replicaGrpId = new TablePartitionId(tblId, part);
                    Set stableAssignments = (Set)ByteUtils.fromBytes((byte[])stableAssignmentsWatchEvent.value());
                    byte[] pendingFromMetastorage = ((Entry)TableManager.this.metaStorageMgr.get(RebalanceUtil.pendingPartAssignmentsKey(replicaGrpId), stableAssignmentsWatchEvent.revision()).join()).value();
                    Set pendingAssignments = pendingFromMetastorage == null ? Collections.emptySet() : (Set)ByteUtils.fromBytes((byte[])pendingFromMetastorage);
                    try {
                        ClusterNode localMember = TableManager.this.raftMgr.topologyService().localMember();
                        if (!stableAssignments.contains(localMember) && !pendingAssignments.contains(localMember)) {
                            TableManager.this.raftMgr.stopRaftGroup((ReplicationGroupId)replicaGrpId);
                            TableManager.this.replicaMgr.stopReplica((ReplicationGroupId)new TablePartitionId(tblId, part));
                        }
                    }
                    catch (NodeStoppingException nodeStoppingException) {
                        // empty catch block
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    TableManager.this.busyLock.leaveBusy();
                }
            }

            public void onError(@NotNull Throwable e) {
                LOG.warn("Unable to process stable assignments event", e);
            }
        });
        this.metaStorageMgr.registerWatchByPrefix(ByteArray.fromString((String)"assignments.switch.reduce."), new WatchListener(){

            public boolean onUpdate(@NotNull WatchEvent evt) {
                ByteArray key = evt.entryEvent().newEntry().key();
                int partitionNumber = RebalanceUtil.extractPartitionNumber(key);
                UUID tblId = RebalanceUtil.extractTableId(key, "assignments.switch.reduce.");
                TablePartitionId replicaGrpId = new TablePartitionId(tblId, partitionNumber);
                TableImpl tbl = (TableImpl)((Map)TableManager.this.tablesByIdVv.latest()).get(tblId);
                TableConfiguration tblCfg = (TableConfiguration)TableManager.this.tablesCfg.tables().get(tbl.name());
                RebalanceUtil.handleReduceChanged(TableManager.this.metaStorageMgr, TableManager.this.baselineMgr.nodes(), ((TableView)tblCfg.value()).replicas(), partitionNumber, replicaGrpId, evt);
                return true;
            }

            public void onError(@NotNull Throwable e) {
                LOG.warn("Unable to process switch reduce event", e);
            }
        });
    }

    BiFunction<List<Peer>, Long, CompletableFuture<Void>> movePartition(Supplier<RaftGroupService> raftGroupServiceSupplier) {
        return (peers, term) -> {
            if (!this.busyLock.enterBusy()) {
                throw new IgniteInternalException((Throwable)new NodeStoppingException());
            }
            try {
                CompletionStage completionStage = ((CompletableFuture)((RaftGroupService)raftGroupServiceSupplier.get()).changePeersAsync(peers, term.longValue()).handleAsync((arg_0, arg_1) -> this.lambda$movePartition$66((Supplier)raftGroupServiceSupplier, peers, term, arg_0, arg_1), (Executor)this.rebalanceScheduler)).thenCompose(Function.identity());
                return completionStage;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        };
    }

    private <T extends ConfigurationProperty<?>> T directProxy(T property) {
        return (T)(this.getMetadataLocallyOnly ? property : ConfigurationUtil.directProxy(property));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ CompletableFuture lambda$movePartition$66(Supplier raftGroupServiceSupplier, List peers, Long term, Void resp, Throwable err) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteInternalException((Throwable)new NodeStoppingException());
        }
        try {
            if (err != null) {
                if (RebalanceUtil.recoverable(err)) {
                    LOG.debug("Recoverable error received during changePeersAsync invocation, retrying", err);
                } else {
                    LOG.debug("Unrecoverable error received during changePeersAsync invocation, retrying", err);
                }
                CompletableFuture<Void> completableFuture = this.movePartition(raftGroupServiceSupplier).apply(peers, term);
                return completableFuture;
            }
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }
}

