/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.rpc.InstallSnapshotRequestBuilder;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

public class InstallSnapshotRequestImpl
implements RpcRequests.InstallSnapshotRequest {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3002;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private RaftOutter.SnapshotMeta meta;
    private byte[] metaByteArray;
    @IgniteToStringInclude
    private final String peerId;
    @IgniteToStringInclude
    private final String serverId;
    @IgniteToStringInclude
    private final long term;
    @IgniteToStringInclude
    private final String uri;

    private InstallSnapshotRequestImpl(String groupId, RaftOutter.SnapshotMeta meta, byte[] metaByteArray, String peerId, String serverId, long term, String uri) {
        this.groupId = groupId;
        this.meta = meta;
        this.metaByteArray = metaByteArray;
        this.peerId = peerId;
        this.serverId = serverId;
        this.term = term;
        this.uri = uri;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    byte[] metaByteArray() {
        return this.metaByteArray;
    }

    @Override
    public RaftOutter.SnapshotMeta meta() {
        return this.meta;
    }

    @Override
    public String peerId() {
        return this.peerId;
    }

    @Override
    public String serverId() {
        return this.serverId;
    }

    @Override
    public long term() {
        return this.term;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(InstallSnapshotRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 3002;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        InstallSnapshotRequestImpl otherMessage = (InstallSnapshotRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.meta, otherMessage.meta) && Objects.equals(this.peerId, otherMessage.peerId) && Objects.equals(this.serverId, otherMessage.serverId) && Objects.equals(this.uri, otherMessage.uri) && this.term == otherMessage.term;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.term, this.groupId, this.meta, this.peerId, this.serverId, this.uri);
        return result;
    }

    public static InstallSnapshotRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject metaByteArraymo = marshaller.marshal((Object)this.meta);
        usedDescriptors.addAll((IntCollection)metaByteArraymo.usedDescriptorIds());
        this.metaByteArray = metaByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.meta = (RaftOutter.SnapshotMeta)marshaller.unmarshal(this.metaByteArray, descriptorsObj);
        this.metaByteArray = null;
    }

    private static class Builder
    implements InstallSnapshotRequestBuilder {
        private String groupId;
        private RaftOutter.SnapshotMeta meta;
        private byte[] metaByteArray;
        private String peerId;
        private String serverId;
        private long term;
        private String uri;

        private Builder() {
        }

        @Override
        public InstallSnapshotRequestBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Override
        public InstallSnapshotRequestBuilder meta(RaftOutter.SnapshotMeta meta) {
            this.meta = meta;
            return this;
        }

        @Override
        public InstallSnapshotRequestBuilder metaByteArray(byte[] metaByteArray) {
            this.metaByteArray = metaByteArray;
            return this;
        }

        @Override
        public InstallSnapshotRequestBuilder peerId(String peerId) {
            this.peerId = peerId;
            return this;
        }

        @Override
        public InstallSnapshotRequestBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        @Override
        public InstallSnapshotRequestBuilder term(long term) {
            this.term = term;
            return this;
        }

        @Override
        public InstallSnapshotRequestBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public RaftOutter.SnapshotMeta meta() {
            return this.meta;
        }

        @Override
        public byte[] metaByteArray() {
            return this.metaByteArray;
        }

        @Override
        public String peerId() {
            return this.peerId;
        }

        @Override
        public String serverId() {
            return this.serverId;
        }

        @Override
        public long term() {
            return this.term;
        }

        @Override
        public String uri() {
            return this.uri;
        }

        @Override
        public RpcRequests.InstallSnapshotRequest build() {
            return new InstallSnapshotRequestImpl(this.groupId, this.meta, this.metaByteArray, this.peerId, this.serverId, this.term, this.uri);
        }
    }
}

