/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.rel;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.sql.engine.exec.ExecutionCancelledException;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite.internal.sql.engine.exec.rel.Node;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.apache.ignite.lang.IgniteStringFormatter;

public abstract class AbstractNode<RowT>
implements Node<RowT> {
    public static final int MODIFY_BATCH_SIZE = 100;
    protected static final int IO_BATCH_SIZE = 256;
    protected static final int IO_BATCH_CNT = 4;
    protected final int inBufSize = 512;
    private volatile Thread thread;
    private ExecutionContext<RowT> ctx;
    private RelDataType rowType;
    private Downstream<RowT> downstream;
    private boolean closed;
    private List<Node<RowT>> sources;

    protected AbstractNode(ExecutionContext<RowT> ctx, RelDataType rowType) {
        this.ctx = ctx;
        this.rowType = rowType;
    }

    @Override
    public ExecutionContext<RowT> context() {
        return this.ctx;
    }

    protected void context(ExecutionContext<RowT> ctx) {
        this.ctx = ctx;
    }

    @Override
    public RelDataType rowType() {
        return this.rowType;
    }

    protected void rowType(RelDataType rowType) {
        this.rowType = rowType;
    }

    @Override
    public void register(List<Node<RowT>> sources) {
        this.sources = sources;
        for (int i = 0; i < sources.size(); ++i) {
            sources.get(i).onRegister(this.requestDownstream(i));
        }
    }

    @Override
    public List<Node<RowT>> sources() {
        return this.sources;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.closeInternal();
        if (!CollectionUtils.nullOrEmpty(this.sources())) {
            this.sources().forEach(Commons::closeQuiet);
        }
    }

    @Override
    public void rewind() {
        this.rewindInternal();
        if (!CollectionUtils.nullOrEmpty(this.sources())) {
            this.sources().forEach(Node::rewind);
        }
    }

    @Override
    public void onRegister(Downstream<RowT> downstream) {
        this.downstream = downstream;
    }

    public void onError(Throwable e) {
        Downstream<RowT> downstream = this.downstream();
        assert (downstream != null);
        try {
            downstream.onError(e);
        }
        finally {
            Commons.closeQuiet(this);
        }
    }

    protected void closeInternal() {
        this.closed = true;
    }

    protected abstract void rewindInternal();

    protected boolean isClosed() {
        return this.closed;
    }

    protected void checkState() throws Exception {
        if (this.context().isCancelled()) {
            throw new ExecutionCancelledException();
        }
        if (Thread.interrupted()) {
            throw new IgniteInternalCheckedException(ErrorGroups.Sql.OPERATION_INTERRUPTED_ERR, "Thread was interrupted.");
        }
        if (!IgniteUtils.assertionsEnabled()) {
            return;
        }
        if (this.thread == null) {
            this.thread = Thread.currentThread();
        } else assert (this.thread == Thread.currentThread()) : IgniteStringFormatter.format((String)"expThread={}, actThread={}, qryId={}, fragmentId={}", (Object[])new Object[]{this.thread.getName(), Thread.currentThread().getName(), this.context().queryId(), this.context().fragmentId()});
    }

    protected abstract Downstream<RowT> requestDownstream(int var1);

    @Override
    public Downstream<RowT> downstream() {
        return this.downstream;
    }
}

