/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare.ddl;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.ddl.SqlColumnDeclaration;
import org.apache.calcite.sql.ddl.SqlDdlNodes;
import org.apache.calcite.sql.ddl.SqlDropTable;
import org.apache.calcite.sql.ddl.SqlKeyConstraint;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.ignite.internal.sql.engine.prepare.IgnitePlanner;
import org.apache.ignite.internal.sql.engine.prepare.PlanningContext;
import org.apache.ignite.internal.sql.engine.prepare.ddl.AlterTableAddCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.AlterTableDropCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.ColumnDefinition;
import org.apache.ignite.internal.sql.engine.prepare.ddl.CreateIndexCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.CreateTableCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DdlCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DefaultValueDefinition;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DropIndexCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DropTableCommand;
import org.apache.ignite.internal.sql.engine.prepare.ddl.TableOptionInfo;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlAlterTableAddColumn;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlAlterTableDropColumn;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlCreateIndex;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlCreateTable;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlCreateTableOption;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlDropIndex;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlIndexType;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public class DdlSqlToCommandConverter {
    private final Supplier<String> defaultDataStorageSupplier;
    private final Map<String, String> dataStorageNames;
    private final Map<String, TableOptionInfo<?>> tableOptionInfos;
    private final Map<String, Map<String, TableOptionInfo<?>>> dataStorageOptionInfos;

    public DdlSqlToCommandConverter(Map<String, Map<String, Class<?>>> dataStorageFields, Supplier<String> defaultDataStorageSupplier) {
        this.defaultDataStorageSupplier = defaultDataStorageSupplier;
        this.dataStorageNames = DdlSqlToCommandConverter.collectDataStorageNames(dataStorageFields.keySet());
        this.tableOptionInfos = DdlSqlToCommandConverter.collectTableOptionInfos(new TableOptionInfo<Integer>("replicas", Integer.class, this::checkPositiveNumber, CreateTableCommand::replicas), new TableOptionInfo<Integer>("partitions", Integer.class, this::checkPositiveNumber, CreateTableCommand::partitions));
        this.dataStorageOptionInfos = dataStorageFields.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e0 -> DdlSqlToCommandConverter.collectTableOptionInfos((TableOptionInfo[])((Map)e0.getValue()).entrySet().stream().map(this::dataStorageFieldOptionInfo).toArray(TableOptionInfo[]::new))));
        this.dataStorageOptionInfos.forEach((k, v) -> DdlSqlToCommandConverter.checkDuplicates(v, this.tableOptionInfos));
    }

    public DdlCommand convert(SqlDdl ddlNode, PlanningContext ctx) {
        if (ddlNode instanceof IgniteSqlCreateTable) {
            return this.convertCreateTable((IgniteSqlCreateTable)ddlNode, ctx);
        }
        if (ddlNode instanceof SqlDropTable) {
            return this.convertDropTable((SqlDropTable)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterTableAddColumn) {
            return this.convertAlterTableAdd((IgniteSqlAlterTableAddColumn)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterTableDropColumn) {
            return this.convertAlterTableDrop((IgniteSqlAlterTableDropColumn)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlCreateIndex) {
            return this.convertAddIndex((IgniteSqlCreateIndex)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlDropIndex) {
            return this.convertDropIndex((IgniteSqlDropIndex)ddlNode, ctx);
        }
        throw new SqlException(ErrorGroups.Sql.UNSUPPORTED_DDL_OPERATION_ERR, "Unsupported operation [sqlNodeKind=" + ddlNode.getKind() + "; querySql=\"" + ctx.query() + "\"]");
    }

    private CreateTableCommand convertCreateTable(IgniteSqlCreateTable createTblNode, PlanningContext ctx) {
        List pkConstraints;
        CreateTableCommand createTblCmd = new CreateTableCommand();
        createTblCmd.schemaName(this.deriveSchemaName(createTblNode.name(), ctx));
        createTblCmd.tableName(this.deriveObjectName(createTblNode.name(), ctx, "tableName"));
        createTblCmd.ifTableExists(createTblNode.ifNotExists());
        createTblCmd.dataStorage(this.deriveDataStorage(createTblNode.engineName(), ctx));
        if (createTblNode.createOptionList() != null) {
            for (SqlNode optionNode : createTblNode.createOptionList().getList()) {
                IgniteSqlCreateTableOption option = (IgniteSqlCreateTableOption)optionNode;
                assert (option.key().isSimple()) : option.key();
                String optionKey = option.key().getSimple().toUpperCase();
                if (this.tableOptionInfos.containsKey(optionKey)) {
                    this.processTableOption(this.tableOptionInfos.get(optionKey), option, ctx, createTblCmd);
                    continue;
                }
                if (this.dataStorageOptionInfos.get(createTblCmd.dataStorage()).containsKey(optionKey)) {
                    this.processTableOption(this.dataStorageOptionInfos.get(createTblCmd.dataStorage()).get(optionKey), option, ctx, createTblCmd);
                    continue;
                }
                throw new IgniteException(ErrorGroups.Sql.TABLE_OPTION_ERR, String.format("Unexpected table option [option=%s, query=%s]", optionKey, ctx.query()));
            }
        }
        if ((pkConstraints = createTblNode.columnList().getList().stream().filter(SqlKeyConstraint.class::isInstance).map(SqlKeyConstraint.class::cast).collect(Collectors.toList())).isEmpty() && Commons.implicitPkEnabled()) {
            SqlIdentifier colName = new SqlIdentifier("__p_key", SqlParserPos.ZERO);
            pkConstraints.add(SqlKeyConstraint.primary((SqlParserPos)SqlParserPos.ZERO, null, (SqlNodeList)SqlNodeList.of((SqlNode)colName)));
            SqlDataTypeSpec type = new SqlDataTypeSpec((SqlTypeNameSpec)new SqlBasicTypeNameSpec(SqlTypeName.VARCHAR, SqlParserPos.ZERO), SqlParserPos.ZERO);
            SqlNode col = SqlDdlNodes.column((SqlParserPos)SqlParserPos.ZERO, (SqlIdentifier)colName, (SqlDataTypeSpec)type, null, (ColumnStrategy)ColumnStrategy.DEFAULT);
            createTblNode.columnList().add(0, col);
        }
        if (CollectionUtils.nullOrEmpty(pkConstraints)) {
            throw new SqlException(ErrorGroups.Sql.PRIMARY_KEY_MISSING_ERR, "Table without PRIMARY KEY is not supported");
        }
        if (pkConstraints.size() > 1) {
            throw new SqlException(ErrorGroups.Sql.PRIMARY_KEYS_MULTIPLE_ERR, "Unexpected amount of primary key constraints [expected at most one, but was " + pkConstraints.size() + "; querySql=\"" + ctx.query() + "\"]");
        }
        HashSet dedupSetPk = new HashSet();
        List<String> pkCols = pkConstraints.stream().map(pk -> (SqlNode)pk.getOperandList().get(1)).map(SqlNodeList.class::cast).flatMap(l -> l.getList().stream()).map(SqlIdentifier.class::cast).map(SqlIdentifier::getSimple).filter(dedupSetPk::add).collect(Collectors.toList());
        createTblCmd.primaryKeyColumns(pkCols);
        List colocationCols = createTblNode.colocationColumns() == null ? null : createTblNode.colocationColumns().getList().stream().map(SqlIdentifier.class::cast).map(SqlIdentifier::getSimple).collect(Collectors.toList());
        createTblCmd.colocationColumns(colocationCols);
        List colDeclarations = createTblNode.columnList().getList().stream().filter(SqlColumnDeclaration.class::isInstance).map(SqlColumnDeclaration.class::cast).collect(Collectors.toList());
        IgnitePlanner planner = ctx.planner();
        ArrayList<ColumnDefinition> cols = new ArrayList<ColumnDefinition>(colDeclarations.size());
        for (SqlColumnDeclaration col : colDeclarations) {
            if (!col.name.isSimple()) {
                throw new SqlException(ErrorGroups.Sql.QUERY_INVALID_ERR, "Unexpected value of columnName [expected a simple identifier, but was " + col.name + "; querySql=\"" + ctx.query() + "\"]");
            }
            String name = col.name.getSimple();
            if (col.dataType.getNullable() != null && col.dataType.getNullable().booleanValue() && dedupSetPk.contains(name)) {
                throw new SqlException(ErrorGroups.Sql.QUERY_INVALID_ERR, "Primary key cannot contain nullable column [col=" + name + "]");
            }
            RelDataType relType = planner.convert(col.dataType, !dedupSetPk.contains(name));
            dedupSetPk.remove(name);
            DefaultValueDefinition dflt = this.convertDefault(col.expression, relType);
            cols.add(new ColumnDefinition(name, relType, dflt));
        }
        if (!dedupSetPk.isEmpty()) {
            throw new SqlException(ErrorGroups.Sql.QUERY_INVALID_ERR, "Primary key constraint contains undefined columns: [cols=" + dedupSetPk + "]");
        }
        createTblCmd.columns(cols);
        return createTblCmd;
    }

    private AlterTableAddCommand convertAlterTableAdd(IgniteSqlAlterTableAddColumn alterTblNode, PlanningContext ctx) {
        AlterTableAddCommand alterTblCmd = new AlterTableAddCommand();
        alterTblCmd.schemaName(this.deriveSchemaName(alterTblNode.name(), ctx));
        alterTblCmd.tableName(this.deriveObjectName(alterTblNode.name(), ctx, "table name"));
        alterTblCmd.ifTableExists(alterTblNode.ifExists());
        alterTblCmd.ifColumnNotExists(alterTblNode.ifNotExistsColumn());
        ArrayList<ColumnDefinition> cols = new ArrayList<ColumnDefinition>(alterTblNode.columns().size());
        for (SqlNode colNode : alterTblNode.columns()) {
            assert (colNode instanceof SqlColumnDeclaration) : colNode.getClass();
            SqlColumnDeclaration col = (SqlColumnDeclaration)colNode;
            assert (col.name.isSimple());
            RelDataType relType = ctx.planner().convert(col.dataType, true);
            DefaultValueDefinition dflt = this.convertDefault(col.expression, relType);
            String name = col.name.getSimple();
            cols.add(new ColumnDefinition(name, relType, dflt));
        }
        alterTblCmd.columns(cols);
        return alterTblCmd;
    }

    private DefaultValueDefinition convertDefault(SqlNode expression, RelDataType relType) {
        if (expression instanceof SqlIdentifier) {
            return DefaultValueDefinition.functionCall(((SqlIdentifier)expression).getSimple());
        }
        Object val = null;
        if (expression instanceof SqlLiteral) {
            val = DdlSqlToCommandConverter.fromLiteral(relType, (SqlLiteral)expression);
        }
        return DefaultValueDefinition.constant(val);
    }

    private AlterTableDropCommand convertAlterTableDrop(IgniteSqlAlterTableDropColumn alterTblNode, PlanningContext ctx) {
        AlterTableDropCommand alterTblCmd = new AlterTableDropCommand();
        alterTblCmd.schemaName(this.deriveSchemaName(alterTblNode.name(), ctx));
        alterTblCmd.tableName(this.deriveObjectName(alterTblNode.name(), ctx, "table name"));
        alterTblCmd.ifTableExists(alterTblNode.ifExists());
        alterTblCmd.ifColumnExists(alterTblNode.ifExistsColumn());
        HashSet<String> cols = new HashSet<String>(alterTblNode.columns().size());
        alterTblNode.columns().forEach(c -> cols.add(((SqlIdentifier)c).getSimple()));
        alterTblCmd.columns(cols);
        return alterTblCmd;
    }

    private DropTableCommand convertDropTable(SqlDropTable dropTblNode, PlanningContext ctx) {
        DropTableCommand dropTblCmd = new DropTableCommand();
        dropTblCmd.schemaName(this.deriveSchemaName(dropTblNode.name, ctx));
        dropTblCmd.tableName(this.deriveObjectName(dropTblNode.name, ctx, "tableName"));
        dropTblCmd.ifTableExists(dropTblNode.ifExists);
        return dropTblCmd;
    }

    private CreateIndexCommand convertAddIndex(IgniteSqlCreateIndex sqlCmd, PlanningContext ctx) {
        CreateIndexCommand createIdxCmd = new CreateIndexCommand();
        createIdxCmd.schemaName(this.deriveSchemaName(sqlCmd.tableName(), ctx));
        createIdxCmd.tableName(this.deriveObjectName(sqlCmd.tableName(), ctx, "table name"));
        createIdxCmd.indexName(sqlCmd.indexName().getSimple());
        createIdxCmd.type(this.convertIndexType(sqlCmd.type()));
        ArrayList<String> columns = new ArrayList<String>(sqlCmd.columnList().size());
        ArrayList<IgniteIndex.Collation> collations = new ArrayList<IgniteIndex.Collation>(sqlCmd.columnList().size());
        for (SqlNode col : sqlCmd.columnList().getList()) {
            boolean desc = false;
            if (col.getKind() == SqlKind.DESCENDING) {
                col = (SqlNode)((SqlCall)col).getOperandList().get(0);
                desc = true;
            }
            columns.add(((SqlIdentifier)col).getSimple());
            collations.add(desc ? IgniteIndex.Collation.DESC_NULLS_FIRST : IgniteIndex.Collation.ASC_NULLS_LAST);
        }
        createIdxCmd.columns(columns);
        if (createIdxCmd.type() == CreateIndexCommand.Type.SORTED) {
            createIdxCmd.collations(collations);
        }
        createIdxCmd.ifNotExists(sqlCmd.ifNotExists());
        return createIdxCmd;
    }

    private DropIndexCommand convertDropIndex(IgniteSqlDropIndex sqlCmd, PlanningContext ctx) {
        DropIndexCommand dropCmd = new DropIndexCommand();
        String schemaName = this.deriveSchemaName(sqlCmd.indexName(), ctx);
        String indexName = this.deriveObjectName(sqlCmd.indexName(), ctx, "index name");
        dropCmd.schemaName(schemaName);
        dropCmd.indexName(indexName);
        dropCmd.ifNotExists(sqlCmd.ifExists());
        return dropCmd;
    }

    private String deriveSchemaName(SqlIdentifier id, PlanningContext ctx) {
        String schemaName;
        if (id.isSimple()) {
            schemaName = ctx.schemaName();
        } else {
            SqlIdentifier schemaId = id.skipLast(1);
            if (!schemaId.isSimple()) {
                throw new SqlException(ErrorGroups.Sql.QUERY_INVALID_ERR, "Unexpected value of schemaName [expected a simple identifier, but was " + schemaId + "; querySql=\"" + ctx.query() + "\"]");
            }
            schemaName = schemaId.getSimple();
        }
        this.ensureSchemaExists(ctx, schemaName);
        return schemaName;
    }

    private String deriveObjectName(SqlIdentifier id, PlanningContext ctx, String objDesc) {
        if (id.isSimple()) {
            return id.getSimple();
        }
        SqlIdentifier objId = id.getComponent(id.skipLast((int)1).names.size());
        if (!objId.isSimple()) {
            throw new SqlException(ErrorGroups.Sql.QUERY_INVALID_ERR, "Unexpected value of " + objDesc + " [expected a simple identifier, but was " + objId + "; querySql=\"" + ctx.query() + "\"]");
        }
        return objId.getSimple();
    }

    private void ensureSchemaExists(PlanningContext ctx, String schemaName) {
        if (ctx.catalogReader().getRootSchema().getSubSchema(schemaName, true) == null) {
            throw new SqlException(ErrorGroups.Sql.SCHEMA_NOT_FOUND_ERR, "Schema with name " + schemaName + " not found");
        }
    }

    static Map<String, String> collectDataStorageNames(Set<String> dataStorages) {
        return dataStorages.stream().collect(Collectors.toUnmodifiableMap(String::toUpperCase, Function.identity()));
    }

    static Map<String, TableOptionInfo<?>> collectTableOptionInfos(TableOptionInfo<?> ... tableOptionInfos) {
        return ArrayUtils.nullOrEmpty((Object[])tableOptionInfos) ? Map.of() : Stream.of(tableOptionInfos).collect(Collectors.toUnmodifiableMap(tableOptionInfo -> tableOptionInfo.name.toUpperCase(), Function.identity()));
    }

    static void checkDuplicates(Map<String, TableOptionInfo<?>> tableOptionInfos0, Map<String, TableOptionInfo<?>> tableOptionInfos1) {
        for (String id : tableOptionInfos1.keySet()) {
            if (!tableOptionInfos0.containsKey(id)) continue;
            throw new IllegalStateException("Duplicate id:" + id);
        }
    }

    private String deriveDataStorage(@Nullable SqlIdentifier engineName, PlanningContext ctx) {
        if (engineName == null) {
            String defaultDataStorage = this.defaultDataStorageSupplier.get();
            if (defaultDataStorage.equals("unknown")) {
                throw new SqlException(ErrorGroups.Sql.STORAGE_ENGINE_NOT_VALID_ERR, "Default data storage is not defined, query:" + ctx.query());
            }
            return defaultDataStorage;
        }
        assert (engineName.isSimple()) : engineName;
        String dataStorage = engineName.getSimple().toUpperCase();
        if (!this.dataStorageNames.containsKey(dataStorage)) {
            throw new SqlException(ErrorGroups.Sql.STORAGE_ENGINE_NOT_VALID_ERR, String.format("Unexpected data storage engine [engine=%s, expected=%s, query=%s]", dataStorage, this.dataStorageNames, ctx.query()));
        }
        return this.dataStorageNames.get(dataStorage);
    }

    private void processTableOption(TableOptionInfo tableOptionInfo, IgniteSqlCreateTableOption option, PlanningContext context, CreateTableCommand createTableCommand) {
        Object optionValue;
        assert (option.value() instanceof SqlLiteral) : option.value();
        try {
            optionValue = ((SqlLiteral)option.value()).getValueAs(tableOptionInfo.type);
        }
        catch (AssertionError | ClassCastException e) {
            throw new IgniteException(ErrorGroups.Sql.TABLE_OPTION_ERR, String.format("Unsuspected table option type [option=%s, expectedType=%s, query=%s]", option.key().getSimple(), tableOptionInfo.type.getSimpleName(), context.query()));
        }
        if (tableOptionInfo.validator != null) {
            try {
                tableOptionInfo.validator.accept(optionValue);
            }
            catch (Throwable e) {
                throw new IgniteException(ErrorGroups.Sql.TABLE_OPTION_ERR, String.format("Table option validation failed [option=%s, err=%s, query=%s]", option.key().getSimple(), e.getMessage(), context.query()), e);
            }
        }
        tableOptionInfo.setter.accept(createTableCommand, (CreateTableCommand)optionValue);
    }

    private void checkPositiveNumber(int num) {
        if (num < 0) {
            throw new IgniteException(ErrorGroups.Sql.TABLE_OPTION_ERR, "Must be positive:" + num);
        }
    }

    private TableOptionInfo<?> dataStorageFieldOptionInfo(Map.Entry<String, Class<?>> e) {
        return new TableOptionInfo<Object>(e.getKey(), e.getValue(), null, (cmd, o) -> cmd.addDataStorageOption((String)e.getKey(), o));
    }

    private CreateIndexCommand.Type convertIndexType(IgniteSqlIndexType type) {
        switch (type) {
            case TREE: 
            case IMPLICIT_TREE: {
                return CreateIndexCommand.Type.SORTED;
            }
            case HASH: {
                return CreateIndexCommand.Type.HASH;
            }
        }
        throw new AssertionError((Object)("Unknown index type [type=" + type + "]"));
    }

    private static Object fromLiteral(RelDataType columnType, SqlLiteral literal) {
        try {
            switch (columnType.getSqlTypeName()) {
                case VARCHAR: 
                case CHAR: {
                    return literal.getValueAs(String.class);
                }
                case DATE: {
                    return LocalDate.ofEpochDay(((DateString)literal.getValueAs(DateString.class)).getDaysSinceEpoch());
                }
                case TIME: {
                    return LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(((TimeString)literal.getValueAs(TimeString.class)).getMillisOfDay()));
                }
                case TIMESTAMP: {
                    TimestampString tsString = (TimestampString)literal.getValueAs(TimestampString.class);
                    return LocalDateTime.ofEpochSecond(TimeUnit.MILLISECONDS.toSeconds(tsString.getMillisSinceEpoch()), (int)TimeUnit.MILLISECONDS.toNanos(tsString.getMillisSinceEpoch() % 1000L), ZoneOffset.UTC);
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    throw new UnsupportedOperationException("https://issues.apache.org/jira/browse/IGNITE-17376");
                }
                case INTEGER: {
                    return literal.getValueAs(Integer.class);
                }
                case BIGINT: {
                    return literal.getValueAs(Long.class);
                }
                case SMALLINT: {
                    return literal.getValueAs(Short.class);
                }
                case TINYINT: {
                    return literal.getValueAs(Byte.class);
                }
                case DECIMAL: {
                    return literal.getValueAs(BigDecimal.class);
                }
                case DOUBLE: {
                    return literal.getValueAs(Double.class);
                }
                case REAL: 
                case FLOAT: {
                    return literal.getValueAs(Float.class);
                }
                case BINARY: 
                case VARBINARY: {
                    return literal.getValueAs(byte[].class);
                }
            }
            throw new IllegalStateException("Unknown type [type=" + columnType + "]");
        }
        catch (Throwable th) {
            throw new SqlException(ErrorGroups.Sql.SQL_TO_REL_CONVERSION_ERR, "Unable co convert literal", th);
        }
    }
}

