/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.DefaultValueGenerator;
import org.apache.ignite.internal.schema.DefaultValueProvider;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NativeTypes;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.configuration.ColumnTypeView;
import org.apache.ignite.internal.schema.configuration.ColumnView;
import org.apache.ignite.internal.schema.configuration.TableView;
import org.apache.ignite.internal.schema.configuration.ValueSerializationHelper;
import org.apache.ignite.internal.schema.configuration.defaultvalue.ColumnDefaultView;
import org.apache.ignite.internal.schema.configuration.defaultvalue.ConstantValueDefaultView;
import org.apache.ignite.internal.schema.configuration.defaultvalue.FunctionCallDefaultView;
import org.apache.ignite.internal.schema.configuration.defaultvalue.NullValueDefaultView;
import org.apache.ignite.internal.util.IgniteUtils;

public final class ConfigurationToSchemaDescriptorConverter {
    private static final Map<String, NativeType> FIX_SIZED_TYPES;

    public static NativeType convert(ColumnTypeView colTypeView) {
        String typeName = colTypeView.type().toUpperCase();
        NativeType res = FIX_SIZED_TYPES.get(typeName);
        if (res != null) {
            return res;
        }
        switch (typeName) {
            case "BITMASK": {
                int bitmaskLen = colTypeView.length();
                return NativeTypes.bitmaskOf(bitmaskLen);
            }
            case "STRING": {
                int strLen = colTypeView.length();
                return NativeTypes.stringOf(strLen);
            }
            case "BYTES": {
                int blobLen = colTypeView.length();
                return NativeTypes.blobOf(blobLen);
            }
            case "DECIMAL": {
                int prec = colTypeView.precision();
                int scale = colTypeView.scale();
                return NativeTypes.decimalOf(prec, scale);
            }
            case "NUMBER": {
                return NativeTypes.numberOf(colTypeView.precision());
            }
            case "TIME": {
                return NativeTypes.time(colTypeView.precision());
            }
            case "DATETIME": {
                return NativeTypes.datetime(colTypeView.precision());
            }
            case "TIMESTAMP": {
                return NativeTypes.timestamp(colTypeView.precision());
            }
        }
        throw new IllegalArgumentException("Unknown type " + typeName);
    }

    public static Column convert(int columnOrder, ColumnView columnView) {
        DefaultValueProvider defaultValueProvider;
        NativeType type = ConfigurationToSchemaDescriptorConverter.convert(columnView.type());
        ColumnDefaultView defaultValueView = columnView.defaultValueProvider();
        if (defaultValueView instanceof NullValueDefaultView) {
            defaultValueProvider = DefaultValueProvider.constantProvider(null);
        } else if (defaultValueView instanceof FunctionCallDefaultView) {
            defaultValueProvider = DefaultValueProvider.forValueGenerator(DefaultValueGenerator.valueOf(((FunctionCallDefaultView)defaultValueView).functionName()));
        } else if (defaultValueView instanceof ConstantValueDefaultView) {
            defaultValueProvider = DefaultValueProvider.constantProvider(ValueSerializationHelper.fromString(((ConstantValueDefaultView)defaultValueView).defaultValue(), type));
        } else {
            throw new IllegalStateException("Unknown value supplier class " + defaultValueView.getClass().getName());
        }
        return new Column(columnOrder, columnView.name(), type, columnView.nullable(), defaultValueProvider);
    }

    public static SchemaDescriptor convert(int schemaVer, TableView tableView) {
        Set<String> keyColumnsNames = Set.of(tableView.primaryKey().columns());
        ArrayList<Column> keyCols = new ArrayList<Column>(keyColumnsNames.size());
        ArrayList<Column> valCols = new ArrayList<Column>(tableView.columns().size() - keyColumnsNames.size());
        int idx = 0;
        for (String columnName : tableView.columns().namedListKeys()) {
            ColumnView column = (ColumnView)tableView.columns().get(columnName);
            if (column == null) continue;
            if (keyColumnsNames.contains(columnName)) {
                keyCols.add(ConfigurationToSchemaDescriptorConverter.convert(idx, column));
            } else {
                valCols.add(ConfigurationToSchemaDescriptorConverter.convert(idx, column));
            }
            ++idx;
        }
        return new SchemaDescriptor(schemaVer, (Column[])keyCols.toArray(Column[]::new), tableView.primaryKey().colocationColumns(), (Column[])valCols.toArray(Column[]::new));
    }

    private ConfigurationToSchemaDescriptorConverter() {
    }

    static {
        List types = IgniteUtils.collectStaticFields(NativeTypes.class, NativeType.class);
        HashMap<String, NativeType> tmp = new HashMap<String, NativeType>(types.size(), 1.0f);
        for (NativeType type : types) {
            if (!type.spec().fixedLength()) continue;
            tmp.put(type.spec().name(), type);
        }
        FIX_SIZED_TYPES = Map.copyOf(tmp);
    }
}

